/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator;

import com.rapidminer.Process;
import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.extension.processdefined.operator.CustomOperator;
import com.rapidminer.extension.processdefined.operator.CustomOperatorCache;
import com.rapidminer.extension.processdefined.operator.CustomOperatorPorts;
import com.rapidminer.extension.processdefined.operator.CustomOperatorUtils;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPortExtender;
import com.rapidminer.parameter.ParameterType;
import java.util.List;

public abstract class AbstractProcessDefinedOperator
extends Operator
implements CustomOperator {
    protected final CustomOperatorPorts customOperatorPorts = new CustomOperatorPorts(this);
    private Process cachedProcess;
    private CustomOperatorTemplate template;
    private ProcessSetupError cachedError = null;
    private boolean parallelExecution = false;

    AbstractProcessDefinedOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public Operator asOperator() {
        return this;
    }

    @Override
    public InputPortExtender getInputExtender() {
        return this.customOperatorPorts.getInputExtender();
    }

    @Override
    public OutputPortExtender getOutputExtender() {
        return this.customOperatorPorts.getOutputExtender();
    }

    @Override
    public Process getCachedProcess() {
        return this.cachedProcess;
    }

    @Override
    public void setCachedProcess(Process process) {
        this.cachedProcess = process;
    }

    @Override
    public CustomOperatorTemplate getCachedTemplate() {
        return this.template;
    }

    @Override
    public void setCachedTemplate(CustomOperatorTemplate template) {
        this.template = template;
    }

    @Override
    public ProcessSetupError getCachedError() {
        return this.cachedError;
    }

    @Override
    public void setCachedError(ProcessSetupError error) {
        this.cachedError = error;
    }

    @Override
    public void handleMetaDataAndPorts() {
        if (!this.asOperator().isDirty() && this.customOperatorPorts.isMetaDataAtPorts()) {
            return;
        }
        this.customOperatorPorts.transform();
    }

    protected void performAdditionalChecks() {
        super.performAdditionalChecks();
        CustomOperatorUtils.performAdditionalChecks(this);
    }

    public void doWork() throws OperatorException {
        this.doCustomWork();
    }

    public List<ParameterType> getParameterTypes() {
        return this.getParameterTypes(super.getParameterTypes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Process preprocessAfterLoading(Process process) {
        if (this.parallelExecution) {
            CustomOperatorCache.InnerCache<Process> innerCache = CustomOperatorCache.PROCESS_CACHE;
            synchronized (innerCache) {
                return (Process)process.clone();
            }
        }
        return (Process)process.clone();
    }

    public Operator cloneOperator(String name, boolean forParallelExecution) {
        AbstractProcessDefinedOperator clone = (AbstractProcessDefinedOperator)super.cloneOperator(name, forParallelExecution);
        clone.parallelExecution = forParallelExecution;
        return clone;
    }
}

