/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator;

import com.rapidminer.Process;
import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.extension.processdefined.operator.CustomOperator;
import com.rapidminer.extension.processdefined.operator.CustomOperatorCache;
import com.rapidminer.extension.processdefined.operator.CustomOperatorPorts;
import com.rapidminer.extension.processdefined.operator.CustomOperatorUtils;
import com.rapidminer.extension.processdefined.operator.CustomSubprocess;
import com.rapidminer.extension.processdefined.util.SubprocessInfo;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.PortUserError;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.error.ProcessExecutionUserErrorError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPortExtender;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.XMLException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSubProcessDefinedOperator
extends OperatorChain
implements CustomOperator {
    private final CustomOperatorPorts customOperatorPorts = new CustomOperatorPorts(this);
    private Process cachedProcess;
    private CustomOperatorTemplate template;
    private ProcessSetupError cachedError = null;
    private boolean parallelExecution = false;
    private Map<UserError, String> errorOrigins = null;

    AbstractSubProcessDefinedOperator(OperatorDescription description) {
        super(description, new String[0]);
    }

    @Override
    public void additionalStart() {
        CustomOperatorUtils.loadPortInfo(this);
        if (this.template != null) {
            List<SubprocessInfo> subprocessInfos = this.template.getSubprocessInfos();
            for (int i = 0; i < subprocessInfos.size(); ++i) {
                int i1;
                ExecutionUnit executionUnit = this.addSubprocess(i);
                executionUnit.setName(subprocessInfos.get(i).getName());
                for (i1 = 0; i1 < subprocessInfos.get(i).getInputs(); ++i1) {
                    executionUnit.getInnerSources().createPort("input" + (i1 + 1));
                }
                for (i1 = 0; i1 < subprocessInfos.get(i).getOutputs(); ++i1) {
                    executionUnit.getInnerSinks().createPort("result" + (i1 + 1));
                }
                this.makeDirtyOnUpdate((Observable)executionUnit.getInnerSinks());
            }
        }
    }

    @Override
    public void preprocessProcess(Process embeddedProcess) {
        List subprocesses = this.getSubprocesses();
        int subprocessIndex = 0;
        for (Operator innerOperator : embeddedProcess.getRootOperator().getSubprocess(0).getAllInnerOperators()) {
            if (!(innerOperator instanceof CustomSubprocess)) continue;
            ((CustomSubprocess)innerOperator).setSubprocess((ExecutionUnit)subprocesses.get(subprocessIndex++));
            if (subprocessIndex < subprocesses.size()) continue;
            break;
        }
    }

    @Override
    public Process getInnerProcess() {
        if (this.getCachedTemplate() == null) {
            return null;
        }
        try {
            Process templateProcess = this.getCachedTemplate().getProcess();
            templateProcess.getContext().setMacros(this.getCachedProcess().getContext().getMacros());
            this.replaceCustomSubprocesses(templateProcess);
            CustomOperatorUtils.setParametersSafe(templateProcess, this);
            return templateProcess;
        }
        catch (XMLException | IOException e) {
            return null;
        }
    }

    @Override
    public Operator asOperator() {
        return this;
    }

    @Override
    public InputPortExtender getInputExtender() {
        return this.customOperatorPorts.getInputExtender();
    }

    @Override
    public OutputPortExtender getOutputExtender() {
        return this.customOperatorPorts.getOutputExtender();
    }

    @Override
    public Process getCachedProcess() {
        return this.cachedProcess;
    }

    @Override
    public void setCachedProcess(Process process) {
        this.cachedProcess = process;
    }

    @Override
    public CustomOperatorTemplate getCachedTemplate() {
        return this.template;
    }

    @Override
    public void setCachedTemplate(CustomOperatorTemplate template) {
        this.template = template;
    }

    @Override
    public ProcessSetupError getCachedError() {
        return this.cachedError;
    }

    @Override
    public void setCachedError(ProcessSetupError error) {
        this.cachedError = error;
    }

    @Override
    public void handleMetaDataAndPorts() {
        this.customOperatorPorts.transform();
    }

    protected void performAdditionalChecks() {
        super.performAdditionalChecks();
        CustomOperatorUtils.performAdditionalChecks(this);
    }

    public Operator cloneOperator(String name, boolean forParallelExecution) {
        AbstractSubProcessDefinedOperator clone = (AbstractSubProcessDefinedOperator)super.cloneOperator(name, forParallelExecution);
        clone.parallelExecution = forParallelExecution;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Process preprocessAfterLoading(Process process) {
        if (this.parallelExecution) {
            CustomOperatorCache.InnerCache<Process> innerCache = CustomOperatorCache.PROCESS_CACHE;
            synchronized (innerCache) {
                return (Process)process.clone();
            }
        }
        return (Process)process.clone();
    }

    public void doWork() throws OperatorException {
        try {
            this.doCustomWork();
        }
        catch (ProcessExecutionUserErrorError e) {
            String causingOperator;
            UserError userError = e.getUserError();
            if (userError.getOperator() instanceof CustomSubprocess && (causingOperator = this.getCausingOperator(userError)) != null) {
                PortUserError portError;
                Operator replaceOperator = this.getProcess().getOperator(causingOperator);
                userError.setOperator(replaceOperator);
                if (userError instanceof PortUserError && (portError = (PortUserError)userError).getPort() != null && portError.getPort().getName() != null) {
                    portError.setPort(replaceOperator.getInputPorts().getPortByName(portError.getPort().getName()));
                }
                throw userError;
            }
            throw e;
        }
        finally {
            this.clearErrorOrigins();
        }
    }

    synchronized void setErrorOrigin(UserError e, String causingOperatorName) {
        if (this.errorOrigins == null) {
            this.errorOrigins = new IdentityHashMap<UserError, String>();
        }
        this.errorOrigins.put(e, causingOperatorName);
    }

    private synchronized void clearErrorOrigins() {
        this.errorOrigins = null;
    }

    private synchronized String getCausingOperator(UserError e) {
        return this.errorOrigins.get((Object)e);
    }

    public List<ParameterType> getParameterTypes() {
        return this.getParameterTypes(super.getParameterTypes());
    }

    private void replaceCustomSubprocesses(Process templateProcess) {
        for (Operator innerOperator : templateProcess.getRootOperator().getSubprocess(0).getAllInnerOperators()) {
            if (!(innerOperator instanceof CustomSubprocess)) continue;
            for (Operator childOperator : ((CustomSubprocess)innerOperator).getSubprocess(0).getChildOperators()) {
                childOperator.remove();
            }
            for (InputPort allPort : ((CustomSubprocess)innerOperator).getSubprocess(0).getInnerSinks().getAllPorts()) {
                if (!allPort.isConnected()) continue;
                allPort.disconnect();
            }
        }
        List subprocesses = ((OperatorChain)this.cloneOperator("name", false)).getSubprocesses();
        int subprocessIndex = 0;
        for (Operator innerOperator : templateProcess.getRootOperator().getSubprocess(0).getAllInnerOperators()) {
            if (!(innerOperator instanceof CustomSubprocess)) continue;
            CustomSubprocess customSubprocess = (CustomSubprocess)innerOperator;
            ExecutionUnit subprocess = (ExecutionUnit)subprocesses.get(subprocessIndex++);
            this.moveAndRewireOperators(customSubprocess, subprocess);
            if (subprocessIndex < subprocesses.size()) continue;
            break;
        }
    }

    private void moveAndRewireOperators(CustomSubprocess subProcessOperator, ExecutionUnit origin) {
        Map<Integer, InputPort> inConnections = this.getInConnections(origin);
        Map<Integer, OutputPort> outConnections = this.getOutConnections(origin);
        Map<Integer, Integer> throughConnections = this.getThroughConnections(origin, inConnections.keySet());
        ArrayList selectedOperators = new ArrayList(origin.getChildOperators());
        for (Operator op : selectedOperators) {
            op.removeAndKeepConnections(selectedOperators);
            subProcessOperator.getSubprocess(0).addOperator(op);
        }
        subProcessOperator.ensureNumberOfPorts(origin.getInnerSources().getNumberOfPorts(), origin.getInnerSinks().getNumberOfPorts());
        ExecutionUnit subprocess = subProcessOperator.getSubprocess(0);
        this.connect(inConnections, outConnections, throughConnections, subprocess);
    }

    private void connect(Map<Integer, InputPort> inConnections, Map<Integer, OutputPort> outConnections, Map<Integer, Integer> throughConnections, ExecutionUnit subprocess) {
        for (Map.Entry<Integer, InputPort> entry : inConnections.entrySet()) {
            ((OutputPort)subprocess.getInnerSources().getPortByIndex(entry.getKey().intValue())).connectTo(entry.getValue());
        }
        for (Map.Entry<Integer, InputPort> entry : outConnections.entrySet()) {
            ((InputPort)subprocess.getInnerSinks().getPortByIndex(entry.getKey().intValue())).connectTo((OutputPort)entry.getValue());
        }
        for (Map.Entry<Integer, Object> entry : throughConnections.entrySet()) {
            ((OutputPort)subprocess.getInnerSources().getPortByIndex(entry.getKey().intValue())).connectTo((InputPort)subprocess.getInnerSinks().getPortByIndex(((Integer)entry.getValue()).intValue()));
        }
    }

    private Map<Integer, InputPort> getInConnections(ExecutionUnit origin) {
        LinkedHashMap<Integer, InputPort> connections = new LinkedHashMap<Integer, InputPort>();
        HashSet sinkPorts = new HashSet(origin.getInnerSinks().getAllPorts());
        for (int i = 0; i < origin.getInnerSources().getNumberOfPorts(); ++i) {
            InputPort opposite;
            OutputPort portByIndex = (OutputPort)origin.getInnerSources().getPortByIndex(i);
            if (!portByIndex.isConnected() || sinkPorts.contains(opposite = portByIndex.getOpposite())) continue;
            connections.put(i, opposite);
            opposite.lock();
            opposite.disconnect();
            opposite.unlock();
        }
        return connections;
    }

    private Map<Integer, OutputPort> getOutConnections(ExecutionUnit origin) {
        LinkedHashMap<Integer, OutputPort> connections = new LinkedHashMap<Integer, OutputPort>();
        HashSet sourcePorts = new HashSet(origin.getInnerSources().getAllPorts());
        for (int i = 0; i < origin.getInnerSinks().getNumberOfPorts(); ++i) {
            OutputPort opposite;
            InputPort portByIndex = (InputPort)origin.getInnerSinks().getPortByIndex(i);
            if (!portByIndex.isConnected() || sourcePorts.contains(opposite = portByIndex.getOpposite())) continue;
            connections.put(i, opposite);
            opposite.lock();
            opposite.disconnect();
            opposite.unlock();
        }
        return connections;
    }

    private Map<Integer, Integer> getThroughConnections(ExecutionUnit origin, Set<Integer> ignore) {
        LinkedHashMap<Integer, Integer> connections = new LinkedHashMap<Integer, Integer>();
        List sinkPorts = origin.getInnerSinks().getAllPorts();
        for (int i = 0; i < origin.getInnerSources().getNumberOfPorts(); ++i) {
            InputPort opposite;
            int index;
            OutputPort portByIndex;
            if (ignore.contains(i) || !(portByIndex = (OutputPort)origin.getInnerSources().getPortByIndex(i)).isConnected() || (index = sinkPorts.indexOf(opposite = portByIndex.getOpposite())) < 0) continue;
            connections.put(i, index);
        }
        return connections;
    }
}

