/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator;

import com.rapidminer.Process;
import com.rapidminer.ProcessStateListener;
import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.extension.processdefined.operator.CustomOperatorUtils;
import com.rapidminer.extension.processdefined.operator.OpenableCustomOperator;
import com.rapidminer.extension.processdefined.operator.progress.CustomOperatorProgress;
import com.rapidminer.extension.processdefined.util.CustomModuleUtils;
import com.rapidminer.extension.processdefined.util.CustomParameterInfo;
import com.rapidminer.extension.processdefined.util.MacroUtils;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.ExecutionMode;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserData;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.error.ProcessExecutionOperatorExceptionError;
import com.rapidminer.operator.error.ProcessExecutionUserErrorError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPortExtender;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ProcessTools;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.XMLException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;

interface CustomOperator
extends OpenableCustomOperator {
    public static final String MESSAGE_PROCESS_LOADING_FAILED = "cannot_load_included_process";

    public Operator asOperator();

    public InputPortExtender getInputExtender();

    public OutputPortExtender getOutputExtender();

    public Process getCachedProcess();

    public void setCachedProcess(Process var1);

    public CustomOperatorTemplate getCachedTemplate();

    public void setCachedTemplate(CustomOperatorTemplate var1);

    public ProcessSetupError getCachedError();

    public void setCachedError(ProcessSetupError var1);

    public String getPathForError();

    public CustomOperatorTemplate loadTemplate() throws IOException;

    @Override
    default public boolean isHidden() {
        return false;
    }

    default public void start() {
        this.getInputExtender().start();
        this.getOutputExtender().start();
        this.additionalStart();
        this.asOperator().getTransformer().addRule(this::handleMetaDataAndPorts);
        CustomOperatorUtils.loadPortInfo(this);
        this.getInputExtender().ensureMinimumNumberOfPorts(0);
        this.getOutputExtender().ensureMinimumNumberOfPorts(0);
    }

    default public void additionalStart() {
    }

    public void handleMetaDataAndPorts();

    default public int updateOptimalNumberOfPorts(int number, Process innerProcess, boolean isInput) {
        return number;
    }

    default public List<MetaData> modifyInputMetaDataList(List<MetaData> inputMetaData) {
        return inputMetaData;
    }

    default public IOContainer modifyInputDataList(IOContainer input) {
        return input;
    }

    default public void handleAdditionalMetaDataOutput(Iterator<MetaData> resultIterator) {
    }

    default public void handleAdditionalOutput(Iterator<IOObject> resultIterator) {
    }

    default public Process registerProcessFromCache(Process process) {
        return process;
    }

    default public Process modifyTemplateProcess(Process templateProcess) {
        return templateProcess;
    }

    @Override
    default public void openProcess() {
        if (this.isHidden()) {
            return;
        }
        if (!RapidMinerGUI.getMainFrame().close()) {
            return;
        }
        final CustomOperator operator = this;
        new ProgressThread("open_process"){

            public void run() {
                try {
                    Process templateProcess = CustomOperator.this.getInnerProcess();
                    if (templateProcess == null) {
                        SwingTools.showVerySimpleErrorMessage((String)"cannot_open_custom_operator", (Object[])new Object[]{"Cannot load process"});
                    } else {
                        RapidMinerGUI.getMainFrame().setOpenedProcess(templateProcess);
                        if (operator.isArrangeProcessLayout()) {
                            CustomModuleUtils.arrangeProcessLayout((Operator)templateProcess.getRootOperator());
                        }
                    }
                }
                catch (RuntimeException e) {
                    SwingTools.showSimpleErrorMessage((String)"cannot_open_custom_operator", (Throwable)e, (Object[])new Object[]{e.getMessage()});
                }
            }
        }.start();
    }

    default public boolean isArrangeProcessLayout() {
        return false;
    }

    default public Process getInnerProcess() {
        if (this.getCachedTemplate() == null) {
            return null;
        }
        try {
            Process templateProcess = this.getProcessForOpenInnerProcess();
            templateProcess.getContext().setMacros(this.getCachedProcess().getContext().getMacros());
            CustomOperatorUtils.setParametersSafe(templateProcess, this);
            return templateProcess;
        }
        catch (UndefinedParameterError | XMLException | IOException e) {
            return null;
        }
    }

    default public Process getProcessForOpenInnerProcess() throws XMLException, IOException, UndefinedParameterError {
        return this.getCachedTemplate().getProcess();
    }

    default public Process getProcessForMetaData() {
        return (Process)this.getCachedProcess().clone();
    }

    default public void doCustomWork() throws OperatorException {
        Process embeddedProcess;
        Operator operator = this.asOperator();
        Process outerProcess = operator.getProcess();
        try {
            embeddedProcess = CustomOperatorUtils.loadIncludedProcess(this);
            embeddedProcess = this.preprocessAfterLoading(embeddedProcess);
            if (outerProcess != null) {
                ProcessTools.setParentProcess((Process)embeddedProcess, (Process)outerProcess);
                outerProcess.copyProcessFlowListenersToOtherProcess(embeddedProcess);
                embeddedProcess.setIOObjectCache(outerProcess.getIOObjectCache());
                UserData concurrencyContext = outerProcess.getRootOperator().getUserData("com.rapidminer.core.concurrency.OverridingConcurrencyContext");
                embeddedProcess.getRootOperator().setUserData("com.rapidminer.core.concurrency.OverridingConcurrencyContext", concurrencyContext);
                UserData concurrencyContext2 = outerProcess.getRootOperator().getUserData("com.rapidminer.core.concurrency.ContextUserData");
                embeddedProcess.getRootOperator().setUserData("com.rapidminer.core.concurrency.ContextUserData", concurrencyContext2);
                embeddedProcess.setDepth(outerProcess.getDepth() + 1);
                int maxDepth = CustomOperatorUtils.getMaxDepth();
                if (embeddedProcess.getDepth() > maxDepth) {
                    throw new UserError(operator, 969, new Object[]{maxDepth});
                }
            }
        }
        catch (IOException e) {
            throw new UserError(operator, (Throwable)e, "process_defined_operator.loading_error", new Object[]{this.getPathForError(), e.getMessage()});
        }
        ProcessStateListener processStopListener = CustomOperatorUtils.addStopListener(outerProcess, embeddedProcess);
        this.preprocessProcess(embeddedProcess);
        if (this.getCachedTemplate().getsRandomSeed()) {
            embeddedProcess.getRootOperator().setParameter("random_seed", String.valueOf(RandomGenerator.getRandomGenerator((Process)operator.getProcess(), (int)-1).nextInt()));
        }
        embeddedProcess.getRootOperator().setParameter("logverbosity", operator.getProcess().getRootOperator().getParameter("logverbosity"));
        CustomOperatorUtils.setParameters(embeddedProcess, this);
        embeddedProcess.getRootOperator().setUserData("process_defined_operators.custom_progress", (UserData)new CustomOperatorProgress(operator.getProgress()));
        embeddedProcess.setProcessLocation(operator.getProcess().getProcessLocation());
        IOContainer result = null;
        try {
            embeddedProcess.setOmitNullResults(false);
            IOContainer input = new IOContainer();
            ListIterator inputs = this.getInputExtender().getManagedPorts().listIterator(this.getInputExtender().getManagedPorts().size());
            while (inputs.hasPrevious()) {
                input = input.append(((InputPort)inputs.previous()).getDataOrNull(IOObject.class));
            }
            input = this.modifyInputDataList(input);
            result = embeddedProcess.run(input, -1, MacroUtils.getOtherMacros(outerProcess, embeddedProcess), false);
            Iterator<IOObject> results = result.asList().iterator();
            Iterator outputs = this.getOutputExtender().getManagedPorts().iterator();
            while (results.hasNext() && outputs.hasNext()) {
                IOObject nextResult = results.next();
                if (nextResult != null) {
                    nextResult.setSource(operator.getName());
                }
                ((OutputPort)outputs.next()).deliver(nextResult);
            }
            this.handleAdditionalOutput(results);
        }
        catch (OpenableCustomOperator.VisibleUserError e) {
            e.setOperator(operator);
            throw e;
        }
        catch (UserError e) {
            if (e instanceof ProcessExecutionUserErrorError) {
                UserError toCheck = e;
                while (toCheck instanceof ProcessExecutionUserErrorError) {
                    UserError userError = ((ProcessExecutionUserErrorError)((Object)toCheck)).getUserError();
                    if (userError instanceof OpenableCustomOperator.VisibleUserError) {
                        userError.setOperator(operator);
                        throw userError;
                    }
                    toCheck = userError;
                }
            }
            if (this.isHidden()) {
                throw new UserError(operator, "process_defined_operator.hidden_inner_error", new Object[]{"Hidden error of defining process", operator.getOperatorDescription().getProviderName()});
            }
            throw new ProcessExecutionUserErrorError(operator, e);
        }
        catch (OperatorException e) {
            if (this.isHidden()) {
                throw new UserError(operator, "process_defined_operator.hidden_inner_error", new Object[]{e.getMessage(), operator.getOperatorDescription().getProviderName()});
            }
            throw new ProcessExecutionOperatorExceptionError(operator, e);
        }
        finally {
            if (outerProcess != null) {
                outerProcess.removeProcessStateListener(processStopListener);
            }
            embeddedProcess.getRootOperator().setUserData("process_defined_operators.custom_progress", null);
            embeddedProcess.setProcessLocation(null);
            embeddedProcess.setCurrentOperator(null);
            embeddedProcess.clearReportStreams();
            embeddedProcess.clearMacros();
            embeddedProcess.clearStorage();
            if (embeddedProcess.getExecutionMode() != ExecutionMode.ONLY_DIRTY) {
                embeddedProcess.getRootOperator().clear(4);
            }
        }
    }

    default public Process preprocessAfterLoading(Process process) {
        return process;
    }

    default public void preprocessProcess(Process embeddedProcess) {
    }

    default public boolean loadProcessForParameters() {
        return false;
    }

    default public List<ParameterType> getParameterTypes(List<ParameterType> types) {
        Operator operator = this.asOperator();
        try {
            if (this.getCachedTemplate() == null) {
                this.setCachedTemplate(CustomOperatorUtils.fetchTemplate(this));
            }
        }
        catch (IOException e) {
            operator.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, operator.getPortOwner(), MESSAGE_PROCESS_LOADING_FAILED, new Object[]{e.getMessage()}));
            operator.getLogger().log(Level.SEVERE, "Failed to load definition of inner process", e);
            return types;
        }
        if (this.getCachedTemplate() != null && (!this.getCachedTemplate().getParameters().isEmpty() || this.loadProcessForParameters())) {
            try {
                if (this.getCachedProcess() == null) {
                    CustomOperatorUtils.loadIncludedProcess(this);
                }
            }
            catch (IOException e) {
                operator.getLogger().log(Level.SEVERE, "Failed to load embedded process", e);
                return types;
            }
            catch (StackOverflowError e) {
                return types;
            }
            for (CustomParameterInfo parameterInfo : this.getCachedTemplate().getParameters()) {
                CustomOperatorUtils.addToParameters(types, parameterInfo, this.getCachedTemplate().definesOptionals(), this.getCachedProcess(), operator);
            }
        }
        return types;
    }

    @Override
    default public Process getOpenableInnerProcess() {
        if (this.isHidden()) {
            return null;
        }
        Process templateProcess = this.getInnerProcess();
        if (templateProcess == null) {
            try {
                if (this.getCachedTemplate() == null) {
                    this.setCachedTemplate(CustomOperatorUtils.fetchTemplate(this));
                }
            }
            catch (IOException e) {
                LogService.getRoot().log(Level.SEVERE, "Failed to load definition of custom operator", e);
                return null;
            }
            templateProcess = this.getInnerProcess();
        }
        return templateProcess;
    }
}

