/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator;

import com.rapidminer.Process;
import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.operator.DummyOperator;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.parameter.ParameterChangeListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;

public enum CustomOperatorCache {

    private static int cacheSize = CustomOperatorCache.getSizeFromSettings();
    static final InnerCache<Process> PROCESS_CACHE;
    static final InnerCache<CustomOperatorTemplate> TEMPLATE_CACHE;

    private static int getSizeFromSettings() {
        int size = 20;
        String sizeString = ParameterService.getParameterValue((String)"rapidminer.custom_operators.cache_size");
        try {
            size = Integer.parseInt(sizeString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return size;
    }

    public static void clear() {
        ((InnerCache)CustomOperatorCache.TEMPLATE_CACHE).clear();
        ((InnerCache)CustomOperatorCache.PROCESS_CACHE).clear();
    }

    private static void adjustSizes() {
        ((InnerCache)CustomOperatorCache.TEMPLATE_CACHE).adjustSize();
        ((InnerCache)CustomOperatorCache.PROCESS_CACHE).adjustSize();
    }

    public static void clearBrokenProcesses() {
        ((InnerCache)CustomOperatorCache.PROCESS_CACHE).removeValuesIf(CustomOperatorCache::isProcessBroken);
    }

    private static boolean isProcessBroken(Process process) {
        for (Operator op : process.getRootOperator().getAllInnerOperators()) {
            if (!(op instanceof DummyOperator)) continue;
            return true;
        }
        return false;
    }

    static {
        ParameterService.registerParameterChangeListener((ParameterChangeListener)new ParameterChangeListener(){

            public void informParameterChanged(String key, String value) {
                if ("rapidminer.custom_operators.cache_size".equals(key)) {
                    int oldSize = cacheSize;
                    cacheSize = CustomOperatorCache.getSizeFromSettings();
                    if (cacheSize < oldSize) {
                        CustomOperatorCache.adjustSizes();
                    }
                }
            }

            public void informParameterSaved() {
            }
        });
        PROCESS_CACHE = new InnerCache();
        TEMPLATE_CACHE = new InnerCache();
    }

    static class InnerCache<T> {
        private final Map<String, T> cache = new LinkedHashMap<String, T>(CustomOperatorCache.access$000(), 0.5f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, T> eldest) {
                return this.size() >= cacheSize;
            }
        };

        InnerCache() {
        }

        synchronized T get(String identifier) {
            return this.cache.get(identifier);
        }

        synchronized void put(String location, T value) {
            this.cache.put(location, value);
        }

        private synchronized void adjustSize() {
            Iterator<Map.Entry<String, T>> iterator = this.cache.entrySet().iterator();
            while (iterator.hasNext() && this.cache.size() > cacheSize) {
                iterator.next();
                iterator.remove();
            }
        }

        private synchronized void clear() {
            this.cache.clear();
        }

        private synchronized void removeValuesIf(Predicate<T> filter) {
            this.cache.values().removeIf(filter);
        }
    }
}

