/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator;

import com.rapidminer.Process;
import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.extension.processdefined.operator.CustomOperator;
import com.rapidminer.extension.processdefined.operator.CustomOperatorUtils;
import com.rapidminer.extension.processdefined.util.CustomParameterInfo;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessRootOperator;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPortExtender;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.ProcessTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

class CustomOperatorPorts {
    private final InputPortExtender inputExtender;
    private final OutputPortExtender outputExtender;
    private int oldNumberOfInputs = 1;
    private int oldNumberOfOutputs = 1;
    private Process cachedMetaDataProcess;
    private List<MetaData> cachedMetaData;
    private final CustomOperator customOperator;

    CustomOperatorPorts(CustomOperator customOperator) {
        this.customOperator = customOperator;
        this.inputExtender = CustomOperatorPorts.createInputExtender(customOperator);
        this.outputExtender = CustomOperatorPorts.createOutputExtender(customOperator);
    }

    InputPortExtender getInputExtender() {
        return this.inputExtender;
    }

    OutputPortExtender getOutputExtender() {
        return this.outputExtender;
    }

    void transform() {
        this.setCachedMetadataAndError();
        this.updateOutputPorts();
    }

    void transformMetaData(ProcessRootOperator root) {
        List<MetaData> inputMetaData = new ArrayList<MetaData>();
        for (InputPort port : this.getInputExtender().getManagedPorts()) {
            inputMetaData.add(port.getRawMetaData());
        }
        inputMetaData = this.customOperator.modifyInputMetaDataList(inputMetaData);
        root.deliverInputMD(inputMetaData);
        root.transformMetaData();
        this.cachedMetaData = root.getResultMetaData();
    }

    boolean isMetaDataAtPorts() {
        List managedPorts = this.outputExtender.getManagedPorts();
        if (managedPorts.size() == 0) {
            return true;
        }
        if (this.cachedMetaData == null || this.cachedMetaData.size() == 0) {
            return false;
        }
        for (int i = 0; i < managedPorts.size(); ++i) {
            if (((OutputPort)managedPorts.get(i)).getRawMetaData() != null || this.cachedMetaData.size() <= i || this.cachedMetaData.get(i) == null) continue;
            return false;
        }
        return true;
    }

    private void setCachedMetadataAndError() {
        CustomOperatorUtils.addLoadingErrors(this.customOperator);
        if (this.customOperator.getCachedProcess() != null) {
            ProcessRootOperator root = this.customOperator.getCachedProcess().getRootOperator();
            this.checkInputPorts(root);
            this.checkOutputPorts(root);
            if ((this.customOperator.getCachedTemplate() == null || !this.customOperator.getCachedTemplate().hasNoRecursion()) && CustomOperatorPorts.doesProcessContainPossibleCircle(this.customOperator.asOperator(), this.customOperator.getCachedProcess())) {
                this.customOperator.asOperator().addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.customOperator.asOperator().getPortOwner(), "included_process_recursive_call", new Object[0]));
                if (!this.customOperator.asOperator().getOutputPorts().getAllPorts().isEmpty()) {
                    this.customOperator.asOperator().addError((ProcessSetupError)new SimpleMetaDataError(ProcessSetupError.Severity.INFORMATION, (Port)this.customOperator.asOperator().getOutputPorts().getAllPorts().get(0), "included_process_recursiv_call", new Object[0]));
                }
                for (OutputPort outputPort : this.customOperator.asOperator().getOutputPorts().getAllPorts()) {
                    outputPort.deliverMD(null);
                }
                return;
            }
            if (this.cachedMetaDataProcess == null) {
                this.cachedMetaDataProcess = this.getInnerProcessWithoutGUI();
            }
            Process process = this.cachedMetaDataProcess;
            this.customOperator.preprocessProcess(process);
            this.setChangedParametersSafe(process);
            ProcessTools.setParentProcess((Process)process, (Process)this.customOperator.asOperator().getProcess());
            this.transformMetaData(process.getRootOperator());
        } else {
            this.getInputExtender().ensureMinimumNumberOfPorts(0);
            this.getOutputExtender().ensureMinimumNumberOfPorts(0);
        }
    }

    private Process getInnerProcessWithoutGUI() {
        if (this.customOperator.getCachedProcess() == null) {
            return null;
        }
        Process process = this.customOperator.getProcessForMetaData();
        process.getContext().setMacros(this.customOperator.getCachedProcess().getContext().getMacros());
        CustomOperatorUtils.setParametersSafe(process, this.customOperator);
        return process;
    }

    private void updateOutputPorts() {
        if (this.cachedMetaData != null) {
            Iterator<MetaData> resultIterator = this.cachedMetaData.iterator();
            Iterator outputIterator = this.getOutputExtender().getManagedPorts().iterator();
            while (resultIterator.hasNext() && outputIterator.hasNext()) {
                ((OutputPort)outputIterator.next()).deliverMD(resultIterator.next());
            }
            this.customOperator.handleAdditionalMetaDataOutput(resultIterator);
        }
        if (this.customOperator.getCachedError() != null) {
            this.customOperator.asOperator().addError(this.customOperator.getCachedError());
        }
    }

    private void checkOutputPorts(ProcessRootOperator root) {
        List managedOutput;
        int delivers = root.getSubprocess(0).getInnerSinks().getNumberOfConnectedPorts();
        if (this.getOutputExtender().getManagedPorts().size() < delivers || delivers != this.oldNumberOfOutputs) {
            this.getOutputExtender().ensureMinimumNumberOfPorts(0);
            this.oldNumberOfOutputs = delivers;
        }
        if ((managedOutput = this.getOutputExtender().getManagedPorts()).size() >= delivers) {
            for (int index = managedOutput.size() - 1; index >= delivers; --index) {
                if (!((OutputPort)managedOutput.get(index)).isConnected()) continue;
                this.customOperator.asOperator().addError((ProcessSetupError)new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)managedOutput.get(index), "included_process_input_unused", new Object[0]));
            }
        }
    }

    private void checkInputPorts(ProcessRootOperator root) {
        int requires = root.getSubprocess(0).getInnerSources().getNumberOfConnectedPorts();
        if (this.getInputExtender().getManagedPorts().size() < requires || requires != this.oldNumberOfInputs) {
            this.getInputExtender().ensureMinimumNumberOfPorts(0);
            this.oldNumberOfInputs = requires;
        }
        List managedInput = this.getInputExtender().getManagedPorts();
        for (int index = managedInput.size() - 1; index >= requires; --index) {
            if (!((InputPort)managedInput.get(index)).isConnected()) continue;
            this.customOperator.asOperator().addError((ProcessSetupError)new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)managedInput.get(index), "included_process_input_unused", new Object[0]));
        }
    }

    private void setChangedParametersSafe(Process process) {
        for (CustomParameterInfo parameterInfo : this.customOperator.getCachedTemplate().getParameters()) {
            Operator operator;
            String value = null;
            try {
                value = this.customOperator.asOperator().getParameter(parameterInfo.getAlias());
            }
            catch (UndefinedParameterError undefinedParameterError) {
                value = "";
            }
            if ((operator = process.getOperator(parameterInfo.getOperator())) == null || !CustomOperatorPorts.notAlreadySet(parameterInfo, value, operator)) continue;
            operator.setParameter(parameterInfo.getParameter(), value);
        }
    }

    private static boolean notAlreadySet(CustomParameterInfo parameterInfo, String value, Operator operator) {
        try {
            return !Objects.equals(value, operator.getParameter(parameterInfo.getParameter()));
        }
        catch (UndefinedParameterError undefinedParameterError) {
            return true;
        }
    }

    private static boolean doesProcessContainPossibleCircle(Operator operator, Process process) {
        HashSet<String> dependencySet = new HashSet<String>();
        dependencySet.add(operator.getOperatorDescription().getKey());
        return CustomOperatorPorts.containsCircle(dependencySet, process);
    }

    private static boolean containsCircle(Set<String> dependencySet, Process process) {
        for (Operator op : process.getAllOperators()) {
            if (!(op instanceof CustomOperator)) continue;
            try {
                Process embeddedProcess = CustomOperatorUtils.loadIncludedProcess((CustomOperator)op);
                String embeddedName = op.getOperatorDescription().getKey();
                if (dependencySet.contains(embeddedName)) {
                    return true;
                }
                dependencySet.add(embeddedName);
                boolean containsCircle = CustomOperatorPorts.containsCircle(dependencySet, embeddedProcess);
                if (!containsCircle) continue;
                return true;
            }
            catch (IOException iOException) {
            }
        }
        return false;
    }

    private static InputPortExtender createInputExtender(final CustomOperator customOperator) {
        return new InputPortExtender("input", (Ports)customOperator.asOperator().getInputPorts()){
            private boolean inWork;
            {
                super(arg0, arg1);
                this.inWork = false;
            }

            protected void updatePorts() {
                if (!this.inWork) {
                    this.inWork = true;
                    int innerSources = this.getInnerSources();
                    if (this.minNumber > innerSources) {
                        innerSources = this.minNumber;
                    }
                    if (this.managedPorts.size() < innerSources) {
                        int numbOfPorts = this.managedPorts.size();
                        do {
                            this.managedPorts.add(this.createPort());
                        } while (++numbOfPorts < innerSources);
                    } else {
                        InputPort port;
                        ArrayList<InputPort> markedForDelete = new ArrayList<InputPort>();
                        for (int index = this.managedPorts.size() - 1; index >= innerSources && !(port = (InputPort)this.managedPorts.get(index)).isConnected() && !port.isLocked(); --index) {
                            markedForDelete.add(port);
                        }
                        for (InputPort inputPort : markedForDelete) {
                            this.managedPorts.remove(inputPort);
                            this.deletePort((Port)inputPort);
                        }
                    }
                    this.fixNames();
                    this.inWork = false;
                }
            }

            protected void fixNames() {
                CustomOperatorTemplate innerTemplate = customOperator.getCachedTemplate();
                if (innerTemplate == null || innerTemplate.getInputPortNames().isEmpty()) {
                    super.fixNames();
                } else {
                    int runningId = 0;
                    for (InputPort port : this.managedPorts) {
                        this.getPorts().renamePort((Port)port, this.getNamePrefix() + "_tmp_" + ++runningId);
                    }
                    List<String> inputPortNames = innerTemplate.getInputPortNames();
                    runningId = 0;
                    for (InputPort port : this.managedPorts) {
                        if (runningId < inputPortNames.size()) {
                            this.getPorts().renamePort((Port)port, inputPortNames.get(runningId));
                            ++runningId;
                            continue;
                        }
                        this.getPorts().renamePort((Port)port, this.getNamePrefix() + ++runningId);
                    }
                }
            }

            public void start() {
                super.start();
                for (InputPort port : new ArrayList(this.getManagedPorts())) {
                    this.managedPorts.remove(port);
                    this.deletePort((Port)port);
                }
            }

            private int getInnerSources() {
                CustomOperatorTemplate innerTemplate = customOperator.getCachedTemplate();
                if (innerTemplate == null) {
                    return CustomOperatorPorts.getDefaultNumberOfPorts(this.managedPorts);
                }
                int inputPorts = innerTemplate.getInputPorts();
                if (inputPorts >= 0) {
                    return inputPorts;
                }
                Process innerProcess = customOperator.getCachedProcess();
                int innerSources = innerProcess == null ? CustomOperatorPorts.getDefaultNumberOfPorts(this.managedPorts) : innerProcess.getRootOperator().getSubprocess(0).getInnerSources().getNumberOfConnectedPorts();
                return customOperator.updateOptimalNumberOfPorts(innerSources, innerProcess, true);
            }
        };
    }

    private static OutputPortExtender createOutputExtender(final CustomOperator customOperator) {
        return new OutputPortExtender("result", (Ports)customOperator.asOperator().getOutputPorts()){
            private boolean inWork;
            {
                super(arg0, arg1);
                this.inWork = false;
            }

            protected void updatePorts() {
                if (!this.inWork) {
                    this.inWork = true;
                    int innerSinks = this.getInnerSinks();
                    if (this.minNumber > innerSinks) {
                        innerSinks = this.minNumber;
                    }
                    if (this.managedPorts.size() < innerSinks) {
                        int numbOfPorts = this.managedPorts.size();
                        do {
                            this.managedPorts.add((OutputPort)this.createPort());
                        } while (++numbOfPorts < innerSinks);
                    } else {
                        OutputPort port;
                        ArrayList<OutputPort> markedForDelete = new ArrayList<OutputPort>();
                        for (int index = this.managedPorts.size() - 1; index >= innerSinks && !(port = (OutputPort)this.managedPorts.get(index)).isConnected() && !port.isLocked(); --index) {
                            markedForDelete.add(port);
                        }
                        for (OutputPort inputPort : markedForDelete) {
                            this.managedPorts.remove(inputPort);
                            this.deletePort((Port)inputPort);
                        }
                    }
                    this.fixNames();
                    this.inWork = false;
                }
            }

            protected void fixNames() {
                CustomOperatorTemplate innerTemplate = customOperator.getCachedTemplate();
                if (innerTemplate == null || innerTemplate.getOutputPortNames().isEmpty()) {
                    super.fixNames();
                } else {
                    int runningId = 0;
                    for (OutputPort port : this.managedPorts) {
                        this.getPorts().renamePort((Port)port, this.getNamePrefix() + "_tmp_" + ++runningId);
                    }
                    List<String> outputPortNames = innerTemplate.getOutputPortNames();
                    runningId = 0;
                    for (OutputPort port : this.managedPorts) {
                        if (runningId < outputPortNames.size()) {
                            this.getPorts().renamePort((Port)port, outputPortNames.get(runningId));
                            ++runningId;
                            continue;
                        }
                        this.getPorts().renamePort((Port)port, this.getNamePrefix() + ++runningId);
                    }
                }
            }

            public void start() {
                super.start();
                for (OutputPort port : new ArrayList(this.getManagedPorts())) {
                    this.managedPorts.remove(port);
                    this.deletePort((Port)port);
                }
            }

            private int getInnerSinks() {
                CustomOperatorTemplate innerTemplate = customOperator.getCachedTemplate();
                if (innerTemplate == null) {
                    return CustomOperatorPorts.getDefaultNumberOfPorts(this.managedPorts);
                }
                int outputPorts = innerTemplate.getOutputPorts();
                if (outputPorts >= 0) {
                    return outputPorts;
                }
                Process innerProcess = customOperator.getCachedProcess();
                int innerSinks = innerProcess == null ? CustomOperatorPorts.getDefaultNumberOfPorts(this.managedPorts) : innerProcess.getRootOperator().getSubprocess(0).getInnerSinks().getNumberOfConnectedPorts();
                return customOperator.updateOptimalNumberOfPorts(innerSinks, innerProcess, false);
            }
        };
    }

    private static int getDefaultNumberOfPorts(List<? extends Port> managedPorts) {
        int defaultNumberOfPorts = 0;
        for (int index = managedPorts.size() - 1; index >= 0; --index) {
            if (!managedPorts.get(index).isConnected()) continue;
            defaultNumberOfPorts = index + 1;
            break;
        }
        return defaultNumberOfPorts;
    }
}

