/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator;

import com.rapidminer.Process;
import com.rapidminer.ProcessStateListener;
import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.extension.processdefined.operator.CustomOperator;
import com.rapidminer.extension.processdefined.operator.CustomOperatorCache;
import com.rapidminer.extension.processdefined.operator.ParameterAttributeHelper;
import com.rapidminer.extension.processdefined.operator.parameter.AttributeSubsetParameterHelper;
import com.rapidminer.extension.processdefined.operator.parameter.CategoriesParameterHelper;
import com.rapidminer.extension.processdefined.operator.parameter.DoubleParameterHelper;
import com.rapidminer.extension.processdefined.operator.parameter.IntegerParameterHelper;
import com.rapidminer.extension.processdefined.operator.parameter.ProcessSuggestionParameterHelper;
import com.rapidminer.extension.processdefined.operator.parameter.RepositoryLocationParameterHelper;
import com.rapidminer.extension.processdefined.operator.parameter.TextParameterHelper;
import com.rapidminer.extension.processdefined.parameter.ParameterTypeHelperStringCategory;
import com.rapidminer.extension.processdefined.util.CustomParameterInfo;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.DummyOperator;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.ports.quickfix.AbstractQuickFix;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeAttributeSubset;
import com.rapidminer.parameter.ParameterTypeAttributes;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeConnectionLocation;
import com.rapidminer.parameter.ParameterTypeDirectory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeLinkButton;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeLong;
import com.rapidminer.parameter.ParameterTypeProcessLocation;
import com.rapidminer.parameter.ParameterTypeRegexp;
import com.rapidminer.parameter.ParameterTypeRepositoryLocation;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.ParameterTypeSuggestion;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualStringCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.ProcessTools;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.config.ParameterTypeConfigurable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;

enum CustomOperatorUtils {

    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();

    static ProcessStateListener addStopListener(Process process, final Process embeddedProcess) {
        ProcessStateListener processStopListener = new ProcessStateListener(){

            public void stopped(Process process) {
                if (embeddedProcess != null) {
                    embeddedProcess.stop();
                }
            }

            public void started(Process process) {
            }

            public void paused(Process process) {
                if (embeddedProcess != null) {
                    embeddedProcess.pause();
                }
            }

            public void resumed(Process process) {
                if (embeddedProcess != null) {
                    embeddedProcess.resume();
                }
            }
        };
        if (process != null) {
            process.addProcessStateListener(processStopListener);
        }
        return processStopListener;
    }

    static int getMaxDepth() {
        int maxDepth = 100;
        try {
            maxDepth = Integer.parseInt(ParameterService.getParameterValue((String)"rapidminer.general.max_process_execution_nesting_depth"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return maxDepth;
    }

    static Process fetchProcess(CustomOperator customOperator) throws IOException, XMLException {
        String identifier = customOperator.asOperator().getOperatorDescription().getKey();
        Process process = CustomOperatorCache.PROCESS_CACHE.get(identifier);
        if (process != null) {
            process = customOperator.registerProcessFromCache(process);
            return process;
        }
        Process templateProcess = customOperator.getCachedTemplate().getProcessWithoutGUI();
        templateProcess = customOperator.modifyTemplateProcess(templateProcess);
        CustomOperatorCache.PROCESS_CACHE.put(identifier, templateProcess);
        return templateProcess;
    }

    static CustomOperatorTemplate fetchTemplate(CustomOperator customOperator) throws IOException {
        String identifier = customOperator.asOperator().getOperatorDescription().getKey();
        CustomOperatorTemplate cachedTemplate = CustomOperatorCache.TEMPLATE_CACHE.get(identifier);
        if (cachedTemplate != null) {
            return cachedTemplate;
        }
        CustomOperatorTemplate operatorTemplate = customOperator.loadTemplate();
        CustomOperatorCache.TEMPLATE_CACHE.put(identifier, operatorTemplate);
        return operatorTemplate;
    }

    static void addToParameters(List<ParameterType> types, CustomParameterInfo parameterInfo, boolean definesOptionals, Process cachedProcess, Operator customOperator) {
        String paramKey = parameterInfo.getParameter();
        try {
            Operator operator = cachedProcess.getOperator(parameterInfo.getOperator());
            if (operator instanceof DummyOperator) {
                customOperator.getLogger().log(Level.SEVERE, "Failed to construct operator, required extension not installed?");
                types.add((ParameterType)new ParameterTypeString(parameterInfo.getAlias(), parameterInfo.getDocumentation() != null ? parameterInfo.getDocumentation() : "", "", false));
                return;
            }
            if (operator == null) {
                customOperator.getLogger().log(Level.SEVERE, "Failed to create operator, defining xml broken?");
                return;
            }
            ParameterType parameter = operator.getParameters().getParameterType(paramKey);
            if (parameter != null) {
                CustomOperatorUtils.handleParameters(operator, parameter, types, parameterInfo, definesOptionals, customOperator);
            } else {
                customOperator.getLogger().log(Level.WARNING, "Failed to find parameter " + paramKey);
            }
        }
        catch (UndefinedParameterError e) {
            customOperator.getLogger().log(Level.WARNING, "Failed to generate parameter " + paramKey, e);
        }
    }

    static void setParameters(Process process, CustomOperator customOperator) throws UndefinedParameterError {
        for (CustomParameterInfo parameterInfo : customOperator.getCachedTemplate().getParameters()) {
            String value = customOperator.asOperator().getParameter(parameterInfo.getAlias());
            Operator operator = process.getOperator(parameterInfo.getOperator());
            if (operator == null) continue;
            operator.setParameter(parameterInfo.getParameter(), value);
        }
    }

    static void setParametersSafe(Process process, CustomOperator customOperator) {
        for (CustomParameterInfo parameterInfo : customOperator.getCachedTemplate().getParameters()) {
            Operator operator;
            String value = null;
            try {
                value = customOperator.asOperator().getParameter(parameterInfo.getAlias());
            }
            catch (UndefinedParameterError undefinedParameterError) {
                value = "";
            }
            if ((operator = process.getOperator(parameterInfo.getOperator())) == null) continue;
            operator.setParameter(parameterInfo.getParameter(), value);
        }
    }

    static Process loadIncludedProcess(final CustomOperator customOperator) throws IOException {
        Process process;
        if (customOperator.getCachedProcess() != null) {
            return customOperator.getCachedProcess();
        }
        if (customOperator.getCachedTemplate() == null) {
            customOperator.setCachedTemplate(CustomOperatorUtils.fetchTemplate(customOperator));
        }
        try {
            process = CustomOperatorUtils.fetchProcess(customOperator);
            for (Operator op : process.getRootOperator().getAllInnerOperators()) {
                if (op instanceof DummyOperator) {
                    List<Object> fixes;
                    if (customOperator.isHidden()) {
                        fixes = Collections.emptyList();
                    } else {
                        AbstractQuickFix quickFix = new AbstractQuickFix(1, true, "open_defining_process", new Object[0]){

                            public void apply() {
                                int confirmation = SwingTools.showConfirmDialog((String)"custom_operator_extension.open_process", (int)0, (Object[])new Object[0]);
                                if (confirmation == 0) {
                                    customOperator.openProcess();
                                }
                            }
                        };
                        fixes = Collections.singletonList(quickFix);
                    }
                    SimpleProcessSetupError error = new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, customOperator.asOperator().getPortOwner(), fixes, "cannot_load_included_process", new Object[]{"Failed to construct operator, required extension not installed?"});
                    customOperator.setCachedError((ProcessSetupError)error);
                    customOperator.asOperator().addError((ProcessSetupError)error);
                }
                op.setBreakpoint(1, false);
                op.setBreakpoint(0, false);
            }
            ProcessTools.setProcessOrigin((Process)process);
        }
        catch (IOException e) {
            customOperator.asOperator().addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, customOperator.asOperator().getPortOwner(), "cannot_load_included_process", new Object[]{e.getMessage()}));
            throw e;
        }
        catch (XMLException e) {
            customOperator.asOperator().addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, customOperator.asOperator().getPortOwner(), "cannot_load_included_process", new Object[]{e.getMessage()}));
            throw new IOException("Cannot parse the defining process: " + e.getMessage(), e);
        }
        customOperator.setCachedProcess(process);
        return process;
    }

    static void performAdditionalChecks(CustomOperator customOperator) {
        if (customOperator.getCachedProcess() == null) {
            try {
                CustomOperatorUtils.loadIncludedProcess(customOperator);
            }
            catch (Exception e) {
                customOperator.setCachedError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, customOperator.asOperator().getPortOwner(), "cannot_load_included_process", new Object[]{e.getMessage()}));
                customOperator.asOperator().addError(customOperator.getCachedError());
            }
        } else if (customOperator.getCachedError() != null) {
            customOperator.asOperator().addError(customOperator.getCachedError());
        }
    }

    static void addLoadingErrors(CustomOperator customOperator) {
        CustomOperatorUtils.addTemplateLoadingErrors(customOperator);
        CustomOperatorUtils.addProcessLoadingErrors(customOperator);
    }

    static void loadPortInfo(CustomOperator customOperator) {
        CustomOperatorUtils.addTemplateLoadingErrors(customOperator);
        if (customOperator.getCachedTemplate() != null && (customOperator.getCachedTemplate().getInputPorts() < 0 || customOperator.getCachedTemplate().getOutputPorts() < 0)) {
            CustomOperatorUtils.addProcessLoadingErrors(customOperator);
        }
    }

    private static void addProcessLoadingErrors(CustomOperator customOperator) {
        if (customOperator.getCachedProcess() == null && customOperator.getCachedTemplate() != null) {
            try {
                CustomOperatorUtils.loadIncludedProcess(customOperator);
            }
            catch (Exception e) {
                customOperator.setCachedError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, customOperator.asOperator().getPortOwner(), "cannot_load_included_process", new Object[]{e.getMessage()}));
                customOperator.asOperator().addError(customOperator.getCachedError());
            }
        }
    }

    private static void addTemplateLoadingErrors(CustomOperator customOperator) {
        if (customOperator.getCachedTemplate() == null) {
            try {
                customOperator.setCachedTemplate(CustomOperatorUtils.fetchTemplate(customOperator));
            }
            catch (Exception e) {
                customOperator.setCachedError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, customOperator.asOperator().getPortOwner(), "cannot_load_custom_operator", new Object[]{e.getMessage()}));
                customOperator.asOperator().addError(customOperator.getCachedError());
            }
        }
    }

    private static void handleParameters(Operator operator, ParameterType parameterType, List<ParameterType> superParameters, CustomParameterInfo parameterInfo, boolean definesOptionals, Operator customOperator) throws UndefinedParameterError {
        Object newType = parameterType instanceof ParameterTypeAttributeSubset && operator instanceof AttributeSubsetParameterHelper ? ((AttributeSubsetParameterHelper)operator).createCustomParameter(parameterType, ParameterAttributeHelper.copyAttributeSubsetType((ParameterTypeAttributeSubset)parameterType, operator, customOperator)) : (parameterType instanceof ParameterTypeAttributeSubset ? ParameterAttributeHelper.copyAttributeSubsetType((ParameterTypeAttributeSubset)parameterType, operator, customOperator) : (parameterType instanceof ParameterTypeAttributes ? ParameterAttributeHelper.copyAttributesType((ParameterTypeAttributes)parameterType, operator, customOperator) : (parameterType instanceof ParameterTypeAttribute ? ParameterAttributeHelper.copyAttributeType((ParameterTypeAttribute)parameterType, operator, customOperator) : (parameterType instanceof ParameterTypeInt && operator instanceof IntegerParameterHelper ? ((IntegerParameterHelper)operator).createCustomParameter(parameterType) : (parameterType instanceof ParameterTypeDouble && operator instanceof DoubleParameterHelper ? ((DoubleParameterHelper)operator).createCustomParameter(parameterType) : (parameterType instanceof ParameterTypeHelperStringCategory && operator instanceof CategoriesParameterHelper ? ((CategoriesParameterHelper)operator).createCustomParameter(parameterType) : (parameterType instanceof ParameterTypeRepositoryLocation && operator instanceof RepositoryLocationParameterHelper ? ((RepositoryLocationParameterHelper)operator).createCustomParameter(parameterType) : (parameterType instanceof ParameterTypeText && operator instanceof TextParameterHelper ? ((TextParameterHelper)operator).createCustomParameter(parameterType) : (parameterType instanceof ParameterTypeSuggestion && operator instanceof ProcessSuggestionParameterHelper ? ((ProcessSuggestionParameterHelper)operator).createCustomParameter(parameterType, customOperator) : CustomOperatorUtils.copyParameter(parameterType))))))))));
        newType.setKey(parameterInfo.getAlias());
        String documentation = parameterInfo.getDocumentation();
        if (documentation != null) {
            newType.setDescription(documentation);
        }
        newType.setExpert(false);
        newType.getDependencyConditions().clear();
        if (definesOptionals) {
            newType.setOptional(parameterInfo.isOptional());
            newType.setExpert(parameterInfo.isExpert());
        } else {
            newType.setOptional(parameterType.isOptional());
        }
        try {
            newType.setDefaultValue((Object)operator.getParameter(parameterInfo.getParameter()));
        }
        catch (Exception e) {
            try {
                if (parameterType instanceof ParameterTypeBoolean) {
                    newType.setDefaultValue((Object)operator.getParameterAsBoolean(parameterInfo.getParameter()));
                } else if (parameterType instanceof ParameterTypeDouble) {
                    newType.setDefaultValue((Object)operator.getParameterAsDouble(parameterInfo.getParameter()));
                } else if (parameterType instanceof ParameterTypeInt) {
                    newType.setDefaultValue((Object)operator.getParameterAsInt(parameterInfo.getParameter()));
                } else if (parameterType instanceof ParameterTypeCategory) {
                    newType.setDefaultValue((Object)Math.max(operator.getParameterAsInt(parameterInfo.getParameter()), 0));
                } else if (parameterType instanceof ParameterTypeLong) {
                    newType.setDefaultValue((Object)operator.getParameterAsLong(parameterInfo.getParameter()));
                } else if (parameterType instanceof ParameterTypeList) {
                    newType.setDefaultValue((Object)ParameterTypeList.transformString2List((String)operator.getParameter(parameterInfo.getParameter())));
                }
            }
            catch (UndefinedParameterError undefinedParameterError) {
                // empty catch block
            }
        }
        if (parameterInfo.getDependency() != null) {
            boolean isMandatory = !newType.isOptional();
            newType.registerDependencyCondition((ParameterCondition)new EqualStringCondition((ParameterHandler)customOperator, (String)parameterInfo.getDependency().getFirst(), isMandatory, new String[]{(String)parameterInfo.getDependency().getSecond()}));
            newType.setOptional(true);
        }
        superParameters.add((ParameterType)newType);
    }

    private static ParameterType copyParameter(ParameterType parameterType) {
        try {
            return ParameterType.createType((Element)parameterType.getDefinitionAsXML(DOCUMENT_BUILDER_FACTORY.newDocumentBuilder().newDocument()));
        }
        catch (Exception e) {
            if (parameterType instanceof ParameterTypeProcessLocation) {
                ParameterTypeProcessLocation typeProcessLocation = (ParameterTypeProcessLocation)parameterType;
                return new ParameterTypeProcessLocation(parameterType.getKey(), parameterType.getDescription(), typeProcessLocation.isAllowEntries(), typeProcessLocation.isAllowFolders(), typeProcessLocation.isAllowAbsoluteEntries(), parameterType.isOptional(), typeProcessLocation.isEnforceValidRepositoryEntryName(), typeProcessLocation.isOnlyWriteableLocations());
            }
            if (parameterType instanceof ParameterTypeConnectionLocation) {
                return new ParameterTypeConnectionLocation(parameterType.getKey(), parameterType.getDescription(), ((ParameterTypeConnectionLocation)parameterType).getConnectionType());
            }
            if (parameterType instanceof ParameterTypeRepositoryLocation) {
                ParameterTypeRepositoryLocation typeRepositoryLocation = (ParameterTypeRepositoryLocation)parameterType;
                return new ParameterTypeRepositoryLocation(parameterType.getKey(), parameterType.getDescription(), typeRepositoryLocation.isAllowEntries(), typeRepositoryLocation.isAllowFolders(), typeRepositoryLocation.isAllowAbsoluteEntries(), parameterType.isOptional(), typeRepositoryLocation.isEnforceValidRepositoryEntryName(), typeRepositoryLocation.isOnlyWriteableLocations());
            }
            if (parameterType instanceof ParameterTypeDirectory) {
                return new ParameterTypeDirectory(parameterType.getKey(), parameterType.getDescription(), parameterType.isOptional());
            }
            if (parameterType instanceof ParameterTypeFile) {
                ParameterTypeFile parameterTypeFile = new ParameterTypeFile(parameterType.getKey(), parameterType.getDescription(), false, ((ParameterTypeFile)parameterType).getExtensions());
                parameterTypeFile.setAddAllFileExtensionsFilter(((ParameterTypeFile)parameterType).isAddAllFileExtensionsFilter());
                return parameterTypeFile;
            }
            if (parameterType instanceof ParameterTypeConfigurable) {
                return new ParameterTypeConfigurable(parameterType.getKey(), parameterType.getDescription(), ((ParameterTypeConfigurable)parameterType).getTypeId());
            }
            if (parameterType instanceof ParameterTypeList) {
                return new ParameterTypeList(parameterType.getKey(), parameterType.getDescription(), ((ParameterTypeList)parameterType).getKeyType(), ((ParameterTypeList)parameterType).getValueType());
            }
            if (parameterType instanceof ParameterTypeRegexp) {
                return new ParameterTypeRegexp(parameterType.getKey(), parameterType.getDescription());
            }
            if (parameterType instanceof ParameterTypeHelperStringCategory) {
                return new ParameterTypeStringCategory(parameterType.getKey(), parameterType.getDescription(), ((ParameterTypeHelperStringCategory)parameterType).getValues());
            }
            if (parameterType instanceof ParameterTypeLinkButton) {
                return new ParameterTypeLinkButton(parameterType.getKey(), parameterType.getDescription(), ((ParameterTypeLinkButton)parameterType).getAction(), ((ParameterTypeLinkButton)parameterType).isLocalAction());
            }
            if (parameterType instanceof ParameterTypeDouble) {
                ParameterTypeDouble parameterTypeDouble = (ParameterTypeDouble)parameterType;
                return new ParameterTypeDouble(parameterTypeDouble.getKey(), parameterTypeDouble.getDescription(), parameterTypeDouble.getMinValue(), parameterTypeDouble.getMaxValue(), parameterTypeDouble.getDefaultValue() != null ? (Double)parameterTypeDouble.getDefaultValue() : Double.NaN, parameterTypeDouble.isExpert());
            }
            return new ParameterTypeString(parameterType.getKey(), parameterType.getDescription(), "", parameterType.isExpert());
        }
    }
}

