/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator;

import com.rapidminer.extension.processdefined.operator.AbstractSubProcessDefinedOperator;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.MetaData;
import java.util.Iterator;
import java.util.logging.Level;

public class CustomSubprocess
extends OperatorChain {
    private ExecutionUnit executionUnit = this.addSubprocess(0);
    private PortPairExtender inputExtender = new PortPairExtender("in", this.getInputPorts(), this.executionUnit.getInnerSources());
    private PortPairExtender outputExtender = new PortPairExtender("out", this.executionUnit.getInnerSinks(), this.getOutputPorts());

    public CustomSubprocess(OperatorDescription description) {
        super(description, new String[0]);
        this.inputExtender.start();
        this.outputExtender.start();
        this.getTransformer().addRule(() -> {
            Iterator outputPortIterator = this.executionUnit.getInnerSources().getAllPorts().iterator();
            for (PortPairExtender.PortPair pair : this.inputExtender.getManagedPairs()) {
                if (!outputPortIterator.hasNext()) continue;
                MetaData inData = pair.getInputPort().getMetaData();
                if (inData != null) {
                    inData = inData.clone();
                    OutputPort outputPort = (OutputPort)outputPortIterator.next();
                    inData.addToHistory(outputPort);
                    outputPort.deliverMD(inData);
                    continue;
                }
                ((OutputPort)outputPortIterator.next()).deliverMD(null);
            }
        });
        this.getTransformer().addRule(() -> {
            for (Operator op : this.executionUnit.getAllInnerOperators()) {
                op.clear(1);
            }
            this.executionUnit.transformMetaData();
        });
        this.getTransformer().addRule(() -> {
            Iterator pairIterator = this.outputExtender.getManagedPairs().iterator();
            for (InputPort inputPort : this.executionUnit.getInnerSinks().getAllPorts()) {
                if (!pairIterator.hasNext()) continue;
                MetaData inData = inputPort.getMetaData();
                if (inData != null) {
                    inData = inData.clone();
                    OutputPort outputPort = ((PortPairExtender.PortPair)pairIterator.next()).getOutputPort();
                    inData.addToHistory(outputPort);
                    outputPort.deliverMD(inData);
                    continue;
                }
                ((PortPairExtender.PortPair)pairIterator.next()).getOutputPort().deliverMD(null);
            }
        });
    }

    public int getNumberOfInputs() {
        return this.inputExtender.getManagedPairs().size() - 1;
    }

    public int getNumberOfOutputs() {
        return this.outputExtender.getManagedPairs().size() - 1;
    }

    public void doWork() throws OperatorException {
        this.clearAllInnerSinks();
        ExecutionUnit unit = this.cloneExecutionUnit(this.executionUnit, this, true);
        Iterator outputPortIterator = unit.getInnerSources().getAllPorts().iterator();
        for (PortPairExtender.PortPair pair : this.inputExtender.getManagedPairs()) {
            IOObject data = pair.getInputPort().getRawData();
            if (!outputPortIterator.hasNext()) continue;
            ((OutputPort)outputPortIterator.next()).deliver(data);
        }
        try {
            unit.execute();
        }
        catch (UserError e) {
            if (e.getOperator() != this && this.executionUnit.getEnclosingOperator() != this) {
                Operator offendingOperator = e.getOperator();
                String offendingName = offendingOperator.getName();
                Iterator originalExecutionUnitIterator = this.executionUnit.getAllInnerOperators().iterator();
                for (Operator op : unit.getAllInnerOperators()) {
                    Operator original = (Operator)originalExecutionUnitIterator.next();
                    if (op != offendingOperator) continue;
                    if (op.getName().equals(original.getName())) break;
                    this.getLogger().log(Level.INFO, () -> "Operator renaming during execution: " + original.getName() + " was executed as " + op.getName());
                    offendingName = original.getName();
                    break;
                }
                if (this.executionUnit.getEnclosingOperator() instanceof AbstractSubProcessDefinedOperator) {
                    AbstractSubProcessDefinedOperator superOperator = (AbstractSubProcessDefinedOperator)this.executionUnit.getEnclosingOperator();
                    superOperator.setErrorOrigin(e, offendingName);
                }
                e.setOperator((Operator)this);
            }
            throw e;
        }
        Iterator pairIterator = this.outputExtender.getManagedPairs().iterator();
        for (InputPort inputPort : unit.getInnerSinks().getAllPorts()) {
            IOObject data = inputPort.getRawData();
            if (!pairIterator.hasNext()) continue;
            ((PortPairExtender.PortPair)pairIterator.next()).getOutputPort().deliver(data);
        }
    }

    void setSubprocess(ExecutionUnit executionUnit) {
        this.executionUnit = executionUnit;
    }

    void ensureNumberOfPorts(int input, int output) {
        this.inputExtender.ensureMinimumNumberOfPorts(input);
        this.outputExtender.ensureMinimumNumberOfPorts(output);
    }

    public Operator cloneOperator(String name, boolean forParallelExcecution) {
        CustomSubprocess clone = (CustomSubprocess)super.cloneOperator(name, forParallelExcecution);
        if (this.executionUnit.getEnclosingOperator() != this) {
            OperatorChain enclosingOperator = this.executionUnit.getEnclosingOperator();
            clone.executionUnit = this.cloneExecutionUnit(this.executionUnit, enclosingOperator, forParallelExcecution);
        }
        return clone;
    }

    private ExecutionUnit cloneExecutionUnit(ExecutionUnit original, OperatorChain parent, boolean forParallelExecution) {
        ExecutionUnit newUnit = new ExecutionUnit(parent, this.getName());
        for (String portName : original.getInnerSinks().getPortNames()) {
            newUnit.getInnerSinks().createPort(portName);
        }
        for (String portName : original.getInnerSources().getPortNames()) {
            newUnit.getInnerSources().createPort(portName);
        }
        newUnit.cloneExecutionUnitFrom(original, forParallelExecution);
        return newUnit;
    }
}

