/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator;

import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.extension.processdefined.ProcessDefinedOperators;
import com.rapidminer.extension.processdefined.operator.AbstractSubProcessDefinedOperator;
import com.rapidminer.extension.processdefined.operator.CustomOperatorDescription;
import com.rapidminer.extension.processdefined.operator.HiddenProcessDefinedOperator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.tools.plugin.Plugin;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.xml.sax.SAXException;

public class HiddenSubProcessDefinedOperator
extends AbstractSubProcessDefinedOperator {
    private final String resourcePath;
    private final Plugin plugin;

    public HiddenSubProcessDefinedOperator(OperatorDescription description) {
        super(description);
        if (!(description instanceof CustomOperatorDescription)) {
            throw new IllegalArgumentException("not custom operator description");
        }
        this.resourcePath = ((CustomOperatorDescription)description).getResourcePath();
        this.plugin = description.getProvider();
        this.start();
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public String getPathForError() {
        return this.resourcePath;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public CustomOperatorTemplate loadTemplate() throws IOException {
        if (this.resourcePath != null) {
            byte[] arr = HiddenProcessDefinedOperator.class.getSimpleName().getBytes(StandardCharsets.UTF_8);
            SecretKeySpec obfuscator = new SecretKeySpec(arr, 0, 16, "AES");
            try {
                Cipher ob = Cipher.getInstance("AES");
                ob.init(2, obfuscator);
                try (InputStream resourceInputStream = ProcessDefinedOperators.getResourceStream(this.resourcePath, this.plugin);){
                    CustomOperatorTemplate customOperatorTemplate;
                    try (CipherInputStream inputStream = new CipherInputStream(resourceInputStream, ob);){
                        customOperatorTemplate = new CustomOperatorTemplate(inputStream);
                    }
                    return customOperatorTemplate;
                }
            }
            catch (SAXException e) {
                throw new IOException("Cannot parse defining xml': " + e, e);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new IOException("Cannot deobfuscate defining xml': " + e, e);
            }
        }
        return null;
    }
}

