/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator;

import com.rapidminer.RapidMiner;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessRootOperator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.MetaDataChangeListener;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.MetaDataProvider;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeAttributeSubset;
import com.rapidminer.parameter.ParameterTypeAttributes;

enum ParameterAttributeHelper {


    static ParameterTypeAttribute copyAttributeType(ParameterTypeAttribute typeAttribute, Operator originalOperator, Operator customOperator) {
        return new ParameterTypeAttribute(typeAttribute.getKey(), typeAttribute.getDescription(), ParameterAttributeHelper.getMetaDataProvider(customOperator, ParameterAttributeHelper.getMetaDataPortIndex(originalOperator)), false, new int[]{0});
    }

    static ParameterTypeAttributes copyAttributesType(ParameterTypeAttributes typeAttributes, Operator originalOperator, Operator customOperator) {
        return new ParameterTypeAttributes(typeAttributes.getKey(), typeAttributes.getDescription(), ParameterAttributeHelper.getMetaDataProvider(customOperator, ParameterAttributeHelper.getMetaDataPortIndex(originalOperator)), false, new int[]{0});
    }

    static ParameterTypeAttributeSubset copyAttributeSubsetType(ParameterTypeAttributeSubset typeAttributes, Operator originalOperator, Operator customOperator) {
        return new ParameterTypeAttributeSubset(typeAttributes.getKey(), typeAttributes.getDescription(), ParameterAttributeHelper.getMetaDataProvider(customOperator, ParameterAttributeHelper.getMetaDataPortIndex(originalOperator)), false, new int[]{0});
    }

    private static int getMetaDataPortIndex(Operator op) {
        Operator operator = op;
        Operator previousOperator = op;
        while (!(previousOperator instanceof ProcessRootOperator)) {
            InputPorts inputPorts = previousOperator.getInputPorts();
            int numberOfPorts = inputPorts.getNumberOfPorts();
            if (numberOfPorts <= 0) {
                return -1;
            }
            OutputPort outputPort = ((InputPort)inputPorts.getPortByIndex(0)).getSource();
            if (outputPort == null) {
                return -1;
            }
            operator = previousOperator;
            previousOperator = outputPort.getPorts().getOwner().getOperator();
        }
        OutputPort source = ((InputPort)operator.getInputPorts().getPortByIndex(0)).getSource();
        String sourceName = source.getName();
        Ports ports = source.getPorts();
        for (int i = 0; i < ports.getNumberOfPorts(); ++i) {
            if (!ports.getPortByIndex(i).getName().equals(sourceName)) continue;
            return i;
        }
        return -1;
    }

    private static MetaDataProvider getMetaDataProvider(Operator customOperator, int portIndex) {
        if (RapidMiner.getVersion().isAtLeast(new VersionNumber(200, 0))) {
            InputPorts ports = customOperator.getInputPorts();
            InputPort port = null;
            if (portIndex >= 0 && ports.getNumberOfPorts() > portIndex) {
                port = (InputPort)ports.getPortByIndex(portIndex);
            }
            return new ParameterTypeAttribute.InputPortMetaDataProvider(port);
        }
        return new InputPortIndexMetaDataProvider(customOperator, portIndex);
    }

    private static final class InputPortIndexMetaDataProvider
    implements MetaDataProvider {
        private final Operator operator;
        private final int portIndex;

        private InputPortIndexMetaDataProvider(Operator operator, int portIndex) {
            this.operator = operator;
            this.portIndex = portIndex;
        }

        public MetaData getMetaData() {
            InputPorts ports = this.operator.getInputPorts();
            if (this.portIndex >= 0 && ports.getNumberOfPorts() > this.portIndex) {
                return ((InputPort)ports.getPortByIndex(this.portIndex)).getMetaData();
            }
            return null;
        }

        public void addMetaDataChangeListener(MetaDataChangeListener l) {
            InputPorts ports = this.operator.getInputPorts();
            if (this.portIndex >= 0 && ports.getNumberOfPorts() > this.portIndex) {
                ((InputPort)ports.getPortByIndex(this.portIndex)).registerMetaDataChangeListener(l);
            }
        }

        public void removeMetaDataChangeListener(MetaDataChangeListener l) {
            InputPorts ports = this.operator.getInputPorts();
            if (this.portIndex >= 0 && ports.getNumberOfPorts() > this.portIndex) {
                ((InputPort)ports.getPortByIndex(this.portIndex)).removeMetaDataChangeListener(l);
            }
        }
    }
}

