/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator;

import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.extension.processdefined.ProcessDefinedOperators;
import com.rapidminer.extension.processdefined.operator.AbstractSubProcessDefinedOperator;
import com.rapidminer.extension.processdefined.operator.CustomOperatorDescription;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.tools.plugin.Plugin;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.SAXException;

public class SubProcessDefinedOperator
extends AbstractSubProcessDefinedOperator {
    private final String resourcePath;
    private final Plugin plugin;

    public SubProcessDefinedOperator(OperatorDescription description) {
        super(description);
        if (!(description instanceof CustomOperatorDescription)) {
            throw new IllegalArgumentException("not custom operator description");
        }
        this.resourcePath = ((CustomOperatorDescription)description).getResourcePath();
        this.plugin = description.getProvider();
        this.start();
    }

    @Override
    public String getPathForError() {
        return this.resourcePath;
    }

    @Override
    public CustomOperatorTemplate loadTemplate() throws IOException {
        if (this.resourcePath != null) {
            CustomOperatorTemplate customOperatorTemplate;
            block9: {
                InputStream resourceInputStream = ProcessDefinedOperators.getResourceStream(this.resourcePath, this.plugin);
                try {
                    customOperatorTemplate = new CustomOperatorTemplate(resourceInputStream);
                    if (resourceInputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (resourceInputStream != null) {
                            try {
                                resourceInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SAXException e) {
                        throw new IOException("Cannot parse defining xml': " + e, e);
                    }
                }
                resourceInputStream.close();
            }
            return customOperatorTemplate;
        }
        return null;
    }
}

