/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator;

import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.extension.processdefined.ProcessDefinedOperators;
import com.rapidminer.extension.processdefined.operator.AbstractProcessDefinedOperator;
import com.rapidminer.extension.processdefined.operator.CustomOperatorCache;
import com.rapidminer.extension.processdefined.operator.ProcessDefinedOperatorDocBundle;
import com.rapidminer.extension.processdefined.operator.TempCustomOperatorDescription;
import com.rapidminer.extension.processdefined.operator.TempSubProcessDefinedOperator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.repository.BinaryEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.plugin.Plugin;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.SAXException;

public class TempProcessDefinedOperator
extends AbstractProcessDefinedOperator {
    private final BinaryEntry repoEntry;

    public TempProcessDefinedOperator(OperatorDescription description) {
        super(description);
        if (!(description instanceof TempCustomOperatorDescription)) {
            throw new IllegalArgumentException("not custom operator description");
        }
        this.repoEntry = ((TempCustomOperatorDescription)description).getRepoEntry();
        this.start();
    }

    @Override
    public String getPathForError() {
        return this.repoEntry.getName();
    }

    @Override
    public CustomOperatorTemplate loadTemplate() throws IOException {
        if (this.repoEntry != null) {
            CustomOperatorTemplate customOperatorTemplate;
            block10: {
                InputStream resourceInputStream = this.repoEntry.openInputStream();
                try {
                    customOperatorTemplate = new CustomOperatorTemplate(resourceInputStream);
                    if (resourceInputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (resourceInputStream != null) {
                            try {
                                resourceInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SAXException e) {
                        throw new IOException("Cannot parse defining xml': " + e, e);
                    }
                    catch (RepositoryException e) {
                        throw new IOException(e.getMessage());
                    }
                }
                resourceInputStream.close();
            }
            return customOperatorTemplate;
        }
        return null;
    }

    public static void register(BinaryEntry customOpEntry) throws OperatorCreationException, IOException, SAXException, RepositoryException {
        CustomOperatorTemplate template;
        Plugin cusopPlugin = Plugin.getPluginByExtensionId((String)"rmx_process_defined_operators");
        String shortName = customOpEntry.getName();
        String nameWithoutExtension = shortName.replace(".cusop", "");
        String key = ProcessDefinedOperators.toSnakeCase(nameWithoutExtension);
        try (InputStream inputStream = customOpEntry.openInputStream();){
            template = new CustomOperatorTemplate(inputStream);
        }
        ProcessDefinedOperatorDocBundle bundle = new ProcessDefinedOperatorDocBundle(key, template);
        String iconName = template.getIcon() == null ? "painters_palette.png" : template.getIcon();
        String fullyQualifiedGroupKey = "extensions." + cusopPlugin.getName() + ".temporary_operators";
        TempCustomOperatorDescription description = new TempCustomOperatorDescription(fullyQualifiedGroupKey, key, template.getSubprocessInfos().isEmpty() ? TempProcessDefinedOperator.class : TempSubProcessDefinedOperator.class, null, iconName, cusopPlugin, bundle, customOpEntry);
        CustomOperatorCache.TEMPLATE_CACHE.put(description.getKey(), template);
        if (OperatorService.getOperatorKeys().contains(description.getKey())) {
            CustomOperatorCache.PROCESS_CACHE.put(description.getKey(), null);
        }
        OperatorService.unregisterOperator((OperatorDescription)description);
        OperatorService.registerOperator((OperatorDescription)description, null);
    }
}

