/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator;

import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.extension.processdefined.operator.AbstractSubProcessDefinedOperator;
import com.rapidminer.extension.processdefined.operator.TempCustomOperatorDescription;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.repository.BinaryEntry;
import com.rapidminer.repository.RepositoryException;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.SAXException;

public class TempSubProcessDefinedOperator
extends AbstractSubProcessDefinedOperator {
    private final BinaryEntry repoEntry;

    public TempSubProcessDefinedOperator(OperatorDescription description) {
        super(description);
        if (!(description instanceof TempCustomOperatorDescription)) {
            throw new IllegalArgumentException("not custom operator description");
        }
        this.repoEntry = ((TempCustomOperatorDescription)description).getRepoEntry();
        this.start();
    }

    @Override
    public String getPathForError() {
        return this.repoEntry.getName();
    }

    @Override
    public CustomOperatorTemplate loadTemplate() throws IOException {
        if (this.repoEntry != null) {
            CustomOperatorTemplate customOperatorTemplate;
            block10: {
                InputStream resourceInputStream = this.repoEntry.openInputStream();
                try {
                    customOperatorTemplate = new CustomOperatorTemplate(resourceInputStream);
                    if (resourceInputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (resourceInputStream != null) {
                            try {
                                resourceInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SAXException e) {
                        throw new IOException("Cannot parse defining xml': " + e, e);
                    }
                    catch (RepositoryException e) {
                        throw new IOException(e.getMessage());
                    }
                }
                resourceInputStream.close();
            }
            return customOperatorTemplate;
        }
        return null;
    }
}

