/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator;

import com.rapidminer.Process;
import com.rapidminer.extension.datastructure.ioobjects.ProblemContextIOObject;
import com.rapidminer.extension.datastructure.ioobjects.ProblemContextMetaData;
import com.rapidminer.extension.datastructure.operator.data_module.AdjustDataToSchemaOperator;
import com.rapidminer.extension.datastructure.problemcontext.ProblemContext;
import com.rapidminer.extension.processdefined.operator.ProcessDefinedOperator;
import com.rapidminer.extension.processdefined.util.CustomModuleUtils;
import com.rapidminer.gui.tools.ProcessGUITools;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessRootOperator;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserSetupError;
import com.rapidminer.operator.io.RepositorySource;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortOwner;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeLinkButton;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.XMLException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class UseCaseModuleOperator
extends ProcessDefinedOperator {
    private static final String ADJUST_OPERATOR_DEFAULT_NAME = "Adjust Data to Schema";
    private final InputPort contextInputPort = (InputPort)this.getInputPorts().createPort("context");
    private final OutputPort contextOutputPort = (OutputPort)this.getOutputPorts().createPort("context");
    public static final String PARAMETER_BUTTON_UPDATE_PROCESS = "adjust_data_to_schema";
    public static final String I18N_KEY_UPDATE_PROCESS = "modules.update_subprocess";
    private final Map<String, AdjustDataToSchemaOperator> inputPortSchemaMap = new LinkedHashMap<String, AdjustDataToSchemaOperator>();
    private final ResourceAction action = new ResourceAction("modules.update_subprocess", new Object[0]){
        private static final long serialVersionUID = -3805803709908334291L;

        protected void loggedActionPerformed(ActionEvent event) {
            final UseCaseModuleOperator operator = UseCaseModuleOperator.this;
            for (Map.Entry entry : operator.inputPortSchemaMap.entrySet()) {
                try {
                    ((AdjustDataToSchemaOperator)entry.getValue()).updateProcessAction();
                }
                catch (UserSetupError e) {
                    final ProcessSetupError adjustSetupError = e.getSetupError();
                    ProcessSetupError moduleSetupError = new ProcessSetupError(){

                        public String getMessage() {
                            return adjustSetupError.getMessage();
                        }

                        public PortOwner getOwner() {
                            return operator.getPortOwner();
                        }

                        public List<? extends QuickFix> getQuickFixes() {
                            return adjustSetupError.getQuickFixes();
                        }

                        public ProcessSetupError.Severity getSeverity() {
                            return adjustSetupError.getSeverity();
                        }
                    };
                    operator.addError(moduleSetupError);
                    ProcessGUITools.displayProcessSetupError((ProcessSetupError)moduleSetupError);
                }
            }
            UseCaseModuleOperator.this.customOperatorPorts.transformMetaData(operator.getProcess().getRootOperator());
        }
    };

    public UseCaseModuleOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public Process modifyTemplateProcess(Process templateProcess) {
        ProcessRootOperator rootOperator = templateProcess.getRootOperator();
        ExecutionUnit innerProcess = rootOperator.getSubprocess(0);
        OutputPort lastContextPort = (OutputPort)innerProcess.getInnerSources().getPortByIndex(innerProcess.getInnerSources().getNumberOfConnectedPorts());
        InputPort innerContextSink = (InputPort)innerProcess.getInnerSinks().getPortByIndex(innerProcess.getInnerSinks().getNumberOfConnectedPorts());
        for (Map.Entry<String, String> entry : this.getCachedTemplate().getInputPortSchemaMap().entrySet()) {
            try {
                AdjustDataToSchemaOperator adjustOperator = (AdjustDataToSchemaOperator)OperatorService.createOperator(AdjustDataToSchemaOperator.class);
                adjustOperator.rename(adjustOperator.getName() + "_" + entry.getKey());
                adjustOperator.setParameter("update_subprocess_on_run", String.valueOf(true));
                innerProcess.addOperator((Operator)adjustOperator);
                adjustOperator.registerMainMappingParameter((Operator)this, "mapping: " + entry.getKey());
                OutputPort innerSource = (OutputPort)innerProcess.getInnerSources().getPortByName(entry.getKey());
                InputPort targetPort = (InputPort)innerSource.disconnectAndGet(true);
                innerSource.connectTo((InputPort)adjustOperator.getInputPorts().getPortByName("example set"));
                ((OutputPort)adjustOperator.getOutputPorts().getPortByName("example set")).connectTo(targetPort);
                innerSource.unlock();
                String schemaLocation = CustomModuleUtils.makeRelative(entry.getValue());
                RepositorySource retrieveOperator = CustomModuleUtils.createCustomRetrieve(schemaLocation, this.plugin.getName());
                innerProcess.addOperator((Operator)retrieveOperator);
                ((OutputPort)retrieveOperator.getOutputPorts().getPortByName("output")).connectTo((InputPort)adjustOperator.getInputPorts().getPortByName("schema"));
                lastContextPort.connectTo((InputPort)adjustOperator.getInputPorts().getPortByName("context"));
                lastContextPort = (OutputPort)adjustOperator.getOutputPorts().getPortByName("context");
                this.fireUpdate((Operator)adjustOperator);
                this.inputPortSchemaMap.put(entry.getKey(), adjustOperator);
            }
            catch (OperatorCreationException e) {
                if (this.getLogger() == null) continue;
                this.getLogger().info("Exception during inner process update: " + e.getLocalizedMessage());
            }
        }
        lastContextPort.connectTo(innerContextSink);
        return templateProcess;
    }

    @Override
    public Process registerProcessFromCache(Process process) {
        Process clone = (Process)process.clone();
        clone.getContext().setMacros(process.getContext().getMacros());
        for (Map.Entry<String, String> entry : this.getCachedTemplate().getInputPortSchemaMap().entrySet()) {
            Operator operator = clone.getOperator("Adjust Data to Schema_" + entry.getKey());
            if (!(operator instanceof AdjustDataToSchemaOperator)) continue;
            AdjustDataToSchemaOperator adjustOperator = (AdjustDataToSchemaOperator)operator;
            adjustOperator.registerMainMappingParameter((Operator)this, "mapping: " + entry.getKey());
            this.fireUpdate((Operator)adjustOperator);
            this.inputPortSchemaMap.put(entry.getKey(), adjustOperator);
        }
        return clone;
    }

    @Override
    public Process getProcessForOpenInnerProcess() throws XMLException, IOException, UndefinedParameterError {
        Process process = this.getCachedProcess() == null ? this.modifyTemplateProcess(this.getCachedTemplate().getProcess()) : (Process)this.getCachedProcess().clone();
        for (Map.Entry<String, String> entry : this.getCachedTemplate().getInputPortSchemaMap().entrySet()) {
            Operator operator = process.getOperator("Adjust Data to Schema_" + entry.getKey());
            if (!(operator instanceof AdjustDataToSchemaOperator)) continue;
            AdjustDataToSchemaOperator adjustOperator = (AdjustDataToSchemaOperator)operator;
            adjustOperator.setParameter("mapping", this.getParameterAsString("mapping: " + entry.getKey()));
            adjustOperator.registerMainMappingParameter((Operator)adjustOperator, "mapping");
            this.fireUpdate((Operator)adjustOperator);
        }
        return process;
    }

    @Override
    public Process getProcessForMetaData() {
        return this.getCachedProcess();
    }

    @Override
    public Process preprocessAfterLoading(Process process) {
        return process;
    }

    @Override
    public boolean isArrangeProcessLayout() {
        return true;
    }

    @Override
    public int updateOptimalNumberOfPorts(int number, Process innerProcess, boolean isInput) {
        if (innerProcess != null && number > 0) {
            return number - 1;
        }
        return number;
    }

    @Override
    public List<MetaData> modifyInputMetaDataList(List<MetaData> inputMetaData) {
        MetaData contextMetaData = this.contextInputPort.getMetaData();
        if (!(contextMetaData instanceof ProblemContextMetaData)) {
            contextMetaData = new ProblemContextMetaData(new ProblemContext());
        }
        inputMetaData.add(contextMetaData);
        return inputMetaData;
    }

    @Override
    public IOContainer modifyInputDataList(IOContainer input) {
        ProblemContextIOObject contextIOObject = (ProblemContextIOObject)this.contextInputPort.getDataAsOrNull(ProblemContextIOObject.class);
        if (contextIOObject == null) {
            contextIOObject = new ProblemContextIOObject(new ProblemContext());
        }
        input.append((IOObject)contextIOObject);
        return input;
    }

    @Override
    public void handleAdditionalMetaDataOutput(Iterator<MetaData> resultIterator) {
        if (resultIterator.hasNext()) {
            this.contextOutputPort.deliverMD(resultIterator.next());
        }
    }

    @Override
    public void handleAdditionalOutput(Iterator<IOObject> resultIterator) {
        if (resultIterator.hasNext()) {
            IOObject nextResult = resultIterator.next();
            if (nextResult != null) {
                nextResult.setSource(this.getName());
            }
            this.contextOutputPort.deliver(nextResult);
        }
    }

    @Override
    public boolean loadProcessForParameters() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        for (Map.Entry<String, AdjustDataToSchemaOperator> entry : this.inputPortSchemaMap.entrySet()) {
            String portName = entry.getKey();
            AdjustDataToSchemaOperator operator = entry.getValue();
            for (ParameterType type : operator.getParameterTypes()) {
                if (!type.getKey().equals("open_data_assistant") && !type.getKey().equals("mapping")) continue;
                type.setKey(type.getKey() + ": " + portName);
                types.add(type);
            }
        }
        types.add((ParameterType)new ParameterTypeLinkButton(PARAMETER_BUTTON_UPDATE_PROCESS, "Update the subprocess by adding operators according to the context and data schema.", this.action));
        return types;
    }
}

