/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator.access;

import com.rapidminer.extension.processdefined.ExtensionNameProvider;
import com.rapidminer.extension.processdefined.operator.access.RepositoryProcessSuggestionProvider;
import com.rapidminer.extension.processdefined.util.RepositoryUtils;
import com.rapidminer.extension.productivity.operator.meta.ProcessExecutionOperator;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorVersion;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeSuggestion;
import com.rapidminer.parameter.SuggestionProvider;
import com.rapidminer.repository.DataEntry;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import java.util.List;

public class CustomExecuteProcess
extends ProcessExecutionOperator {
    public static final String PARAMETER_NAME = "process_name";
    public static final String PARAMETER_EXTENSION_NAME = "extension_name";
    private static final OperatorVersion COMPATIBILITY_LEVEL = new OperatorVersion(10, 3, 0);

    public CustomExecuteProcess(OperatorDescription description) {
        super(description);
        this.setCompatibilityLevel(COMPATIBILITY_LEVEL);
    }

    public RepositoryLocation getParameterAsRepositoryLocationData(String key, Class<? extends DataEntry> expectedDataType) throws UserError {
        if ("process_location".equals(key) && ProcessEntry.class.equals(expectedDataType)) {
            return this.getRepositoryLocation();
        }
        return super.getParameterAsRepositoryLocationData(key, expectedDataType);
    }

    private RepositoryLocation getRepositoryLocation() throws UserError {
        String extensionName = this.getParameter(PARAMETER_EXTENSION_NAME);
        String location = this.getParameter(PARAMETER_NAME);
        if (extensionName == null || extensionName.isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_EXTENSION_NAME, ""});
        }
        try {
            Repository repository = RepositoryUtils.hiddenRepoForExtension(extensionName);
            ProcessEntry entry = (ProcessEntry)repository.locateData(location, ProcessEntry.class, false);
            if (entry == null) {
                throw new RepositoryException("Entry " + location + " not found");
            }
            return entry.getLocation();
        }
        catch (RepositoryException e) {
            throw new UserError((Operator)this, (Throwable)e, 312, new Object[]{this.getParameterAsString("process_location"), e.getMessage()});
        }
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        int parameterIndex = -1;
        for (int i = 0; i < types.size(); ++i) {
            if (!"process_location".equals(((ParameterType)types.get(i)).getKey())) continue;
            parameterIndex = i;
            break;
        }
        if (parameterIndex >= 0) {
            types.remove(parameterIndex);
        }
        ParameterTypeSuggestion suggestion = new ParameterTypeSuggestion(PARAMETER_EXTENSION_NAME, "The custom extension with the process.", (SuggestionProvider)ExtensionNameProvider.INSTANCE, false);
        suggestion.setExpert(false);
        types.add(0, suggestion);
        ParameterTypeSuggestion type = new ParameterTypeSuggestion(PARAMETER_NAME, "The name of the process to retrieve.", (SuggestionProvider)RepositoryProcessSuggestionProvider.INSTANCE);
        type.setOptional(false);
        type.setExpert(false);
        types.add(1, type);
        return types;
    }

    public OperatorVersion[] getIncompatibleVersionChanges() {
        return EMPTY_OPERATOR_VERSIONS_ARRAY;
    }
}

