/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator.access;

import com.rapidminer.extension.processdefined.ExtensionNameProvider;
import com.rapidminer.extension.processdefined.operator.access.RepositoryFileSuggestionProvider;
import com.rapidminer.extension.processdefined.util.RepositoryUtils;
import com.rapidminer.operator.Annotations;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.BinaryEntryFileObject;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeSuggestion;
import com.rapidminer.parameter.SuggestionProvider;
import com.rapidminer.repository.BinaryEntry;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryLocationBuilder;
import java.util.List;

public class CustomOpen
extends Operator {
    public static final String PARAMETER_NAME = "file_name";
    public static final String PARAMETER_EXTENSION_NAME = "extension_name";
    private final OutputPort fileOutputPort = (OutputPort)this.getOutputPorts().createPort("file");

    public CustomOpen(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule(this.fileOutputPort, FileObject.class){

            public void transformMD() {
                MetaData clone = this.getUnmodifiedMetaData();
                try {
                    clone.setAnnotations(CustomOpen.this.checkMetaDataAndGetAnnotations());
                }
                catch (UserError e) {
                    CustomOpen.this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, CustomOpen.this.getPortOwner(), "passthrough", new Object[]{e.getMessage()}));
                }
                clone.addToHistory(CustomOpen.this.fileOutputPort);
                CustomOpen.this.fileOutputPort.deliverMD(this.modifyMetaData(clone));
            }
        });
    }

    private Annotations checkMetaDataAndGetAnnotations() throws UserError {
        try {
            BinaryEntry repositoryEntry = this.getRepositoryEntry();
            Annotations annotations = new Annotations();
            annotations.setAnnotation("Filename", repositoryEntry.getName());
            return annotations;
        }
        catch (RepositoryException e) {
            throw new UserError((Operator)this, (Throwable)e, 312, new Object[]{this.getParameterAsString(PARAMETER_NAME), e.getMessage()});
        }
    }

    public void doWork() throws OperatorException {
        try {
            BinaryEntry entry = this.getRepositoryEntry();
            RepositoryLocation binLoc = new RepositoryLocationBuilder().withExpectedDataEntryType(BinaryEntry.class).buildFromAbsoluteLocation(entry.getLocation().getAbsoluteLocation());
            BinaryEntryFileObject file = new BinaryEntryFileObject(binLoc);
            file.getAnnotations().setAnnotation("Filename", this.getParameter(PARAMETER_NAME));
            this.fileOutputPort.deliver((IOObject)file);
        }
        catch (RepositoryException e) {
            throw new UserError((Operator)this, (Throwable)e, 312, new Object[]{this.getParameterAsString(PARAMETER_NAME), e.getMessage()});
        }
    }

    private BinaryEntry getRepositoryEntry() throws RepositoryException, UserError {
        String extensionName = this.getParameter(PARAMETER_EXTENSION_NAME);
        String location = this.getParameter(PARAMETER_NAME);
        if (extensionName == null || extensionName.isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_EXTENSION_NAME, ""});
        }
        Repository repository = RepositoryUtils.hiddenRepoForExtension(extensionName);
        BinaryEntry entry = (BinaryEntry)repository.locateData(location, BinaryEntry.class, false);
        if (entry == null) {
            throw new RepositoryException("Entry not found");
        }
        return entry;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSuggestion suggestion = new ParameterTypeSuggestion(PARAMETER_EXTENSION_NAME, "The custom extension to retrieve from.", (SuggestionProvider)ExtensionNameProvider.INSTANCE, false);
        suggestion.setExpert(false);
        types.add(suggestion);
        ParameterTypeSuggestion type = new ParameterTypeSuggestion(PARAMETER_NAME, "The name of the file to retrieve.", (SuggestionProvider)RepositoryFileSuggestionProvider.INSTANCE, false);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

