/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator.access;

import com.rapidminer.extension.processdefined.ExtensionNameProvider;
import com.rapidminer.extension.processdefined.operator.access.RepositoryObjectSuggestionProvider;
import com.rapidminer.extension.processdefined.util.RepositoryUtils;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InvalidRepositoryEntryError;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.UserSetupError;
import com.rapidminer.operator.io.RepositorySource;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeSuggestion;
import com.rapidminer.parameter.SuggestionProvider;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryEntryNotFoundException;
import com.rapidminer.repository.RepositoryEntryWrongTypeException;
import com.rapidminer.repository.RepositoryException;
import java.util.Collections;
import java.util.List;

public class CustomRetrieve
extends RepositorySource {
    public static final String PARAMETER_NAME = "object_name";
    public static final String PARAMETER_EXTENSION_NAME = "extension_name";

    public CustomRetrieve(OperatorDescription description) {
        super(description);
    }

    protected ProgressThread getPrecheckThread() {
        ProgressThread precheckThread = new ProgressThread("RepositorySource.precheck_metadata", false, new Object[]{this.getName()}){

            public void run() {
                String repoLocationParam = null;
                String extensionParam = null;
                boolean wasBrokenBefore = false;
                String unreplacedParameter = null;
                try {
                    repoLocationParam = CustomRetrieve.this.getParameter(CustomRetrieve.PARAMETER_NAME);
                    extensionParam = CustomRetrieve.this.getParameter(CustomRetrieve.PARAMETER_EXTENSION_NAME);
                    unreplacedParameter = CustomRetrieve.this.getParameters().getParameter(CustomRetrieve.PARAMETER_NAME);
                    wasBrokenBefore = CustomRetrieve.this.getCachedMetaData() == null || IOObject.class.equals((Object)CustomRetrieve.this.getCachedMetaData().getObjectClass());
                    this.checkCancelled();
                    IOObjectEntry entry = CustomRetrieve.this.getRepositoryEntry();
                    entry.retrieveMetaData();
                    this.checkCancelled();
                    if (wasBrokenBefore) {
                        CustomRetrieve.this.setParameter(CustomRetrieve.PARAMETER_NAME, unreplacedParameter);
                        CustomRetrieve.this.transformMetaData();
                    }
                }
                catch (RepositoryException e) {
                    this.checkCancelled();
                    if (!wasBrokenBefore && repoLocationParam != null && extensionParam != null) {
                        CustomRetrieve.this.setParameter(CustomRetrieve.PARAMETER_NAME, unreplacedParameter);
                        CustomRetrieve.this.transformMetaData();
                    }
                }
                catch (UserError userError) {
                    // empty catch block
                }
            }
        };
        precheckThread.addDependency(new String[]{"AbstractReader.transform_metadata"});
        precheckThread.setIndeterminate(true);
        return precheckThread;
    }

    protected UserSetupError handleSetupError(RepositoryException e) throws UserError {
        if (e instanceof RepositoryEntryNotFoundException || e instanceof RepositoryEntryWrongTypeException) {
            return new UserSetupError((Operator)this, (ProcessSetupError)new InvalidRepositoryEntryError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), PARAMETER_NAME, Collections.singletonList(new ParameterSettingQuickFix((Operator)this, PARAMETER_NAME)), (String)REPO_ERROR_KEYS.get(((Object)((Object)e)).getClass()), new Object[]{this.getParameter(PARAMETER_NAME), e.getMessage()}));
        }
        return new UserSetupError((Operator)this, (ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), "repository_access_error", new Object[]{this.getParameter(PARAMETER_NAME), e.getMessage()}));
    }

    public IOObject read() throws OperatorException {
        this.setParameter("repository_entry", this.getParameter(PARAMETER_NAME));
        return super.read();
    }

    protected IOObjectEntry getRepositoryEntry() throws RepositoryException, UserError {
        String extensionName = this.getParameter(PARAMETER_EXTENSION_NAME);
        String location = this.getParameter(PARAMETER_NAME);
        if (extensionName == null || extensionName.isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_EXTENSION_NAME, ""});
        }
        Repository repository = RepositoryUtils.hiddenRepoForExtension(extensionName);
        IOObjectEntry ioObjectEntry = (IOObjectEntry)repository.locateData(location, IOObjectEntry.class, true);
        if (ioObjectEntry == null) {
            throw new RepositoryException("Entry not found");
        }
        return ioObjectEntry;
    }

    public List<ParameterType> getParameterTypes() {
        ParameterType type2;
        List types = super.getParameterTypes();
        for (ParameterType type2 : types) {
            if (!"repository_entry".equals(type2.getKey())) continue;
            type2.setHidden(true);
            break;
        }
        ParameterTypeSuggestion suggestion = new ParameterTypeSuggestion(PARAMETER_EXTENSION_NAME, "The custom extension to retrieve from.", (SuggestionProvider)ExtensionNameProvider.INSTANCE, false);
        suggestion.setExpert(false);
        types.add(suggestion);
        type2 = new ParameterTypeSuggestion(PARAMETER_NAME, "The name of the IOObject to retrieve.", (SuggestionProvider)RepositoryObjectSuggestionProvider.INSTANCE, false);
        type2.setExpert(false);
        types.add(type2);
        return types;
    }
}

