/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator.access;

import com.rapidminer.extension.processdefined.util.RepositoryUtils;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.SuggestionProvider;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ProgressListener;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

public interface RepositorySuggestionProvider
extends SuggestionProvider<String> {
    public static final String PARAMETER_EXTENSION_NAME = "extension_name";

    default public List<String> getSuggestions(Operator op, ProgressListener pl) {
        try {
            String extensionName = op.getParameter(PARAMETER_EXTENSION_NAME);
            if (extensionName == null) {
                return new ArrayList<String>();
            }
            return this.getSuggestions(extensionName);
        }
        catch (UndefinedParameterError e) {
            LogService.getRoot().log(Level.INFO, "No suggestions present without extension name selected.");
        }
        catch (UserError | RepositoryException | IOException e) {
            LogService.getRoot().log(Level.INFO, "Failed to fetch suggestions: " + e.getMessage());
        }
        return new ArrayList<String>();
    }

    default public List<String> getSuggestions(String extensionName) throws RepositoryException, UserError, IOException {
        Repository repository = RepositoryUtils.hiddenRepoForExtension(extensionName);
        Path repoFolder = RepositoryUtils.locationToFolderPath(repository.getLocation().getAbsoluteLocation() + "/");
        if (repoFolder == null) {
            throw new RepositoryException("Folder for repository not found.");
        }
        List<Path> processPaths = this.getTypeSpecificContent(repoFolder);
        ArrayList<String> processes = new ArrayList<String>(processPaths.size());
        for (Path processPath : processPaths) {
            String relativePath = repoFolder.relativize(processPath).toString();
            processes.add(this.typeSpecificCleanup(relativePath.replace('\\', '/')));
        }
        return processes;
    }

    default public List<Path> getTypeSpecificContent(Path repoFolder) throws IOException {
        return Collections.emptyList();
    }

    default public String typeSpecificCleanup(String pathName) {
        return pathName;
    }
}

