/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator.parameter;

import com.rapidminer.extension.processdefined.parameter.ParameterTypeFromEnumerationSubset;
import com.rapidminer.extension.processdefined.parameter.ParameterTypeResolverAttributeSubset;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.SingleMacroDefinitionOperator;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ValueString;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.MetaDataChangeListener;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.MetaDataProvider;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttributeSubset;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.ArrayList;
import java.util.List;

public class AttributeSubsetParameterHelper
extends SingleMacroDefinitionOperator {
    public static final String PARAMETER_SEPARATOR_CHARACTER = "separator_character";
    public static final String NEW_SEPARATOR = "\u241e";
    public static final String OLD_SEPARATOR = "|";
    public static final String PARAMETER_USE_FIXED_VALUES = "use_fixed_values";
    public static final String PARAMETERS_VALUES_TO_CHOOSE_FROM = "values_to_choose_from";

    public AttributeSubsetParameterHelper(OperatorDescription description) {
        super(description);
        this.addValue((Value)new ValueString("macro_value", "The value of the macro."){

            public String getStringValue() {
                try {
                    String selectedChar = AttributeSubsetParameterHelper.this.getParameterAsString(AttributeSubsetParameterHelper.PARAMETER_SEPARATOR_CHARACTER);
                    if (!AttributeSubsetParameterHelper.NEW_SEPARATOR.equals(selectedChar)) {
                        String withNewSeparator = AttributeSubsetParameterHelper.this.getParameterAsString("value");
                        return withNewSeparator.replace(AttributeSubsetParameterHelper.NEW_SEPARATOR, selectedChar);
                    }
                    return AttributeSubsetParameterHelper.this.getParameterAsString("value");
                }
                catch (UndefinedParameterError e) {
                    return null;
                }
            }
        });
    }

    public void doWork() throws OperatorException {
        super.doWork();
        String selectedChar = this.getParameterAsString(PARAMETER_SEPARATOR_CHARACTER);
        if (!NEW_SEPARATOR.equals(selectedChar)) {
            String withNewSeparator = this.getParameterAsString("value");
            String desiredValue = withNewSeparator.replace(NEW_SEPARATOR, selectedChar);
            this.getProcess().getMacroHandler().addMacro(this.getParameterAsString("macro"), desiredValue);
        }
    }

    public List<ParameterType> getParameterTypes() {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>();
        types.add((ParameterType)new ParameterTypeString("macro", "The macro name defined by the user.", false, false));
        types.add((ParameterType)new ParameterTypeResolverAttributeSubset("value", "The attribute subset macro value defined by the user.", new MetaDataProvider(){

            public MetaData getMetaData() {
                if (AttributeSubsetParameterHelper.this.getParameterAsBoolean(AttributeSubsetParameterHelper.PARAMETER_USE_FIXED_VALUES)) {
                    String parameterValue;
                    try {
                        parameterValue = AttributeSubsetParameterHelper.this.getParameterAsString(AttributeSubsetParameterHelper.PARAMETERS_VALUES_TO_CHOOSE_FROM);
                    }
                    catch (UndefinedParameterError e) {
                        parameterValue = "";
                    }
                    return ParameterTypeFromEnumerationSubset.enumerationToMetadata(parameterValue);
                }
                return ((InputPort)AttributeSubsetParameterHelper.this.getInputPorts().getPortByIndex(0)).getMetaData();
            }

            public void addMetaDataChangeListener(MetaDataChangeListener metaDataChangeListener) {
            }

            public void removeMetaDataChangeListener(MetaDataChangeListener metaDataChangeListener) {
            }
        }, true));
        types.add((ParameterType)new ParameterTypeStringCategory(PARAMETER_SEPARATOR_CHARACTER, "The character to separate the values", new String[]{NEW_SEPARATOR, OLD_SEPARATOR}, NEW_SEPARATOR, true));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_USE_FIXED_VALUES, "Whether to use fixed values to choose from in the custom operator", false, true));
        ParameterTypeEnumeration parameterType = new ParameterTypeEnumeration(PARAMETERS_VALUES_TO_CHOOSE_FROM, "The values to display on the left side of the Select Attributes dialog", (ParameterType)new ParameterTypeString("value", "one possible value"));
        parameterType.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_USE_FIXED_VALUES, true, true));
        types.add((ParameterType)parameterType);
        return types;
    }

    public ParameterType createCustomParameter(ParameterType originalType, ParameterTypeAttributeSubset defaultParameter) {
        if (this.getParameterAsBoolean(PARAMETER_USE_FIXED_VALUES)) {
            String enumValue;
            try {
                enumValue = this.getParameterAsString(PARAMETERS_VALUES_TO_CHOOSE_FROM);
            }
            catch (UndefinedParameterError e) {
                enumValue = "";
            }
            return new ParameterTypeFromEnumerationSubset(originalType.getKey(), originalType.getDescription(), enumValue);
        }
        return defaultParameter;
    }
}

