/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator.parameter;

import com.rapidminer.extension.processdefined.parameter.ParameterTypeEnumerationAndRefresh;
import com.rapidminer.extension.processdefined.parameter.ParameterTypeHelperStringCategory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.SingleMacroDefinitionOperator;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ValueString;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.ArrayList;
import java.util.List;

public class CategoriesParameterHelper
extends SingleMacroDefinitionOperator {
    private static final String PARAMETER_POSSIBLE_CATEGORIES = "possible_values";
    private static final String PARAMETER_INTEGER_MACRO = "set_as_integer_macro";
    private static final String PARAMETER_EDITABLE = "editable";

    public CategoriesParameterHelper(OperatorDescription description) {
        super(description);
        this.addValue((Value)new ValueString("macro_value", "The value of the macro."){

            public String getStringValue() {
                try {
                    if (CategoriesParameterHelper.this.getParameterAsBoolean(CategoriesParameterHelper.PARAMETER_INTEGER_MACRO)) {
                        return CategoriesParameterHelper.this.getMacroValueAsInt();
                    }
                    return CategoriesParameterHelper.this.getParameterAsString("value");
                }
                catch (UndefinedParameterError e) {
                    return null;
                }
            }
        });
    }

    public List<ParameterType> getParameterTypes() {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>();
        types.add((ParameterType)new ParameterTypeEnumerationAndRefresh(PARAMETER_POSSIBLE_CATEGORIES, "The possible values allowed for the macro", (ParameterType)new ParameterTypeString("value", "one possible value")));
        types.add((ParameterType)new ParameterTypeString("macro", "The macro name defined by the user.", false, false));
        ParameterTypeHelperStringCategory type = new ParameterTypeHelperStringCategory("value", "The category macro value defined by the user.", this::getDropdownValues);
        type.setOptional(true);
        type.setExpert(false);
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_INTEGER_MACRO, "Sets the macro value as integer.", false, false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_EDITABLE, "Whether the dropdown in the custom operator should be editable.", true, true));
        return types;
    }

    public void doWork() throws OperatorException {
        super.doWork();
        if (this.getParameterAsBoolean(PARAMETER_INTEGER_MACRO)) {
            String macro = this.getParameterAsString("macro");
            String intValue = this.getMacroValueAsInt();
            this.getProcess().getMacroHandler().addMacro(macro, intValue);
        }
    }

    private String getMacroValueAsInt() throws UndefinedParameterError {
        String value = this.getParameterAsString("value");
        List categories = ParameterTypeEnumeration.transformString2List((String)this.getParameterAsString(PARAMETER_POSSIBLE_CATEGORIES));
        int index = 0;
        for (int i = 0; i < categories.size(); ++i) {
            if (!((String)categories.get(i)).equals(value)) continue;
            index = i + 1;
            break;
        }
        return String.valueOf(index);
    }

    private String[] getDropdownValues() {
        try {
            return ParameterTypeEnumeration.transformString2Enumeration((String)this.getParameter(PARAMETER_POSSIBLE_CATEGORIES));
        }
        catch (UndefinedParameterError e) {
            return new String[0];
        }
    }

    public ParameterType createCustomParameter(ParameterType parameterType) {
        boolean editable = this.getParameterAsBoolean(PARAMETER_EDITABLE);
        return new ParameterTypeStringCategory(parameterType.getKey(), parameterType.getDescription(), this.getDropdownValues(), null, editable);
    }
}

