/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator.parameter;

import com.rapidminer.extension.processdefined.operator.OpenableCustomOperator;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.SingleMacroDefinitionOperator;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.filter.AbstractDateDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDateFormat;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class DateTimeParameterHelper
extends SingleMacroDefinitionOperator {
    private static final String PARAMETER_DATE_FORMAT = "date_format";
    private static final String PARAMETER_LOCALE = "locale";

    public DateTimeParameterHelper(OperatorDescription description) {
        super(description);
    }

    public List<ParameterType> getParameterTypes() {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>();
        ParameterTypeDateFormat dateFormat = new ParameterTypeDateFormat(PARAMETER_DATE_FORMAT, "The date format for the macro", "yyyy-MM-dd HH:mm:ss", false);
        dateFormat.setOptional(true);
        dateFormat.setExpert(true);
        types.add((ParameterType)dateFormat);
        types.add((ParameterType)new ParameterTypeStringCategory(PARAMETER_LOCALE, "The locale to use for the date format", (String[])AbstractDateDataProcessing.availableLocales.stream().map(l -> l.getDisplayName(Locale.ENGLISH)).sorted().toArray(String[]::new), Locale.US.getDisplayName(Locale.ENGLISH), false));
        types.add((ParameterType)new ParameterTypeString("macro", "The macro name defined by the user.", false, false));
        ParameterTypeString type = new ParameterTypeString("value", "The macro value defined by the user.", true, false);
        type.setOptional(true);
        type.setExpert(false);
        types.add((ParameterType)type);
        return types;
    }

    public void doWork() throws OperatorException {
        this.checkMacroValue();
        super.doWork();
    }

    private void checkMacroValue() throws UserError {
        DateTimeFormatter dateTimeFormatter;
        String value = this.getParameter("value");
        if (value == null) {
            value = "";
        }
        String localeString = this.getParameter(PARAMETER_LOCALE);
        Locale locale = AbstractDateDataProcessing.availableLocales.stream().filter(l -> l.getDisplayName(Locale.ENGLISH).equals(localeString)).findAny().orElse(Locale.US);
        String formatString = this.getParameter(PARAMETER_DATE_FORMAT);
        try {
            dateTimeFormatter = DateTimeFormatter.ofPattern(formatString, locale);
        }
        catch (IllegalArgumentException e) {
            throw new UserError((Operator)this, "process_defined_operators.datetime_parameter_helper.invalid_pattern", new Object[]{formatString, e.getMessage()});
        }
        if (!this.isValid(value, dateTimeFormatter)) {
            throw new OpenableCustomOperator.VisibleUserError((Operator)this, "process_defined_operators.datetime_parameter_helper.invalid_format", value, formatString, localeString);
        }
    }

    private boolean isValid(String value, DateTimeFormatter dateTimeFormatter) {
        try {
            TemporalAccessor parsed = dateTimeFormatter.parse(value);
            String back = dateTimeFormatter.format(parsed);
            if (value.equals(back)) {
                return true;
            }
        }
        catch (DateTimeParseException e) {
            return false;
        }
        return false;
    }
}

