/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator.parameter;

import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.SingleMacroDefinitionOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.ArrayList;
import java.util.List;

public class DoubleParameterHelper
extends SingleMacroDefinitionOperator {
    public static final String PARAMETER_MIN = "min";
    public static final String PARAMETER_MAX = "max";

    public DoubleParameterHelper(OperatorDescription description) {
        super(description);
    }

    public List<ParameterType> getParameterTypes() {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>();
        types.add((ParameterType)new ParameterTypeString("macro", "The macro name defined by the user.", false, false));
        types.add((ParameterType)new ParameterTypeDouble("value", "The double macro value defined by the user.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true));
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_MIN, "The minimal value for the custom parameter.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true));
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_MAX, "The maximal value for the custom parameter.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true));
        return types;
    }

    public ParameterType createCustomParameter(ParameterType parameterType) {
        double max;
        double min;
        try {
            min = this.getParameterAsDouble(PARAMETER_MIN);
        }
        catch (UndefinedParameterError e) {
            min = Double.NEGATIVE_INFINITY;
        }
        try {
            max = this.getParameterAsDouble(PARAMETER_MAX);
        }
        catch (UndefinedParameterError e) {
            max = Double.POSITIVE_INFINITY;
        }
        return new ParameterTypeDouble(parameterType.getKey(), parameterType.getDescription(), min, max);
    }
}

