/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator.parameter;

import com.rapidminer.extension.processdefined.parameter.ParameterTypeEnumerationAndRefresh;
import com.rapidminer.extension.processdefined.parameter.ParameterTypeHelperFileEnding;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.SingleMacroDefinitionOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.ArrayList;
import java.util.List;

public class FileParameterHelper
extends SingleMacroDefinitionOperator {
    private static final String PARAMETER_FILE_ENDINGS = "file_endings";

    public FileParameterHelper(OperatorDescription description) {
        super(description);
    }

    public List<ParameterType> getParameterTypes() {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>();
        types.add((ParameterType)new ParameterTypeEnumerationAndRefresh(PARAMETER_FILE_ENDINGS, "The allowed file endings (without leading dot)", (ParameterType)new ParameterTypeString("ending", "one allowed file ending (without leading dot)")));
        types.add((ParameterType)new ParameterTypeString("macro", "The macro name defined by the user.", false, false));
        ParameterTypeHelperFileEnding fileParameter = new ParameterTypeHelperFileEnding("value", "The file macro value defined by the user.", this::getEndings);
        fileParameter.setAddAllFileExtensionsFilter(true);
        fileParameter.setOptional(true);
        fileParameter.setExpert(false);
        types.add((ParameterType)fileParameter);
        return types;
    }

    private String[] getEndings() {
        try {
            return ParameterTypeEnumeration.transformString2Enumeration((String)this.getParameter(PARAMETER_FILE_ENDINGS));
        }
        catch (UndefinedParameterError e) {
            return new String[0];
        }
    }
}

