/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator.parameter;

import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.SingleMacroDefinitionOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.ArrayList;
import java.util.List;

public class IntegerParameterHelper
extends SingleMacroDefinitionOperator {
    public static final String PARAMETER_MIN = "min";
    public static final String PARAMETER_MAX = "max";

    public IntegerParameterHelper(OperatorDescription description) {
        super(description);
    }

    public List<ParameterType> getParameterTypes() {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>();
        types.add((ParameterType)new ParameterTypeString("macro", "The macro name defined by the user.", false, false));
        ParameterTypeInt parameterTypeInt = new ParameterTypeInt("value", "The integer macro value defined by the user.", Integer.MIN_VALUE, Integer.MAX_VALUE, true);
        parameterTypeInt.setExpert(false);
        types.add((ParameterType)parameterTypeInt);
        parameterTypeInt = new ParameterTypeInt(PARAMETER_MIN, "The minimal value for the custom parameter.", Integer.MIN_VALUE, Integer.MAX_VALUE, true);
        parameterTypeInt.setExpert(false);
        types.add((ParameterType)parameterTypeInt);
        parameterTypeInt = new ParameterTypeInt(PARAMETER_MAX, "The maximal value for the custom parameter.", Integer.MIN_VALUE, Integer.MAX_VALUE, true);
        parameterTypeInt.setExpert(false);
        types.add((ParameterType)parameterTypeInt);
        return types;
    }

    public ParameterType createCustomParameter(ParameterType parameterType) {
        int max;
        int min;
        try {
            min = this.getParameterAsInt(PARAMETER_MIN);
        }
        catch (UndefinedParameterError e) {
            min = Integer.MIN_VALUE;
        }
        try {
            max = this.getParameterAsInt(PARAMETER_MAX);
        }
        catch (UndefinedParameterError e) {
            max = Integer.MAX_VALUE;
        }
        return new ParameterTypeInt(parameterType.getKey(), parameterType.getDescription(), min, max);
    }
}

