/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator.parameter;

import com.rapidminer.Process;
import com.rapidminer.ProcessListener;
import com.rapidminer.RepositoryProcessLocation;
import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.reader.ObjectReader;
import com.rapidminer.belt.reader.Readers;
import com.rapidminer.connection.ConnectionInformationContainerIOObject;
import com.rapidminer.core.concurrency.ConcurrencyContext;
import com.rapidminer.extension.processdefined.util.MacroUtils;
import com.rapidminer.extension.processdefined.util.RepositoryUtils;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.Annotations;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserData;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.ConnectionInformationMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.SuggestionProvider;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.repository.ConnectionEntry;
import com.rapidminer.repository.DataEntry;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryLocationBuilder;
import com.rapidminer.studio.concurrency.internal.SequentialConcurrencyContext;
import com.rapidminer.studio.internal.Resources;
import com.rapidminer.tools.FunctionWithThrowable;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.ValidationUtilV2;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.belt.BeltConversionTools;
import com.rapidminer.tools.container.Pair;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class ProcessResultSuggestionProvider
implements SuggestionProvider<String> {
    private static final Resources.OverridingContextUserData SEQUENTIAL_CONTEXT = new Resources.OverridingContextUserData((ConcurrencyContext)new SequentialConcurrencyContext());
    private final String extensionName;
    private final String processLocation;
    private final Operator operator;
    private final boolean useAvailableInput;
    private final AtomicReference<List<String>> results = new AtomicReference(Collections.emptyList());

    ProcessResultSuggestionProvider(String extensionName, String processLocation, Operator operator, boolean useAvailableInput) {
        this.extensionName = extensionName;
        this.processLocation = processLocation;
        this.operator = (Operator)ValidationUtilV2.requireNonNull((Object)operator, (String)"operator");
        this.useAvailableInput = useAvailableInput;
    }

    public boolean isUseAvailableInput() {
        return this.useAvailableInput;
    }

    public List<String> getSuggestions(Operator op, ProgressListener pl) {
        return new ArrayList<String>((Collection)this.results.get());
    }

    public ResourceAction getAction() {
        return new ResourceAction("custom_operator.refresh_suggestions", new Object[0]){

            protected void loggedActionPerformed(ActionEvent e) {
                ProgressThread t = new ProgressThread("custom_operator.refresh_suggestions"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        Process process;
                        ProcessListener listener;
                        block13: {
                            block12: {
                                listener = null;
                                process = null;
                                try {
                                    this.getProgressListener().setTotal(120);
                                    process = ProcessResultSuggestionProvider.this.loadProcess();
                                    this.getProgressListener().setCompleted(5);
                                    ProcessResultSuggestionProvider.this.preprocessProcess(process);
                                    process.setProcessLocation(ProcessResultSuggestionProvider.this.operator.getProcess().getProcessLocation());
                                    listener = ProcessResultSuggestionProvider.this.createListener(process, this.getProgressListener());
                                    process.getRootOperator().addProcessListener(listener);
                                    this.getProgressListener().setCompleted(10);
                                    IOContainer run = process.run(ProcessResultSuggestionProvider.this.getInput(), -1, MacroUtils.getOtherMacros(ProcessResultSuggestionProvider.this.operator.getProcess(), process));
                                    this.getProgressListener().setCompleted(110);
                                    IOTable ioTable = BeltConversionTools.asIOTableOrNull((IOObject)run.get(IOObject.class, 0), null);
                                    if (ioTable == null) {
                                        throw new OperatorException("Result is not a data table");
                                    }
                                    if (ioTable.getTable().width() < 1) {
                                        LogService.getRoot().log(Level.WARNING, "Suggestion process result contains no column.");
                                        ProcessResultSuggestionProvider.this.results.set(new ArrayList());
                                        this.getProgressListener().complete();
                                        if (process == null) return;
                                        break block12;
                                    }
                                    Column firstColumn = ioTable.getTable().column(0);
                                    if (!firstColumn.type().elementType().equals(String.class)) {
                                        throw new OperatorException("First column does not contain strings");
                                    }
                                    ObjectReader reader = Readers.objectReader((Column)firstColumn, String.class);
                                    ArrayList<String> result = new ArrayList<String>(ioTable.getTable().height());
                                    while (reader.hasRemaining()) {
                                        result.add((String)reader.read());
                                    }
                                    ProcessResultSuggestionProvider.this.results.set(result);
                                    this.getProgressListener().complete();
                                    break block13;
                                }
                                catch (OperatorException | RepositoryException | XMLException | IOException ex) {
                                    LogService.getRoot().log(Level.WARNING, "Failed to run suggestion process: " + ex.getMessage(), ex);
                                    return;
                                }
                            }
                            process.setProcessLocation(null);
                            if (listener == null) return;
                            process.getRootOperator().removeProcessListener(listener);
                            return;
                        }
                        if (process == null) return;
                        process.setProcessLocation(null);
                        if (listener == null) return;
                        process.getRootOperator().removeProcessListener(listener);
                        return;
                        finally {
                            this.getProgressListener().complete();
                            if (process != null) {
                                process.setProcessLocation(null);
                                if (listener != null) {
                                    process.getRootOperator().removeProcessListener(listener);
                                }
                            }
                        }
                    }
                };
                t.start();
            }
        };
    }

    private void preprocessProcess(Process process) {
        ProcessResultSuggestionProvider.cleanProcess(process);
        this.operator.getParameters().getParameterTypes().forEach(p -> {
            try {
                String value = this.operator.getParameter(p.getKey());
                if (value != null) {
                    process.getContext().addMacro(new Pair((Object)("parameter_" + p.getKey()), (Object)value));
                }
            }
            catch (UndefinedParameterError undefinedParameterError) {
                // empty catch block
            }
        });
    }

    public static void cleanProcess(Process process) {
        process.getAllOperators().stream().filter(Operator::hasBreakpoint).forEach(op -> {
            op.setBreakpoint(0, false);
            op.setBreakpoint(1, false);
        });
        try {
            AccessController.doPrivileged(() -> {
                process.getRootOperator().setUserData("com.rapidminer.core.concurrency.OverridingConcurrencyContext", (UserData)SEQUENTIAL_CONTEXT);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            LogService.getRoot().log(Level.WARNING, "Not allowed to set context for suggestion process", e);
        }
    }

    private IOContainer getInput() {
        IOContainer input = new IOContainer();
        boolean useInput = this.useAvailableInput;
        if (!this.useAvailableInput && this.extensionName == null) {
            useInput = this.operator.getParameterAsBoolean("use_available_input");
        }
        if (useInput) {
            input = ProcessResultSuggestionProvider.fillIOContainer(input, this.operator);
        }
        return input;
    }

    public static IOContainer fillIOContainer(IOContainer input, Operator operator) {
        ListIterator inputs = operator.getInputPorts().getAllPorts().listIterator(operator.getInputPorts().getNumberOfPorts());
        while (inputs.hasPrevious()) {
            MetaData rawMetaData;
            InputPort previous = (InputPort)inputs.previous();
            IOObject append = null;
            try {
                append = previous.getDataOrNull(IOObject.class);
            }
            catch (UserError userError) {
                // empty catch block
            }
            if (append == null && (rawMetaData = previous.getRawMetaData()) instanceof ConnectionInformationMetaData) {
                append = ProcessResultSuggestionProvider.extractFromConnectionMD(previous, append);
            }
            input = input.append(append);
        }
        return input;
    }

    private static IOObject extractFromConnectionMD(InputPort previous, IOObject append) {
        RepositoryLocation location = ProcessResultSuggestionProvider.getRepoLocationFromInputMD(previous);
        if (location != null) {
            try {
                append = ProcessResultSuggestionProvider.extractConnectionFromLocation(location);
            }
            catch (UserError e) {
                LogService.getRoot().log(Level.WARNING, "Cannot pass connection information to suggestion process", e);
            }
        }
        if (append == null) {
            LogService.getRoot().log(Level.WARNING, "Could not extract connection information from metadata. Please set a \"Breakpoint Before\" for this operator, run and try again.");
        }
        return append;
    }

    public Process loadProcess() throws RepositoryException, UserError, IOException, XMLException {
        String extension;
        String location = this.processLocation;
        if (location == null) {
            location = this.operator.getParameter("suggestion_process");
        }
        if ((extension = this.extensionName) == null) {
            extension = this.operator.getParameter("extension_name");
        }
        return ProcessResultSuggestionProvider.getProcess(extension, location);
    }

    public static Process getProcess(String extension, String location) throws RepositoryException, UserError, IOException, XMLException {
        if (extension == null || location == null) {
            throw new RepositoryException("extension name and suggestion process must be defined");
        }
        Repository repository = RepositoryUtils.hiddenRepoForExtension(extension);
        ProcessEntry entry = (ProcessEntry)repository.locateData(location, ProcessEntry.class, false);
        if (entry == null) {
            throw new RepositoryException("Entry " + location + " not found");
        }
        return new RepositoryProcessLocation(entry.getLocation()).load(null);
    }

    private ProcessListener createListener(Process process, final ProgressListener progressListener) {
        int numberOfOperators = process.getAllOperators().size();
        final int advance = 100 / numberOfOperators;
        return new ProcessListener(){
            int completed = 10;

            public void processStarts(Process process) {
            }

            public void processStartedOperator(Process process, Operator op) {
            }

            public void processFinishedOperator(Process process, Operator op) {
                this.completed += advance;
                progressListener.setCompleted(this.completed);
            }

            public void processEnded(Process process) {
            }
        };
    }

    private static RepositoryLocation getRepoLocationFromInputMD(InputPort input) {
        return ProcessResultSuggestionProvider.getRepositoryLocationFromAnnotation(Optional.of(input).map(FunctionWithThrowable.suppress(p -> (ConnectionInformationMetaData)p.getMetaData(ConnectionInformationMetaData.class))).map(MetaData::getAnnotations));
    }

    private static RepositoryLocation getRepositoryLocationFromAnnotation(Optional<Annotations> annotations) {
        return annotations.map(anno -> anno.getAnnotation("Source")).map(FunctionWithThrowable.suppress(source -> new RepositoryLocationBuilder().withExpectedDataEntryType(ConnectionEntry.class).buildFromAbsoluteLocation(source))).orElse(null);
    }

    private static ConnectionInformationContainerIOObject extractConnectionFromLocation(RepositoryLocation location) throws UserError {
        try {
            DataEntry entry = location.locateData();
            if (!(entry instanceof ConnectionEntry)) {
                throw new UserError(null, "connection.wrong_entry_type");
            }
            IOObject data = ((ConnectionEntry)entry).retrieveData(null);
            if (!(data instanceof ConnectionInformationContainerIOObject)) {
                throw new UserError(null, "connection.wrong_entry_data");
            }
            data.getAnnotations().setAnnotation("Source", entry.getLocation().toString());
            return (ConnectionInformationContainerIOObject)data;
        }
        catch (RepositoryException e) {
            throw new UserError(null, (Throwable)e, "connection.repository_error", new Object[]{location.getName()});
        }
    }
}

