/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator.parameter;

import com.rapidminer.extension.processdefined.ExtensionNameProvider;
import com.rapidminer.extension.processdefined.operator.access.RepositoryProcessSuggestionProvider;
import com.rapidminer.extension.processdefined.operator.parameter.ProcessResultSuggestionProvider;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.SingleMacroDefinitionOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeSuggestion;
import com.rapidminer.parameter.SuggestionProvider;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.ArrayList;
import java.util.List;

public class ProcessSuggestionParameterHelper
extends SingleMacroDefinitionOperator {
    public static final String PARAMETER_EXTENSION_NAME = "extension_name";
    public static final String PARAMETER_SUGGESTION_PROCESS_PATH = "suggestion_process";
    public static final String PARAMETER_USE_INPUT = "use_available_input";

    public ProcessSuggestionParameterHelper(OperatorDescription description) {
        super(description);
    }

    public List<ParameterType> getParameterTypes() {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>();
        ParameterTypeSuggestion extensionSuggestion = new ParameterTypeSuggestion(PARAMETER_EXTENSION_NAME, "The custom extension with the process.", (SuggestionProvider)ExtensionNameProvider.INSTANCE, false);
        extensionSuggestion.setExpert(true);
        extensionSuggestion.setOptional(true);
        types.add((ParameterType)extensionSuggestion);
        ParameterTypeSuggestion processSuggestion = new ParameterTypeSuggestion(PARAMETER_SUGGESTION_PROCESS_PATH, "The path for the process providing the suggestions", (SuggestionProvider)RepositoryProcessSuggestionProvider.INSTANCE);
        processSuggestion.setExpert(true);
        processSuggestion.setOptional(true);
        types.add((ParameterType)processSuggestion);
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_USE_INPUT, "Whether to use the available input of the (custom) operator as input of the suggestion process", false));
        types.add((ParameterType)new ParameterTypeString("macro", "The macro name defined by the user.", false, false));
        ParameterTypeSuggestion type = new ParameterTypeSuggestion("value", "The macro value defined by the user.", (SuggestionProvider)new ProcessResultSuggestionProvider(null, null, (Operator)this, false));
        type.setOptional(true);
        type.setExpert(false);
        types.add((ParameterType)type);
        return types;
    }

    public ParameterType createCustomParameter(ParameterType parameterType, Operator customOperator) {
        String extensionName = null;
        try {
            extensionName = this.getParameter(PARAMETER_EXTENSION_NAME);
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        String processLocation = null;
        try {
            processLocation = this.getParameter(PARAMETER_SUGGESTION_PROCESS_PATH);
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        boolean useInput = this.getParameterAsBoolean(PARAMETER_USE_INPUT);
        return new ParameterTypeSuggestion(parameterType.getKey(), parameterType.getDescription(), (SuggestionProvider)new ProcessResultSuggestionProvider(extensionName, processLocation, customOperator, useInput));
    }
}

