/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator.parameter;

import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.SingleMacroDefinitionOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeRepositoryLocation;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.ArrayList;
import java.util.List;

public class RepositoryLocationParameterHelper
extends SingleMacroDefinitionOperator {
    public static final String PARAMETER_ALLOW_ENTRIES = "allow_entries";
    public static final String PARAMETER_ALLOW_DIRECTORIES = "allow_directories";
    public static final String PARAMETER_ONLY_WRITABLE = "only_writable";
    public static final String PARAMETER_ENFORCE_VALID_NAME = "enforce_valid_name";
    public static final String PARAMETER_WARN_ABSOLUTE = "warn_if_absolute";

    public RepositoryLocationParameterHelper(OperatorDescription description) {
        super(description);
    }

    public List<ParameterType> getParameterTypes() {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>();
        types.add((ParameterType)new ParameterTypeString("macro", "The macro name defined by the user.", false, false));
        ParameterTypeRepositoryLocation locationType = new ParameterTypeRepositoryLocation("value", "The location macro value defined by the user.", true, true, true);
        locationType.setExpert(false);
        locationType.setAllowAbsoluteEntries(true);
        types.add((ParameterType)locationType);
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_ALLOW_ENTRIES, "Whether the custom parameter should allow entries", true, false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_ALLOW_DIRECTORIES, "Whether the custom parameter should allow dictionaries", true, false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_ONLY_WRITABLE, "Whether the custom parameter should only allow writable locations", false, false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_ENFORCE_VALID_NAME, "Whether to custom parameter should enforce valid repository entry names", false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_WARN_ABSOLUTE, "Whether to warn about absolute locations", false));
        return types;
    }

    public ParameterType createCustomParameter(ParameterType parameterType) {
        boolean allowEntries = this.getParameterAsBoolean(PARAMETER_ALLOW_ENTRIES);
        boolean allowDirectories = this.getParameterAsBoolean(PARAMETER_ALLOW_DIRECTORIES);
        boolean onlyWritable = this.getParameterAsBoolean(PARAMETER_ONLY_WRITABLE);
        boolean warnAbsolute = this.getParameterAsBoolean(PARAMETER_WARN_ABSOLUTE);
        boolean enforceValidName = this.getParameterAsBoolean(PARAMETER_ENFORCE_VALID_NAME);
        ParameterTypeRepositoryLocation locationType = new ParameterTypeRepositoryLocation(parameterType.getKey(), parameterType.getDescription(), allowEntries, allowDirectories, true);
        locationType.setAllowAbsoluteEntries(!warnAbsolute);
        locationType.setOnlyWriteableLocations(onlyWritable);
        locationType.setEnforceValidRepositoryEntryName(enforceValidName);
        return locationType;
    }
}

