/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator.parameter;

import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.SingleMacroDefinitionOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TextParameterHelper
extends SingleMacroDefinitionOperator {
    public static final String PARAMETER_TEMPLATE_TEXT = "template_text";
    public static final String PARAMETER_TEXT_TYPE = "text_type";

    public TextParameterHelper(OperatorDescription description) {
        super(description);
    }

    public List<ParameterType> getParameterTypes() {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>();
        types.add((ParameterType)new ParameterTypeString("macro", "The macro name defined by the user.", false, false));
        ParameterTypeText parameterTypeText = new ParameterTypeText("value", "The text macro value defined by the user.", TextType.PLAIN, true);
        parameterTypeText.setExpert(false);
        types.add((ParameterType)parameterTypeText);
        String[] typeValues = (String[])Arrays.stream(TextType.values()).map(Enum::name).toArray(String[]::new);
        ParameterTypeStringCategory textTypeType = new ParameterTypeStringCategory(PARAMETER_TEXT_TYPE, "The text type for the value text parameter in the custom operator", typeValues, TextType.PLAIN.toString(), false);
        textTypeType.setExpert(false);
        types.add((ParameterType)textTypeType);
        parameterTypeText = new ParameterTypeText(PARAMETER_TEMPLATE_TEXT, "The template text for the value text parameter in the custom operator.", TextType.PLAIN, true);
        parameterTypeText.setExpert(false);
        types.add((ParameterType)parameterTypeText);
        return types;
    }

    public ParameterType createCustomParameter(ParameterType parameterType) {
        TextType type = TextType.PLAIN;
        try {
            String textType = this.getParameterAsString(PARAMETER_TEXT_TYPE);
            try {
                type = TextType.valueOf((String)textType);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("text type " + textType + " not availabe for text parameter.");
            }
        }
        catch (UndefinedParameterError textType) {
            // empty catch block
        }
        ParameterTypeText parameterTypeText = new ParameterTypeText(parameterType.getKey(), parameterType.getDescription(), type);
        try {
            String template = this.getParameterAsString(PARAMETER_TEMPLATE_TEXT);
            if (template != null && !template.isEmpty()) {
                parameterTypeText.setTemplateText(template);
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        return parameterTypeText;
    }
}

