/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.operator.utility;

import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.List;

public class MetadataHelper
extends OperatorChain {
    public static final String PARAMETER_ONLY_IF_MISSING = "only_if_metadata_missing";
    private final InputPort inputPort = (InputPort)this.getInputPorts().createPort("input");
    private final OutputPort outputPort = (OutputPort)this.getOutputPorts().createPort("output");
    private final PortPairExtender inputExtender = new PortPairExtender("md", this.getInputPorts(), this.getSubprocess(0).getInnerSources());
    private final InputPort innerResultPort = (InputPort)this.getSubprocess(0).getInnerSinks().createPort("output");

    public MetadataHelper(OperatorDescription description) {
        super(description, new String[]{"Nested Process"});
        this.inputExtender.start();
        this.getTransformer().addRule(this.inputExtender.makePassThroughRule());
        this.getTransformer().addRule((MDTransformationRule)new SubprocessTransformRule(this.getSubprocess(0)){

            public void transformMD() {
                if (!MetadataHelper.this.getParameterAsBoolean(MetadataHelper.PARAMETER_ONLY_IF_MISSING) || MetadataHelper.this.inputPort.getRawMetaData() == null) {
                    super.transformMD();
                }
            }
        });
        this.getTransformer().addRule(() -> {
            if (!this.getParameterAsBoolean(PARAMETER_ONLY_IF_MISSING) || this.inputPort.getRawMetaData() == null) {
                this.outputPort.deliverMD(this.innerResultPort.getRawMetaData());
            } else {
                this.outputPort.deliverMD(this.inputPort.getRawMetaData());
            }
        });
    }

    public void doWork() {
        this.outputPort.deliver(this.inputPort.getRawData());
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeBoolean param = new ParameterTypeBoolean(PARAMETER_ONLY_IF_MISSING, "Only use metadata from subprocess if the metadata of the input port is missing", false);
        types.add(param);
        return types;
    }
}

