/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.util;

import com.rapidminer.extension.processdefined.operator.access.CustomRetrieve;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.flow.ProcessPanel;
import com.rapidminer.gui.flow.processrendering.view.ProcessRendererController;
import com.rapidminer.gui.flow.processrendering.view.ProcessRendererView;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.io.RepositorySource;
import com.rapidminer.tools.OperatorService;
import java.util.ArrayList;
import java.util.List;

public class CustomModuleUtils {
    public static String makeRelative(String repositoryLocation) {
        while (repositoryLocation.startsWith("/")) {
            repositoryLocation = repositoryLocation.substring(1);
        }
        repositoryLocation = repositoryLocation.replaceAll("/", "_");
        repositoryLocation = repositoryLocation.replaceAll(" ", "_");
        return repositoryLocation;
    }

    public static RepositorySource createCustomRetrieve(String dataSetLocation, String extensionName) throws OperatorCreationException {
        CustomRetrieve operator = (CustomRetrieve)OperatorService.createOperator(CustomRetrieve.class);
        operator.setParameter("object_name", CustomModuleUtils.makeRelative(dataSetLocation));
        operator.setParameter("extension_name", extensionName);
        return operator;
    }

    public static void arrangeProcessLayout(Operator operator) {
        if (RapidMinerGUI.getMainFrame() == null) {
            return;
        }
        ProcessPanel processPanel = RapidMinerGUI.getMainFrame().getProcessPanel();
        ProcessRendererView view = processPanel.getProcessRenderer();
        ProcessRendererController controller = new ProcessRendererController(view, view.getModel());
        controller.autoFit();
        ArrayList<ExecutionUnit> allSubprocesses = new ArrayList<ExecutionUnit>();
        CustomModuleUtils.addSubprocesses(allSubprocesses, operator);
        controller.autoArrange(allSubprocesses);
    }

    public static void addSubprocesses(List<ExecutionUnit> allSubprocesses, Operator operator) {
        if (operator instanceof OperatorChain) {
            OperatorChain operatorChain = (OperatorChain)operator;
            for (int i = 0; i < operatorChain.getNumberOfSubprocesses(); ++i) {
                allSubprocesses.add(operatorChain.getSubprocess(i));
            }
            for (Operator innerOperator : operatorChain.getAllInnerOperators()) {
                CustomModuleUtils.addSubprocesses(allSubprocesses, innerOperator);
            }
        }
    }

    public static enum CustomOperatorType {
        STANDARD("standard"),
        USE_CASE_MODULE("use case module");

        private final String text;

        private CustomOperatorType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public static CustomOperatorType get(String text) {
            for (CustomOperatorType type : CustomOperatorType.values()) {
                if (!type.toString().equals(text)) continue;
                return type;
            }
            throw new IllegalArgumentException("There is no CustomOperatorType for the provided text: " + text);
        }
    }
}

