/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.util;

import com.rapidminer.tools.container.Pair;
import java.util.Objects;

public class CustomParameterInfo
implements Comparable<CustomParameterInfo> {
    private final String operator;
    private final String parameterKey;
    private String alias;
    private String documentation;
    private boolean optional;
    private boolean expert;
    private Pair<String, String> dependency;

    public CustomParameterInfo(String operator, String parameterKey) {
        this(operator, parameterKey, parameterKey, null, false, false);
    }

    public CustomParameterInfo(String operator, String parameterKey, String alias, String documentation, boolean optional, boolean expert) {
        this.operator = operator;
        this.parameterKey = parameterKey;
        this.alias = alias;
        this.documentation = documentation;
        this.optional = optional;
        this.expert = expert;
    }

    public String toString() {
        return this.operator + "." + this.parameterKey + ": " + this.alias;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomParameterInfo that = (CustomParameterInfo)o;
        return Objects.equals(this.operator, that.operator) && Objects.equals(this.parameterKey, that.parameterKey);
    }

    public int hashCode() {
        return Objects.hash(this.operator, this.parameterKey);
    }

    @Override
    public int compareTo(CustomParameterInfo o) {
        int result = this.operator.compareTo(o.operator);
        if (result != 0) {
            return result;
        }
        return this.parameterKey.compareTo(o.parameterKey);
    }

    public String getParameter() {
        return this.parameterKey;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getAlias() {
        return this.alias.replaceAll("(.)(\\p{Upper})", "$1_$2").toLowerCase();
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public boolean isExpert() {
        return this.expert;
    }

    public void setExpert(boolean expert) {
        this.expert = expert;
    }

    public Pair<String, String> getDependency() {
        return this.dependency;
    }

    public void setDependency(Pair<String, String> dependency) {
        this.dependency = dependency;
    }
}

