/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.util;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.tools.OperatorService;
import java.util.List;

public class PortInfo {
    private String rawPortType;
    private String description;

    public PortInfo(String rawPortType, String description) {
        this.rawPortType = rawPortType;
        this.description = description;
    }

    public String getRawPortType() {
        return this.rawPortType;
    }

    public String getPortType() {
        return this.rawPortType.substring(this.rawPortType.lastIndexOf(46) + 1);
    }

    public void setPortType(String portType) {
        Class<IOObject> ioObjectClass = OperatorService.getIOObjectClass((String)portType);
        if (ioObjectClass == null) {
            ioObjectClass = IOObject.class;
        }
        this.rawPortType = ioObjectClass.getName();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static void createPortInfos(Ports<?> ports, List<PortInfo> portInfos, List<String> portNames) {
        boolean isInput = ports instanceof OutputPorts;
        int index = 1;
        for (Port port : ports.getAllPorts()) {
            if (!port.isConnected()) continue;
            PortInfo portInfo = new PortInfo(PortInfo.getFromMD(port), isInput ? "An input port" : "A result port");
            portInfos.add(portInfo);
            portNames.add((isInput ? "input" : "result") + " " + index);
            ++index;
        }
    }

    private static String getFromMD(Port<?, ?> port) {
        MetaData metaData = port.getMetaData();
        if (metaData != null) {
            Class objectClass = metaData.getObjectClass();
            return objectClass.getName();
        }
        return IOObject.class.getName();
    }
}

