/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.util;

import com.rapidminer.RapidMiner;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.operator.UserError;
import com.rapidminer.repository.BinaryEntry;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryLocationBuilder;
import com.rapidminer.repository.RepositoryLocationType;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.repository.gui.RepositoryTree;
import com.rapidminer.repository.versioned.FilesystemRepositoryAdapter;
import com.rapidminer.repository.versioned.FilesystemRepositoryFactory;
import com.rapidminer.repository.versioned.NewFilesystemRepository;
import com.rapidminer.tools.FileSystemService;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.plugin.Plugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public enum RepositoryUtils {

    public static final String CUSTOM_OPERATOR_FILE_EXTENSION = "cusop";
    public static final String CUSTOM_EXTENSION_FILE_EXTENSION = "cusext";
    private static final String REPO_ALIAS_PREFIX = "Custom Extension\u2006\u200a\u2009hidden ";
    private static final String FILENAME_REPO_TIMESTAMP = "repoTimestamp";
    public static final Predicate<Entry> FILESYSTEM_REPOS_FILTER = entry -> {
        try {
            if (entry instanceof Folder && ((Folder)entry).isSpecialConnectionsFolder()) {
                return false;
            }
            return entry.getLocation().getRepository() instanceof FilesystemRepositoryAdapter;
        }
        catch (RepositoryException e) {
            LogService.getRoot().log(Level.WARNING, "Repository not found", e);
            return false;
        }
    };
    public static final Predicate<Entry> CUSTOM_OPERATORS_FILTER = RepositoryUtils.createEntryPredicate("cusop");
    public static final Predicate<Entry> CUSTOM_EXTENSION_FILTER = RepositoryUtils.createEntryPredicate("cusext");

    public static List<Path> getAllContent(Path folder, String extension) throws IOException {
        if (!Files.exists(folder, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try (Stream<Path> walk = Files.walk(folder, new FileVisitOption[0]);){
            List<Path> list = walk.filter(p -> p.getFileName().toString().endsWith(extension)).sorted().collect(Collectors.toList());
            return list;
        }
    }

    public static Path locationToFolderPath(String repoLocation) {
        if (repoLocation == null || repoLocation.isEmpty()) {
            return null;
        }
        try {
            RepositoryLocation repoLoc = new RepositoryLocationBuilder().withLocationType(RepositoryLocationType.FOLDER).buildFromAbsoluteLocation(repoLocation);
            String targetPath = repoLoc.getPath().startsWith("/") ? repoLoc.getPath().substring(1) : repoLoc.getPath();
            Path resolve = ((FilesystemRepositoryAdapter)repoLoc.getRepository()).getRoot().resolve(targetPath);
            if (!Files.exists(resolve, new LinkOption[0])) {
                return null;
            }
            return resolve;
        }
        catch (MalformedRepositoryLocationException | RepositoryException | ClassCastException e) {
            return null;
        }
    }

    public static Path locationToCusopPath(String repoLocation) {
        try {
            RepositoryLocation repoLoc = new RepositoryLocationBuilder().withExpectedDataEntryType(BinaryEntry.class).buildFromAbsoluteLocation(repoLocation);
            String targetPath = repoLoc.getPath().startsWith("/") ? repoLoc.getPath().substring(1) : repoLoc.getPath();
            return ((FilesystemRepositoryAdapter)repoLoc.getRepository()).getRoot().resolve(targetPath);
        }
        catch (MalformedRepositoryLocationException | RepositoryException | ClassCastException e) {
            return null;
        }
    }

    public static boolean checkFolder(String repoLocation) {
        try {
            RepositoryLocation repoLoc = new RepositoryLocationBuilder().withLocationType(RepositoryLocationType.FOLDER).buildFromAbsoluteLocation(repoLocation);
            Folder folder = repoLoc.locateFolder();
            if (folder == null) {
                return false;
            }
            return repoLoc.getRepository() instanceof FilesystemRepositoryAdapter;
        }
        catch (MalformedRepositoryLocationException | RepositoryException e) {
            return false;
        }
    }

    public static void refreshFolder(String repoLocation) {
        try {
            RepositoryLocation repoLoc = new RepositoryLocationBuilder().withLocationType(RepositoryLocationType.FOLDER).buildFromAbsoluteLocation(repoLocation);
            RepositoryTree repositoryTree = RapidMinerGUI.getMainFrame().getRepositoryBrowser().getRepositoryTree();
            repositoryTree.expandAndSelectIfExists(repoLoc);
            repositoryTree.REFRESH_ACTION.actionPerformed((Entry)repoLoc.locateFolder());
            repositoryTree.expandAndSelectIfExists(repoLoc);
        }
        catch (MalformedRepositoryLocationException | RepositoryException throwable) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyHiddenRepository(Plugin plugin) {
        Path target;
        String folderPath = "com/rapidminer/extension/resources/repository/";
        String fullDataPath = folderPath + "data";
        String fullSchmemaPath = folderPath + "schema";
        String fullTimestampPath = folderPath + "timestamp";
        URL resourceURL = plugin.getClassLoader().getResource(fullDataPath);
        URL resourceSchemaURL = plugin.getClassLoader().getResource(fullSchmemaPath);
        if (resourceURL == null && resourceSchemaURL == null) {
            return;
        }
        File pluginDir = FileSystemService.getPluginRapidMinerDir((String)plugin.getExtensionId());
        File repoDir = new File(pluginDir, "repository");
        URL resourceTimestampURL = plugin.getClassLoader().getResource(fullTimestampPath);
        if (repoDir.exists()) {
            if (resourceTimestampURL != null && RepositoryUtils.sameTimeStamp(resourceTimestampURL, pluginDir)) {
                LogService.getRoot().log(Level.INFO, "Same time stamp, not changing hidden repo");
                RepositoryUtils.createTransientRepository(plugin, repoDir, repoDir.toPath());
                return;
            }
            try {
                FileUtils.cleanDirectory((File)repoDir);
            }
            catch (IOException e) {
                LogService.getRoot().log(Level.WARNING, "Failed to clean hidden repo directory", e);
            }
        } else {
            boolean success = repoDir.mkdir();
            if (!success) {
                LogService.getRoot().log(Level.WARNING, "Failed to create hidden repo directory");
                return;
            }
        }
        if (RepositoryUtils.copyFiles(resourceURL, resourceSchemaURL, target = repoDir.toPath(), resourceTimestampURL, pluginDir.toPath())) {
            RepositoryUtils.createTransientRepository(plugin, repoDir, target);
        }
    }

    private static boolean copyFiles(URL resourceURL, URL resourceSchemaURL, Path target, URL resourceTimestampURL, Path pluginDir) {
        ArrayList<URL> resourceURLs = new ArrayList<URL>();
        if (resourceURL != null) {
            resourceURLs.add(resourceURL);
        }
        if (resourceSchemaURL != null) {
            resourceURLs.add(resourceSchemaURL);
        }
        for (URL url : resourceURLs) {
            try {
                InputStream resourceStream = url.openStream();
                try (ZipInputStream zipInputStream = new ZipInputStream(resourceStream);){
                    ZipEntry zipEntry = zipInputStream.getNextEntry();
                    while (zipEntry != null) {
                        Path entry = target.resolve(zipEntry.getName());
                        Files.createDirectories(entry.getParent(), new FileAttribute[0]);
                        Files.copy(zipInputStream, entry, new CopyOption[0]);
                        zipInputStream.closeEntry();
                        zipEntry = zipInputStream.getNextEntry();
                    }
                }
                finally {
                    if (resourceStream == null) continue;
                    resourceStream.close();
                }
            }
            catch (IOException e) {
                LogService.getRoot().log(Level.WARNING, "Failed copy into hidden repo directory", e);
                return false;
            }
        }
        if (resourceTimestampURL != null) {
            try (InputStream resourceStream = resourceTimestampURL.openStream();){
                Path timestampPath = pluginDir.resolve(FILENAME_REPO_TIMESTAMP);
                Files.copy(resourceStream, timestampPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LogService.getRoot().log(Level.WARNING, "Failed copy timestamp for hidden repo", e);
            }
        }
        return true;
    }

    private static void createTransientRepository(Plugin plugin, File repoDir, Path target) {
        String[] list = repoDir.list();
        if (list == null || list.length == 0) {
            return;
        }
        String repoAlias = REPO_ALIAS_PREFIX + plugin.getName();
        RapidMiner.addStartupHook(() -> {
            try {
                Repository hiddenRepo = RepositoryManager.getInstance(null).getRepository(repoAlias);
                try {
                    hiddenRepo.refresh();
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                return;
            }
            catch (RepositoryException hiddenRepo) {
                try {
                    FilesystemRepositoryFactory.createRepository((String)repoAlias, (Path)target, (boolean)false, (boolean)true, null);
                }
                catch (RepositoryException e) {
                    LogService.getRoot().log(Level.WARNING, "Failed create hidden repo", e);
                }
                return;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean sameTimeStamp(URL resourceTimestampURL, File pluginDir) {
        Path timestampPath = pluginDir.toPath().resolve(FILENAME_REPO_TIMESTAMP);
        try (InputStream inputStream = resourceTimestampURL.openStream();){
            byte[] expectedBytes = IOUtils.toByteArray((InputStream)inputStream);
            byte[] actualBytes = Files.readAllBytes(timestampPath);
            if (!Arrays.equals(expectedBytes, actualBytes)) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to read hidden repo timestamp", e);
        }
        return false;
    }

    private static Predicate<Entry> createEntryPredicate(String fileExtension) {
        return e -> {
            try {
                return e instanceof Folder && !((Folder)e).isSpecialConnectionsFolder() && e.getLocation().getRepository() instanceof NewFilesystemRepository || e instanceof BinaryEntry && e.getName().toLowerCase(Locale.ENGLISH).endsWith(fileExtension);
            }
            catch (RepositoryException ex) {
                return false;
            }
        };
    }

    public static Repository hiddenRepoForExtension(String extensionName) throws RepositoryException, UserError {
        String trimmedName = extensionName.trim();
        String repoAlias = REPO_ALIAS_PREFIX + trimmedName;
        try {
            return RepositoryManager.getInstance(null).getRepository(repoAlias);
        }
        catch (RepositoryException e) {
            for (Plugin allPlugin : Plugin.getAllPlugins()) {
                if (!allPlugin.getName().equals(trimmedName)) continue;
                throw e;
            }
            throw new UserError(null, "process_defined_operators.extension_not_exist", new Object[]{trimmedName});
        }
    }
}

