/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.util;

import com.rapidminer.RepositoryProcessLocation;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryLocationBuilder;
import com.rapidminer.tools.LogService;
import java.io.IOException;
import java.util.Locale;

public class TutorialInfo {
    private static final String EMPTY_PROCESS_XML = "<process version=\"9.11.000-SNAPSHOT\">\n  <operator activated=\"true\" class=\"process\" compatibility=\"9.11.000-SNAPSHOT\" expanded=\"true\" name=\"Process\">\n    <process expanded=\"true\">\n      <portSpacing port=\"source_input 1\" spacing=\"0\"/>\n      <portSpacing port=\"sink_result 1\" spacing=\"0\"/>\n      <description align=\"center\" color=\"yellow\" colored=\"false\" height=\"105\" resized=\"false\" width=\"180\" x=\"86\" y=\"40\">EMPTY</description>\n    </process>\n  </operator>\n</process>";
    private static final String XML_START = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private String title;
    private String description;
    private String xml;
    private String location = null;
    private boolean useXML = false;

    public TutorialInfo() {
    }

    public TutorialInfo(String title, String description, String xml, String location) {
        this.title = title;
        this.description = description;
        this.location = location;
        this.useXML = (location == null || location.isEmpty()) && xml != null && !xml.isEmpty();
        this.setXml(xml);
    }

    public boolean isEmpty() {
        return !(this.title != null && !this.title.isEmpty() || this.description != null && !this.description.isEmpty() || this.xml != null && !this.xml.isEmpty() || this.location != null && !this.location.isEmpty());
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return this.title == null ? "Unknown title" : this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleKey() {
        return this.getTitle().toLowerCase(Locale.ENGLISH).replace(' ', '_');
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getXml() {
        return this.xml == null ? "" : this.xml;
    }

    public String getProcessXml() {
        if (this.useXML) {
            return this.xml == null || this.xml.isEmpty() ? EMPTY_PROCESS_XML : this.xml;
        }
        if (this.location == null || this.location.isEmpty()) {
            return EMPTY_PROCESS_XML;
        }
        try {
            RepositoryProcessLocation processLocation = new RepositoryProcessLocation(new RepositoryLocationBuilder().withExpectedDataEntryType(ProcessEntry.class).buildFromAbsoluteLocation(this.location));
            return processLocation.getRawXML().replace(XML_START, "");
        }
        catch (MalformedRepositoryLocationException | IOException e) {
            LogService.getRoot().warning("Tutorial process for custom operator could not be loaded from location " + this.location);
            return EMPTY_PROCESS_XML;
        }
    }

    public void setXml(String xml) {
        this.xml = xml != null ? xml.replace(XML_START, "") : null;
    }

    public void setUseXML(boolean useXML) {
        this.useXML = useXML;
    }

    public boolean useXML() {
        return this.useXML;
    }
}

