/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.bridge;

import com.altair.ks_engine.bridge.BridgeStatus;
import com.altair.ks_engine.bridge.EngineStatus;
import com.altair.ks_engine.bridge.KSEngineConnectionHandler;
import com.altair.ks_engine.bridge.exception.KSEngineNotReadyException;
import com.altair.ks_engine.bridge.exception.KSEngineQueryQueueFullException;
import com.altair.ks_engine.bridge.listener.KSEngineBridgeListener;
import com.altair.ks_engine.bridge.listener.KSEngineLifecycleListener;
import com.altair.ks_engine.query.KSQuery;
import com.altair.ks_engine.query.KSResult;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ShutdownHooks;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public enum KSEngineBridge {
    INSTANCE;

    private final List<KSEngineBridgeListener> listenerList = Collections.synchronizedList(new ArrayList());
    private final ExecutorService listenerNotificationService = Executors.newFixedThreadPool(1);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private volatile BridgeStatus bridgeStatus = BridgeStatus.NOT_READY;
    private KSEngineLifecycleListener engineLister;

    public synchronized void initialize() {
        if (this.initialized.compareAndSet(false, true)) {
            LogService.getRoot().log(Level.FINE, "Initializing KS engine bridge");
            this.engineLister = new KSEngineLifecycleListener(){

                @Override
                public void engineStarting() {
                    KSEngineBridge.this.setBridgeStatus(BridgeStatus.NOT_READY);
                }

                @Override
                public void engineRunning() {
                    KSEngineBridge.this.setBridgeStatus(BridgeStatus.NOT_READY);
                }

                @Override
                public void engineStopping() {
                    KSEngineBridge.this.setBridgeStatus(BridgeStatus.NOT_READY);
                }

                @Override
                public void engineOffline() {
                    KSEngineBridge.this.setBridgeStatus(BridgeStatus.NOT_READY);
                }

                @Override
                public void engineConnected() {
                    KSEngineBridge.this.setBridgeStatus(BridgeStatus.NOT_READY);
                }

                @Override
                public void engineDisconnected() {
                    KSEngineBridge.this.setBridgeStatus(BridgeStatus.NOT_READY);
                }

                @Override
                public void engineReady() {
                    KSEngineBridge.this.setBridgeStatus(BridgeStatus.READY);
                }

                @Override
                public void engineBusy() {
                    KSEngineBridge.this.setBridgeStatus(BridgeStatus.BUSY);
                }

                @Override
                public void engineErrorRetryable() {
                    KSEngineBridge.this.setBridgeStatus(BridgeStatus.NOT_READY);
                }

                @Override
                public void engineErrorSevere() {
                    KSEngineBridge.this.setBridgeStatus(BridgeStatus.ERROR);
                }

                @Override
                public void engineErrorFatal() {
                    KSEngineBridge.this.setBridgeStatus(BridgeStatus.ERROR);
                }
            };
            KSEngineConnectionHandler.INSTANCE.registerEngineListener(this.engineLister);
            KSEngineConnectionHandler.INSTANCE.initialize();
            ShutdownHooks.addShutdownHook(this::shutdown);
        }
    }

    public Future<KSResult> submitQuery(KSQuery query) throws KSEngineNotReadyException, KSEngineQueryQueueFullException {
        ValidationUtilV2.requireNonNull((Object)query, (String)"query");
        if (this.bridgeStatus == BridgeStatus.NOT_READY || this.bridgeStatus == BridgeStatus.ERROR) {
            throw new KSEngineNotReadyException("KS engine bridge not ready!");
        }
        return KSEngineConnectionHandler.INSTANCE.submitQuery(query);
    }

    public void registerEngineBridgeListener(KSEngineBridgeListener listener) {
        this.listenerList.add((KSEngineBridgeListener)ValidationUtilV2.requireNonNull((Object)listener, (String)"listener"));
        this.notifyListeners(Collections.singletonList(listener), this.bridgeStatus);
    }

    public void unregisterEngineBridgeListener(KSEngineBridgeListener listener) {
        this.listenerList.remove(ValidationUtilV2.requireNonNull((Object)listener, (String)"listener"));
    }

    public void registerEngineListener(KSEngineLifecycleListener listener) {
        KSEngineConnectionHandler.INSTANCE.registerEngineListener((KSEngineLifecycleListener)ValidationUtilV2.requireNonNull((Object)listener, (String)"listener"));
    }

    public void unregisterEngineListener(KSEngineLifecycleListener listener) {
        KSEngineConnectionHandler.INSTANCE.unregisterEngineLifecycleListener((KSEngineLifecycleListener)ValidationUtilV2.requireNonNull((Object)listener, (String)"listener"));
    }

    public BridgeStatus getBridgeStatus() {
        return this.bridgeStatus;
    }

    public EngineStatus getEngineStatus() {
        return KSEngineConnectionHandler.INSTANCE.getEngineStatus();
    }

    public void shutdown() {
        if (this.initialized.compareAndSet(true, false)) {
            this.setBridgeStatus(BridgeStatus.NOT_READY);
            KSEngineConnectionHandler.INSTANCE.shutdown();
            KSEngineConnectionHandler.INSTANCE.unregisterEngineLifecycleListener(this.engineLister);
            this.engineLister = null;
        }
    }

    private void setBridgeStatus(BridgeStatus status) {
        if (this.bridgeStatus != status) {
            this.bridgeStatus = status;
            this.notifyAllListeners(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllListeners(BridgeStatus status) {
        List<KSEngineBridgeListener> list = this.listenerList;
        synchronized (list) {
            this.notifyListeners(this.listenerList, status);
        }
    }

    private void notifyListeners(List<KSEngineBridgeListener> listenerList, BridgeStatus status) {
        block6: for (KSEngineBridgeListener listener : listenerList) {
            switch (status) {
                case READY: {
                    this.notifyListener(listener::bridgeReady);
                    continue block6;
                }
                case BUSY: {
                    this.notifyListener(listener::bridgeBusy);
                    continue block6;
                }
                case NOT_READY: {
                    this.notifyListener(listener::bridgeNotReady);
                    continue block6;
                }
                case ERROR: {
                    this.notifyListener(listener::bridgeError);
                    continue block6;
                }
            }
            LogService.getRoot().log(Level.WARNING, () -> String.format("KS BridgeStatus %s not handled, cannot notify listeners!", new Object[]{status}));
            break;
        }
    }

    private void notifyListener(Runnable r) {
        try {
            this.listenerNotificationService.submit(r);
        }
        catch (RejectedExecutionException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to notify listener about KS Bridge event", e);
        }
    }
}

