/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.bridge;

import com.altair.ks_engine.bridge.EngineStatus;
import com.altair.ks_engine.bridge.KSEngineBridge;
import com.altair.ks_engine.bridge.KSEngineInstallationHandler;
import com.altair.ks_engine.bridge.KSEngineSettings;
import com.altair.ks_engine.bridge.KSEngineSocket;
import com.altair.ks_engine.bridge.exception.KSEngineInstallationException;
import com.altair.ks_engine.bridge.exception.KSEngineInvalidSettingException;
import com.altair.ks_engine.bridge.exception.KSEngineLoginException;
import com.altair.ks_engine.bridge.exception.KSEngineQueryQueueFullException;
import com.altair.ks_engine.bridge.exception.KSEngineShutdownException;
import com.altair.ks_engine.bridge.exception.KSEngineStartupException;
import com.altair.ks_engine.bridge.listener.KSEngineLifecycleListener;
import com.altair.ks_engine.bridge.listener.KSEngineSocketListener;
import com.altair.ks_engine.query.KSQuery;
import com.altair.ks_engine.query.KSResult;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

enum KSEngineConnectionHandler {
    INSTANCE;

    private final List<KSEngineLifecycleListener> listenerList = Collections.synchronizedList(new ArrayList());
    private final ExecutorService listenerNotificationService = Executors.newFixedThreadPool(1);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicBoolean retry = new AtomicBoolean(true);
    private EngineStatus engineStatus = EngineStatus.OFFLINE;
    private KSEngineSocketListener socketListener;
    private KSEngineLifecycleListener logListener;
    private Timer retryTimer;

    synchronized void initialize() {
        if (this.initialized.compareAndSet(false, true)) {
            LogService.getRoot().log(Level.FINE, "Initializing KS engine handler");
            this.logListener = new KSEngineLifecycleListener(){

                @Override
                public void engineStarting() {
                    LogService.getRoot().log(Level.INFO, "Starting KS engine");
                }

                @Override
                public void engineRunning() {
                    LogService.getRoot().log(Level.INFO, "Started KS engine");
                }

                @Override
                public void engineStopping() {
                    LogService.getRoot().log(Level.INFO, "Stopping KS engine");
                }

                @Override
                public void engineOffline() {
                    LogService.getRoot().log(Level.INFO, "KS engine offline");
                }

                @Override
                public void engineConnected() {
                    LogService.getRoot().log(Level.INFO, "Connected to KS engine");
                }

                @Override
                public void engineDisconnected() {
                    LogService.getRoot().log(Level.INFO, "Disconnected from KS engine");
                }

                @Override
                public void engineReady() {
                    LogService.getRoot().log(Level.FINER, "KS engine is ready");
                }

                @Override
                public void engineBusy() {
                    LogService.getRoot().log(Level.FINER, "KS engine is busy");
                }

                @Override
                public void engineErrorRetryable() {
                    LogService.getRoot().log(Level.SEVERE, "KS engine - retryable error");
                }

                @Override
                public void engineErrorSevere() {
                    LogService.getRoot().log(Level.SEVERE, "KS engine - severe error");
                }

                @Override
                public void engineErrorFatal() {
                    LogService.getRoot().log(Level.SEVERE, "KS engine - fatal error");
                }
            };
            this.registerEngineListener(this.logListener);
            this.setEngineStatus(EngineStatus.STARTING);
            KSEngineSettings.INSTANCE.initialize();
            this.socketListener = new KSEngineSocketListener(){

                @Override
                public void socketConnected() {
                    KSEngineConnectionHandler.this.setEngineStatus(EngineStatus.CONNECTED);
                    try {
                        KSEngineConnectionHandler.this.loginToKSEngine();
                        KSEngineConnectionHandler.this.retry.set(true);
                    }
                    catch (KSEngineLoginException e) {
                        if (e.getCause() instanceof KSEngineInvalidSettingException) {
                            LogService.getRoot().log(Level.SEVERE, e.getMessage(), e);
                            KSEngineConnectionHandler.this.setEngineStatus(EngineStatus.ERROR_FATAL);
                        }
                        LogService.getRoot().log(Level.SEVERE, "Failed to log into KS engine, KS features will not be available!", e);
                        KSEngineConnectionHandler.this.setEngineStatus(EngineStatus.ERROR_SEVERE);
                    }
                }

                @Override
                public void socketLoginFailed(Exception e) {
                    LogService.getRoot().log(Level.SEVERE, "Failed to log into KS engine, KS features will not be available!", e);
                    KSEngineConnectionHandler.this.setEngineStatus(EngineStatus.ERROR_SEVERE);
                }

                @Override
                public void socketConnectionFailed(int errorCount, Exception e) {
                    if (KSEngineConnectionHandler.this.engineStatus == EngineStatus.ERROR_FATAL) {
                        return;
                    }
                    if (errorCount <= 5) {
                        KSEngineConnectionHandler.this.setEngineStatus(EngineStatus.ERROR_RETRY);
                        long backoffValue = (long)(errorCount * errorCount) * 500L;
                        if (KSEngineConnectionHandler.this.retryTimer != null) {
                            KSEngineConnectionHandler.this.retryTimer.cancel();
                        }
                        KSEngineConnectionHandler.this.retryTimer = new Timer(true);
                        KSEngineConnectionHandler.this.retryTimer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                KSEngineConnectionHandler.this.connectToKSEngine();
                            }
                        }, backoffValue);
                        LogService.getRoot().log(Level.WARNING, String.format("Error #%d connecting to KS engine, will retry in %d ms!", errorCount, backoffValue), e);
                    } else {
                        LogService.getRoot().log(Level.SEVERE, "Failed connecting to KS engine!", e);
                        KSEngineConnectionHandler.this.setEngineStatus(EngineStatus.ERROR_SEVERE);
                        if (KSEngineConnectionHandler.this.retry.compareAndSet(true, false)) {
                            KSEngineConnectionHandler.restartEngine();
                        }
                    }
                }

                @Override
                public void socketReady() {
                    KSEngineConnectionHandler.this.setEngineStatus(EngineStatus.READY);
                }

                @Override
                public void socketBusy() {
                    KSEngineConnectionHandler.this.setEngineStatus(EngineStatus.BUSY);
                }

                @Override
                public void socketClosed() {
                    if (KSEngineConnectionHandler.this.engineStatus == EngineStatus.ERROR_FATAL || KSEngineConnectionHandler.this.engineStatus == EngineStatus.ERROR_SEVERE || KSEngineConnectionHandler.this.engineStatus == EngineStatus.ERROR_RETRY || KSEngineConnectionHandler.this.engineStatus == EngineStatus.STARTING) {
                        return;
                    }
                    KSEngineConnectionHandler.this.setEngineStatus(EngineStatus.DISCONNECTED);
                    KSEngineConnectionHandler.this.connectToKSEngine();
                }
            };
            if (this.isSocketInUse()) {
                LogService.getRoot().log(Level.FINE, "KS engine socket is in use, trying to use external engine");
                KSEngineInstallationHandler.INSTANCE.useExternalKSEngine();
            } else {
                LogService.getRoot().log(Level.FINE, "KS engine socket not in use, using internal engine");
                KSEngineInstallationHandler.INSTANCE.useInternalKSEngine();
            }
            try {
                if (!KSEngineInstallationHandler.INSTANCE.isKSEngineInstalled()) {
                    KSEngineInstallationHandler.INSTANCE.installKSEngine();
                }
            }
            catch (KSEngineInstallationException e) {
                LogService.getRoot().log(Level.SEVERE, "Failed to install KS engine, KS features will not be available!", e);
                this.setEngineStatus(EngineStatus.ERROR_FATAL);
            }
            try {
                if (!KSEngineInstallationHandler.INSTANCE.isKSEngineRunning()) {
                    KSEngineInstallationHandler.INSTANCE.startKSEngine();
                    this.setEngineStatus(EngineStatus.RUNNING);
                }
            }
            catch (KSEngineStartupException e) {
                LogService.getRoot().log(Level.SEVERE, "Failed to start KS engine, KS features will not be available!", e);
                this.setEngineStatus(EngineStatus.ERROR_FATAL);
            }
            KSEngineSocket.INSTANCE.registerSocketListener(this.socketListener);
            KSEngineSocket.INSTANCE.initialize();
            this.connectToKSEngine();
        }
    }

    void registerEngineListener(KSEngineLifecycleListener listener) {
        this.listenerList.add((KSEngineLifecycleListener)ValidationUtilV2.requireNonNull((Object)listener, (String)"listener"));
        this.notifyListeners(Collections.singletonList(listener), this.engineStatus);
    }

    void unregisterEngineLifecycleListener(KSEngineLifecycleListener listener) {
        this.listenerList.remove(ValidationUtilV2.requireNonNull((Object)listener, (String)"listener"));
    }

    void connectToKSEngine() {
        LogService.getRoot().log(Level.FINE, "Connecting to KS engine");
        try {
            KSEngineSocket.INSTANCE.connectToSocket(KSEngineSettings.INSTANCE.getHost(), KSEngineSettings.INSTANCE.getPort());
        }
        catch (KSEngineInvalidSettingException e) {
            LogService.getRoot().log(Level.SEVERE, () -> String.format("KS settings invalid: %s KS engine will not be available!", e.getMessage()));
            this.setEngineStatus(EngineStatus.ERROR_FATAL);
        }
    }

    void loginToKSEngine() throws KSEngineLoginException {
        LogService.getRoot().log(Level.FINE, "Logging into KS engine");
        try {
            KSEngineSocket.INSTANCE.login(KSEngineSettings.INSTANCE.getWorkspaceLocation(), KSEngineSettings.INSTANCE.getUser());
        }
        catch (KSEngineInvalidSettingException e) {
            throw new KSEngineLoginException(String.format("Could not log into KS engine due to invalid settings: %s. Affected key: %s", e.getMessage(), e.getKey()), e);
        }
    }

    synchronized Future<KSResult> submitQuery(KSQuery query) throws KSEngineQueryQueueFullException {
        return KSEngineSocket.INSTANCE.submitQuery(query);
    }

    synchronized void shutdown() {
        if (this.initialized.compareAndSet(true, false)) {
            if (this.retryTimer != null) {
                this.retryTimer.cancel();
                this.retryTimer = null;
            }
            KSEngineSocket.INSTANCE.shutdown();
            KSEngineSocket.INSTANCE.unregisterSocketListener(this.socketListener);
            this.socketListener = null;
            if (KSEngineInstallationHandler.INSTANCE.isKSEngineShutdownPossible()) {
                try {
                    this.setEngineStatus(EngineStatus.STOPPING);
                    KSEngineInstallationHandler.INSTANCE.shutdownKSEngine();
                    this.setEngineStatus(EngineStatus.OFFLINE);
                }
                catch (KSEngineShutdownException e) {
                    LogService.getRoot().log(Level.SEVERE, "Failed to shutdown KS engine!", e);
                    this.setEngineStatus(EngineStatus.DISCONNECTED);
                }
            }
            this.unregisterEngineLifecycleListener(this.logListener);
            this.logListener = null;
        }
    }

    EngineStatus getEngineStatus() {
        return this.engineStatus;
    }

    private boolean isSocketInUse() {
        boolean bl;
        Socket socket = new Socket(KSEngineSettings.INSTANCE.getHost(), KSEngineSettings.INSTANCE.getPort());
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (KSEngineInvalidSettingException | IOException e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    private void setEngineStatus(EngineStatus status) {
        if (this.engineStatus != status) {
            this.engineStatus = status;
            this.notifyAllListeners(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllListeners(EngineStatus status) {
        List<KSEngineLifecycleListener> list = this.listenerList;
        synchronized (list) {
            this.notifyListeners(this.listenerList, status);
        }
    }

    private void notifyListeners(List<KSEngineLifecycleListener> listenerList, EngineStatus status) {
        block13: for (KSEngineLifecycleListener listener : listenerList) {
            switch (status) {
                case STARTING: {
                    this.notifyListener(listener::engineStarting);
                    continue block13;
                }
                case RUNNING: {
                    this.notifyListener(listener::engineRunning);
                    continue block13;
                }
                case CONNECTED: {
                    this.notifyListener(listener::engineConnected);
                    continue block13;
                }
                case DISCONNECTED: {
                    this.notifyListener(listener::engineDisconnected);
                    continue block13;
                }
                case READY: {
                    this.notifyListener(listener::engineReady);
                    continue block13;
                }
                case BUSY: {
                    this.notifyListener(listener::engineBusy);
                    continue block13;
                }
                case ERROR_RETRY: {
                    this.notifyListener(listener::engineErrorRetryable);
                    continue block13;
                }
                case ERROR_SEVERE: {
                    this.notifyListener(listener::engineErrorSevere);
                    continue block13;
                }
                case ERROR_FATAL: {
                    this.notifyListener(listener::engineErrorFatal);
                    continue block13;
                }
                case STOPPING: {
                    this.notifyListener(listener::engineStopping);
                    continue block13;
                }
                case OFFLINE: {
                    this.notifyListener(listener::engineOffline);
                    continue block13;
                }
            }
            LogService.getRoot().log(Level.WARNING, () -> String.format("KS engineStatus %s not handled, cannot notify listeners!", new Object[]{status}));
            break;
        }
    }

    private void notifyListener(Runnable r) {
        try {
            this.listenerNotificationService.submit(r);
        }
        catch (RejectedExecutionException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to notify listener about KS engine lifecycle event", e);
        }
    }

    private static void restartEngine() {
        Thread thread = new Thread(() -> {
            KSEngineBridge.INSTANCE.shutdown();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            KSEngineBridge.INSTANCE.initialize();
        });
        thread.setDaemon(true);
        thread.start();
    }
}

