/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.bridge;

import com.altair.ks_engine.bridge.KSEngineSettings;
import com.altair.ks_engine.bridge.exception.KSEngineInstallationException;
import com.altair.ks_engine.bridge.exception.KSEngineShutdownException;
import com.altair.ks_engine.bridge.exception.KSEngineStartupException;
import com.altair.ks_engine.bridge.installer.KSEngineInstaller;
import com.altair.ks_engine.util.KSEngineTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.logging.Level;

public enum KSEngineInstallationHandler {
    INSTANCE;

    private KSEngineInstaller customInstaller;
    private KSEngineInstaller currentInstaller;

    void useExternalKSEngine() {
        this.currentInstaller = KSEngineTools.createInstallerForExternalKSEngine();
    }

    void useInternalKSEngine() {
        if (this.customInstaller != null) {
            this.currentInstaller = this.customInstaller;
        }
    }

    public void registerCustomInstaller(KSEngineInstaller installer) {
        if (this.customInstaller != null) {
            return;
        }
        this.customInstaller = (KSEngineInstaller)ValidationUtilV2.requireNonNull((Object)installer, (String)"installer");
    }

    boolean isKSEngineInstalled() throws KSEngineInstallationException {
        if (this.currentInstaller == null) {
            throw new KSEngineInstallationException("installer not registered!");
        }
        return this.currentInstaller.isEngineInstalled();
    }

    void installKSEngine() throws KSEngineInstallationException {
        if (this.currentInstaller == null) {
            throw new KSEngineInstallationException("installer not registered!");
        }
        LogService.getRoot().log(Level.INFO, "Installing KS engine");
        this.currentInstaller.installEngine();
        LogService.getRoot().log(Level.INFO, "Installed KS engine");
    }

    boolean isKSEngineRunning() throws KSEngineStartupException {
        if (this.currentInstaller == null) {
            throw new KSEngineStartupException("installer not registered!");
        }
        return this.currentInstaller.isKSEngineRunning();
    }

    void startKSEngine() throws KSEngineStartupException {
        if (this.currentInstaller == null) {
            throw new KSEngineStartupException("installer not registered!");
        }
        LogService.getRoot().log(Level.INFO, "Starting KS engine");
        this.currentInstaller.startKSEngine(KSEngineSettings.INSTANCE.getPort());
    }

    boolean isKSEngineShutdownPossible() {
        return this.currentInstaller.isKSEngineShutdownPossible();
    }

    void shutdownKSEngine() throws KSEngineShutdownException {
        if (this.currentInstaller == null) {
            throw new KSEngineShutdownException("installer not registered!");
        }
        LogService.getRoot().log(Level.INFO, "Shutting down KS engine");
        this.currentInstaller.shutdownKSEngine();
    }
}

