/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.bridge;

import com.altair.ks_engine.bridge.KSDebugMode;
import com.altair.ks_engine.bridge.exception.KSEngineInvalidSettingException;
import com.rapidminer.settings.Settings;
import com.rapidminer.tools.LogService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;

enum KSEngineSettings {
    INSTANCE;

    private final AtomicBoolean initializing = new AtomicBoolean(false);
    private String workspaceLocation;
    private String host;
    private int port;
    private String user;

    synchronized void initialize() {
        block6: {
            try {
                if (!this.initializing.compareAndSet(false, true)) break block6;
                LogService.getRoot().log(Level.INFO, "Initializing KS engine settings");
                this.workspaceLocation = StringUtils.trimToNull((String)Settings.getSetting((String)"altair-library", (String)"ks-engine-workspace-location"));
                this.host = StringUtils.trimToNull((String)Settings.getSetting((String)"altair-library", (String)"ks-engine-host"));
                String portSetting = StringUtils.trimToNull((String)Settings.getSetting((String)"altair-library", (String)"ks-engine-port"));
                try {
                    this.port = Integer.parseInt(portSetting);
                }
                catch (NumberFormatException e) {
                    this.port = -1;
                }
                String userProp = StringUtils.trimToNull((String)System.getProperty("user.name"));
                if (userProp == null) {
                    LogService.getRoot().log(Level.INFO, () -> String.format("Cannot determine user name, falling back to system property '%s'", "ks-engine-user"));
                    userProp = StringUtils.trimToNull((String)System.getProperty("ks-engine-user"));
                }
                this.user = userProp;
            }
            finally {
                this.initializing.set(false);
            }
        }
    }

    String getWorkspaceLocation() throws KSEngineInvalidSettingException {
        if (this.workspaceLocation == null) {
            throw new KSEngineInvalidSettingException("The workspaceLocation is missing", "ks-engine-workspace-location");
        }
        return this.workspaceLocation;
    }

    String getHost() throws KSEngineInvalidSettingException {
        if (this.host == null) {
            throw new KSEngineInvalidSettingException("The host is missing", "ks-engine-host");
        }
        return this.host;
    }

    int getPort() throws KSEngineInvalidSettingException {
        if (this.port == -1) {
            throw new KSEngineInvalidSettingException("The port is missing or not a number", "ks-engine-port");
        }
        if (this.port < 1024) {
            throw new KSEngineInvalidSettingException("The port number must be at least 1024", "ks-engine-port");
        }
        return this.port;
    }

    String getUser() throws KSEngineInvalidSettingException {
        if (this.user == null) {
            throw new KSEngineInvalidSettingException(String.format("The user is missing, neither 'user.name' nor '%s' system properties were set", "ks-engine-user"), "ks-engine-user");
        }
        return this.user;
    }

    KSDebugMode getDebugMode() {
        return KSDebugMode.parseDebugMode(Settings.getSetting((String)"altair-library", (String)"ks-engine-debug-mode"));
    }
}

