/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.bridge;

import com.altair.ks_engine.bridge.KSDebugMode;
import com.altair.ks_engine.bridge.KSEngineSettings;
import com.altair.ks_engine.bridge.KSQueryTask;
import com.altair.ks_engine.bridge.SocketStatus;
import com.altair.ks_engine.bridge.exception.KSEngineLoginException;
import com.altair.ks_engine.bridge.exception.KSEngineQueryProcessingException;
import com.altair.ks_engine.bridge.exception.KSEngineQueryQueueFullException;
import com.altair.ks_engine.bridge.exception.KSEngineShutdownException;
import com.altair.ks_engine.bridge.listener.KSEngineSocketListener;
import com.altair.ks_engine.query.KSCustomQuery;
import com.altair.ks_engine.query.KSError;
import com.altair.ks_engine.query.KSQuery;
import com.altair.ks_engine.query.KSResult;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Phaser;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

enum KSEngineSocket {
    INSTANCE;

    private final List<KSEngineSocketListener> listenerList = Collections.synchronizedList(new ArrayList());
    private final ExecutorService listenerNotificationService = Executors.newFixedThreadPool(1);
    private final ExecutorService readerService = Executors.newFixedThreadPool(1, r -> {
        Thread t = new Thread(r, "ks-engine-connection-reader");
        t.setDaemon(true);
        return t;
    });
    private final ExecutorService queryService = Executors.newFixedThreadPool(1, r -> {
        Thread t = new Thread(r, "ks-engine-query-submitter");
        t.setDaemon(true);
        return t;
    });
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicBoolean shutdownRequested = new AtomicBoolean(false);
    private final AtomicInteger errorCounter = new AtomicInteger(0);
    private Socket clientSocket;
    private BufferedReader in;
    private PrintWriter out;
    private Phaser submissionPhaser;
    private final AtomicInteger phase = new AtomicInteger(0);
    private final LinkedBlockingQueue<KSQueryTask> queryQueue = new LinkedBlockingQueue(128);
    private volatile KSQueryTask loginTask = null;
    private volatile KSQueryTask currentTask = null;
    private volatile SocketStatus socketStatus = SocketStatus.CLOSED;

    synchronized void initialize() {
        if (this.initialized.compareAndSet(false, true)) {
            LogService.getRoot().log(Level.FINE, "Initializing KS engine socket");
            this.submissionPhaser = new Phaser(1);
            this.phase.set(0);
            this.shutdownRequested.set(false);
            this.queryService.submit(this.createSubmissionSender());
        }
    }

    void registerSocketListener(KSEngineSocketListener listener) {
        this.listenerList.add((KSEngineSocketListener)ValidationUtilV2.requireNonNull((Object)listener, (String)"listener"));
        this.notifyListeners(Collections.singletonList(listener), this.socketStatus);
    }

    void unregisterSocketListener(KSEngineSocketListener listener) {
        this.listenerList.remove(ValidationUtilV2.requireNonNull((Object)listener, (String)"listener"));
    }

    synchronized void connectToSocket(String host, int port) {
        if (this.clientSocket != null) {
            LogService.getRoot().log(Level.WARNING, "Cannot connect KS engine socket, socket already set!");
            return;
        }
        try {
            this.clientSocket = new Socket(host, port);
            this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            this.out = new PrintWriter(this.clientSocket.getOutputStream(), true);
        }
        catch (IOException e) {
            this.notifyListenersConnectionFailure(this.errorCounter.incrementAndGet(), e);
            return;
        }
        this.readerService.submit(this.createSocketStreamListenerRunnable());
    }

    synchronized void login(String workspaceLocation, String user) throws KSEngineLoginException {
        if (this.socketStatus != SocketStatus.CONNECTED) {
            throw new KSEngineLoginException("Socket connection was not waiting for login, but was: " + this.socketStatus);
        }
        this.setSocketStatus(SocketStatus.LOGGING_IN);
        this.loginTask = new KSQueryTask(new KSCustomQuery(String.format("Mining Location=%s;UID=%s;authenticator=NOT_SECURE_AUTHENTICATION;ENHANCED_TIME=true", workspaceLocation, user)));
        this.out.println(this.loginTask.getQuery().getProcessedQuery());
    }

    synchronized Future<KSResult> submitQuery(KSQuery query) throws KSEngineQueryQueueFullException {
        KSQueryTask task = new KSQueryTask(query);
        if (!this.queryQueue.offer(task)) {
            throw new KSEngineQueryQueueFullException("Could not submit query, queue was full");
        }
        LogService.getRoot().log(Level.FINE, "KS engine query added to queue: " + query);
        return task.getFutureTask();
    }

    synchronized void closeSocket() {
        try {
            this.setSocketStatus(SocketStatus.CLOSED);
            if (this.clientSocket != null) {
                this.clientSocket.close();
            }
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to close connection socket to KS engine.", e);
        }
        finally {
            this.clientSocket = null;
        }
    }

    void shutdown() {
        if (this.initialized.compareAndSet(true, false)) {
            this.shutdownRequested.set(true);
            this.closeSocketAndResetState(new KSEngineShutdownException("KS engine shutting down."), true);
        }
    }

    private void closeSocketAndResetState(Exception e, boolean resetErrorCounter) {
        this.closeSocket();
        this.submissionPhaser.forceTermination();
        if (resetErrorCounter) {
            this.errorCounter.set(0);
        }
        this.queryQueue.clear();
        if (this.currentTask != null) {
            this.currentTask.markException(e);
            this.completeQueryTaskAsync(this.currentTask);
            this.currentTask = null;
        }
    }

    private Runnable createSocketStreamListenerRunnable() {
        return () -> {
            try {
                while (!this.shutdownRequested.get()) {
                    String line = this.in.readLine();
                    if (KSEngineSettings.INSTANCE.getDebugMode() == KSDebugMode.ALL) {
                        System.out.println(line);
                    }
                    if (line == null) {
                        if (this.socketStatus == SocketStatus.LOGGING_IN) {
                            this.notifyListenersLoginFailure(new KSEngineLoginException("Login failed. Invalid credentials?"));
                            break;
                        }
                        LogService.getRoot().log(Level.INFO, "Connection was closed by KS engine due to inactivity.");
                        this.closeSocket();
                        break;
                    }
                    if (line.startsWith("#?! ready kslogin")) {
                        this.errorCounter.set(0);
                        this.setSocketStatus(SocketStatus.CONNECTED);
                        continue;
                    }
                    if (line.startsWith("#?! ready ksquery")) {
                        if (this.currentTask != null) {
                            LogService.getRoot().log(Level.FINE, "KS engine query completed, returning result");
                            this.completeCurrentTask();
                            continue;
                        }
                        if (this.socketStatus == SocketStatus.LOGGING_IN) {
                            this.setSocketStatus(SocketStatus.READY);
                            this.loginTask = null;
                            this.submissionPhaser.arrive();
                            continue;
                        }
                        throw new IllegalStateException("UNEXPECTED STATE FOR KS ENGINE SOCKET: " + this.socketStatus);
                    }
                    if (line.startsWith("#?! empty")) {
                        if (this.currentTask != null) {
                            LogService.getRoot().log(Level.FINE, "Reading KS engine empty response");
                            this.currentTask.markEmpty();
                            continue;
                        }
                        throw new IllegalStateException("UNEXPECTED STATE WHEN READING EMPTY RESULT: " + this.socketStatus);
                    }
                    if (this.socketStatus == SocketStatus.LOGGING_IN) {
                        if (this.loginTask.isReadingError()) {
                            this.loginTask.addErrorLine(line);
                            this.loginTask.markError();
                            String errorMsg = new KSError(this.loginTask.getErrorLines()).getErrorAsString();
                            this.loginTask = null;
                            throw new KSEngineLoginException(errorMsg);
                        }
                        this.loginTask.addErrorLine(line);
                        continue;
                    }
                    if (this.currentTask == null) {
                        LogService.getRoot().log(Level.SEVERE, () -> String.format("UNEXPECTED RESULT FROM KS ENGINE SOCKET WHILE NOT BUSY: %s", line));
                        throw new IllegalStateException("UNEXPECTED RESULT FROM KS ENGINE SOCKET WHILE NOT BUSY");
                    }
                    if (line.startsWith("#?! result")) {
                        this.currentTask.addResultLine(line);
                        continue;
                    }
                    if (line.startsWith("#?! error")) {
                        this.currentTask.addErrorLine(line);
                        continue;
                    }
                    if (this.currentTask.isReadingResult()) {
                        LogService.getRoot().log(Level.FINEST, "Reading KS engine query result line");
                        this.currentTask.addResultLine(line);
                        continue;
                    }
                    if (this.currentTask.isReadingError()) {
                        LogService.getRoot().log(Level.FINEST, "Reading KS engine error line");
                        this.currentTask.addErrorLine(line);
                        continue;
                    }
                    LogService.getRoot().log(Level.SEVERE, () -> String.format("UNEXPECTED STATE %d OF KS ENGINE QUERY TASK WHILE READING LINE: %s", this.currentTask.getState(), line));
                    throw new IllegalStateException("UNEXPECTED STATE OF KS ENGINE QUERY TASK WHILE READING LINE");
                }
            }
            catch (Exception e) {
                if (this.socketStatus == SocketStatus.CLOSED) {
                    this.notifyListenersConnectionFailure(this.errorCounter.incrementAndGet(), e);
                } else if (this.socketStatus == SocketStatus.LOGGING_IN) {
                    this.notifyListenersLoginFailure(e);
                } else {
                    LogService.getRoot().log(Level.SEVERE, "Error for KS socket connection: " + e.getMessage(), e);
                    if (this.currentTask != null) {
                        this.currentTask.markException(e);
                        this.completeQueryTaskAsync(this.currentTask);
                        this.currentTask = null;
                    }
                }
            }
            finally {
                this.closeSocketAndResetState(new KSEngineQueryProcessingException(new KSEngineShutdownException("KS engine bridge was shut down while processing")), false);
            }
        };
    }

    private Runnable createSubmissionSender() {
        return () -> {
            while (!this.shutdownRequested.get()) {
                try {
                    KSQueryTask task = this.queryQueue.poll(5L, TimeUnit.SECONDS);
                    if (task == null) continue;
                    LogService.getRoot().log(Level.FINER, "KS engine query found, waiting until KS engine can accept query");
                    this.submissionPhaser.awaitAdvance(this.phase.getAndIncrement());
                    this.currentTask = task;
                    this.setSocketStatus(SocketStatus.BUSY);
                    LogService.getRoot().log(Level.FINE, "KS engine query submitted");
                    String processedQuery = this.currentTask.getQuery().getProcessedQuery();
                    if (KSEngineSettings.INSTANCE.getDebugMode() == KSDebugMode.QUERY || KSEngineSettings.INSTANCE.getDebugMode() == KSDebugMode.ALL) {
                        System.out.println("Submitted query >>> " + processedQuery);
                    }
                    this.out.println(processedQuery);
                    if (!this.out.checkError()) continue;
                    LogService.getRoot().log(Level.WARNING, "KS engine query could not be submitted, will put it back into query queue");
                    if (!this.queryQueue.offer(this.currentTask)) {
                        LogService.getRoot().log(Level.SEVERE, "KS engine query could not be put back into queue because it was full, discarding!");
                    }
                    this.submissionPhaser.arriveAndDeregister();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        };
    }

    private void completeCurrentTask() {
        if (this.currentTask.isReadingResult()) {
            this.currentTask.markSuccessful();
        } else if (this.currentTask.isReadingError()) {
            this.currentTask.markError();
        } else {
            this.currentTask.markEmpty();
        }
        this.completeQueryTaskAsync(this.currentTask);
        this.currentTask = null;
        this.setSocketStatus(SocketStatus.READY);
        this.submissionPhaser.arrive();
    }

    private void completeQueryTaskAsync(KSQueryTask task) {
        Thread resultComputation = new Thread(task.getFutureTask());
        resultComputation.setDaemon(true);
        resultComputation.setName("ks-engine-result-parser");
        resultComputation.start();
    }

    private synchronized void setSocketStatus(SocketStatus status) {
        if (this.socketStatus != status) {
            this.socketStatus = status;
            this.notifyAllListeners(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersLoginFailure(Exception e) {
        List<KSEngineSocketListener> list = this.listenerList;
        synchronized (list) {
            for (KSEngineSocketListener listener : this.listenerList) {
                this.notifyListener(() -> listener.socketLoginFailed(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void notifyListenersConnectionFailure(int errorCount, Exception e) {
        List<KSEngineSocketListener> list = this.listenerList;
        synchronized (list) {
            for (KSEngineSocketListener listener : this.listenerList) {
                this.notifyListener(() -> listener.socketConnectionFailed(errorCount, e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllListeners(SocketStatus status) {
        List<KSEngineSocketListener> list = this.listenerList;
        synchronized (list) {
            this.notifyListeners(this.listenerList, status);
        }
    }

    private void notifyListeners(List<KSEngineSocketListener> listenerList, SocketStatus status) {
        block7: for (KSEngineSocketListener listener : listenerList) {
            switch (status) {
                case CONNECTED: {
                    this.notifyListener(listener::socketConnected);
                    continue block7;
                }
                case LOGGING_IN: {
                    continue block7;
                }
                case READY: {
                    this.notifyListener(listener::socketReady);
                    continue block7;
                }
                case BUSY: {
                    this.notifyListener(listener::socketBusy);
                    continue block7;
                }
                case CLOSED: {
                    this.notifyListener(listener::socketClosed);
                    continue block7;
                }
            }
            LogService.getRoot().log(Level.WARNING, () -> String.format("KS engine socket status %s not handled, cannot notify listeners!", new Object[]{status}));
            break;
        }
    }

    private void notifyListener(Runnable r) {
        try {
            this.listenerNotificationService.submit(r);
        }
        catch (RejectedExecutionException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to notify listener about KS engine lifecycle event", e);
        }
    }
}

