/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.bridge;

import com.altair.ks_engine.bridge.exception.KSEngineQueryProcessingException;
import com.altair.ks_engine.bridge.exception.KSEngineQueryResultException;
import com.altair.ks_engine.query.KSError;
import com.altair.ks_engine.query.KSQuery;
import com.altair.ks_engine.query.KSResult;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.FutureTask;

class KSQueryTask {
    private static final int STATE_READY = 0;
    private static final int STATE_READING_RESULT = 1;
    private static final int STATE_READING_ERROR = 2;
    private static final int STATE_SUCCESS = 3;
    private static final int STATE_ERROR = 4;
    private static final int STATE_EMPTY = 5;
    private static final int STATE_EXCEPTION = -1;
    private final KSQuery query;
    private final List<String> resultCollector;
    private final List<String> errorCollector;
    private final FutureTask<KSResult> futureTask;
    private Exception ex;
    private volatile int state;

    KSQueryTask(KSQuery query) {
        this.query = query;
        this.resultCollector = new ArrayList<String>();
        this.errorCollector = new ArrayList<String>();
        this.state = 0;
        this.futureTask = new FutureTask<KSResult>(() -> {
            if (this.isSuccess()) {
                return new KSResult(this.getResultLines());
            }
            if (this.isError()) {
                throw new KSEngineQueryResultException(new KSError(this.getErrorLines()));
            }
            if (this.isEmpty()) {
                return new KSResult();
            }
            if (this.isException()) {
                throw new KSEngineQueryProcessingException(this.getException());
            }
            throw new KSEngineQueryProcessingException(new IllegalStateException("KS engine query completion task was running before end state was reached!"));
        });
    }

    KSQuery getQuery() {
        return this.query;
    }

    void addResultLine(String line) {
        this.setState(1);
        this.resultCollector.add((String)ValidationUtilV2.requireNonNull((Object)line, (String)"line"));
    }

    void addErrorLine(String line) {
        this.setState(2);
        this.errorCollector.add((String)ValidationUtilV2.requireNonNull((Object)line, (String)"line"));
    }

    FutureTask<KSResult> getFutureTask() {
        return this.futureTask;
    }

    void markSuccessful() {
        this.setState(3);
    }

    void markError() {
        this.setState(4);
    }

    void markEmpty() {
        this.setState(5);
    }

    void markException(Exception ex) {
        ValidationUtilV2.requireNonNull((Object)ex, (String)"ex");
        this.setState(-1);
        this.ex = ex;
    }

    boolean isReadingResult() {
        return this.getState() == 1;
    }

    boolean isSuccess() {
        return this.getState() == 3;
    }

    boolean isReadingError() {
        return this.getState() == 2;
    }

    boolean isError() {
        return this.getState() == 4;
    }

    boolean isEmpty() {
        return this.getState() == 5;
    }

    boolean isException() {
        return this.getState() == -1;
    }

    List<String> getResultLines() {
        int curState = this.getState();
        if (curState != 3) {
            throw new IllegalStateException(String.format("Cannot get result because state was %d", curState));
        }
        return this.resultCollector;
    }

    List<String> getErrorLines() {
        int curState = this.getState();
        if (curState != 4) {
            throw new IllegalStateException(String.format("Cannot get error because state was %d", curState));
        }
        return this.errorCollector;
    }

    Exception getException() {
        int curState = this.getState();
        if (curState != -1) {
            throw new IllegalStateException(String.format("Cannot get exception because state was %d", curState));
        }
        return this.ex;
    }

    synchronized int getState() {
        return this.state;
    }

    private synchronized void setState(int newState) {
        int oldState = this.state;
        if (oldState == newState) {
            return;
        }
        switch (newState) {
            case 0: {
                throw new IllegalStateException(String.format("KS query task was already in state %d, but wanted to transition to ready", oldState));
            }
            case 1: 
            case 2: 
            case 5: {
                if (oldState == 0) break;
                throw new IllegalStateException(String.format("KS query task was already in state %d, but wanted to transition to %d", oldState, newState));
            }
            case 3: {
                if (oldState == 1) break;
                throw new IllegalStateException("KS query task was not in reading result state before success state transition");
            }
            case 4: {
                if (oldState == 2) break;
                throw new IllegalStateException("KS query task was not in reading error state before error state transition");
            }
            case -1: {
                if (oldState != 3 && oldState != 4) break;
                throw new IllegalStateException("KS query task was already in success / error state before exception state transition");
            }
            default: {
                throw new IllegalStateException(String.format("KS query task transition to unknown state: %d", newState));
            }
        }
        this.state = newState;
    }
}

