/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.bridge.installer;

import com.altair.ks_engine.bridge.exception.KSEngineInstallationException;
import com.altair.ks_engine.bridge.exception.KSEngineShutdownException;
import com.altair.ks_engine.bridge.exception.KSEngineStartupException;
import com.altair.ks_engine.bridge.installer.KSEngineInstaller;
import com.rapidminer.tools.DirectoryService;
import com.rapidminer.tools.FileUtils;
import com.rapidminer.tools.LogService;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.codec.digest.DigestUtils;

public abstract class InternalKSEngineInstaller
implements KSEngineInstaller {
    private final EngineZipStreamProvider streamProvider;
    private final Path targetFolder;
    private Process process;

    InternalKSEngineInstaller(EngineZipStreamProvider streamProvider) {
        this(streamProvider, DirectoryService.resolveInternalCacheDir((String)DirectoryService.INTERNAL_CACHE_KS_ENGINE, (String[])new String[0]));
    }

    InternalKSEngineInstaller(EngineZipStreamProvider streamProvider, Path targetFolder) {
        this.streamProvider = streamProvider;
        this.targetFolder = targetFolder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isEngineInstalled() throws KSEngineInstallationException {
        try {
            if (!Files.isDirectory(this.targetFolder, new LinkOption[0])) return false;
            if (FileUtils.isDirectoryEmpty((Path)this.targetFolder)) {
                return false;
            }
        }
        catch (IOException e) {
            throw new KSEngineInstallationException("failed to check engine installation target folder", e);
        }
        Map<String, String> hashCheckMap = this.getHashesToCheck();
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(this.streamProvider.newEngineZipStream()));){
            Path path;
            String hashOnDisk;
            String name;
            String hash;
            do {
                ZipEntry entry;
                if ((entry = zis.getNextEntry()) == null) return true;
                name = entry.getName();
                path = this.targetFolder.resolve(name);
                if (Files.exists(path, new LinkOption[0])) continue;
                boolean bl = false;
                return bl;
            } while ((hash = hashCheckMap.get(name)) == null || hash.equals(hashOnDisk = new DigestUtils(DigestUtils.getSha3_256Digest()).digestAsHex(path, new OpenOption[0])));
            LogService.getRoot().log(Level.INFO, "Wrong hash detected, reinstallation of ks engine required");
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new KSEngineInstallationException("failed to read packed engine", e);
        }
    }

    protected Map<String, String> getHashesToCheck() {
        return Collections.emptyMap();
    }

    @Override
    public synchronized void installEngine() throws KSEngineInstallationException {
        try {
            if (!Files.isDirectory(this.targetFolder, new LinkOption[0])) {
                if (Files.exists(this.targetFolder, new LinkOption[0])) {
                    Files.delete(this.targetFolder);
                }
                Files.createDirectories(this.targetFolder, new FileAttribute[0]);
            } else {
                org.apache.commons.io.FileUtils.cleanDirectory((File)this.targetFolder.toFile());
            }
        }
        catch (IOException e) {
            throw new KSEngineInstallationException("failed to prepare engine folder", e);
        }
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(this.streamProvider.newEngineZipStream()));){
            FileUtils.extractZipStream((Path)this.targetFolder, (ZipInputStream)zis);
        }
        catch (IOException e) {
            throw new KSEngineInstallationException("failed to unpack engine", e);
        }
        this.postInstall(this.targetFolder);
    }

    protected void postInstall(Path targetFolder) {
    }

    @Override
    public synchronized boolean isKSEngineRunning() {
        if (this.process == null) {
            return false;
        }
        return this.process.isAlive();
    }

    @Override
    public synchronized void startKSEngine(int port) throws KSEngineStartupException {
        try {
            Process exec = this.getPlatformProcessBuilder(this.targetFolder, port).start();
            InternalKSEngineInstaller.waitForStartup(exec);
            if (!exec.isAlive()) {
                String collect = "";
                if (exec.getErrorStream().available() > 0) {
                    collect = new BufferedReader(new InputStreamReader(exec.getErrorStream())).lines().collect(Collectors.joining("\n"));
                } else {
                    LogService.getRoot().log(Level.WARNING, "No error stream available for failed engine startup");
                }
                throw new KSEngineStartupException("engine terminated abnormally with exit value " + exec.exitValue() + ": " + collect);
            }
            this.process = exec;
        }
        catch (IOException e) {
            throw new KSEngineStartupException("failed to start the engine", e);
        }
    }

    @Override
    public synchronized boolean isKSEngineShutdownPossible() {
        return this.process != null;
    }

    @Override
    public synchronized void shutdownKSEngine() throws KSEngineShutdownException {
        if (this.process == null) {
            return;
        }
        this.process.destroy();
        if (this.process.isAlive()) {
            try {
                this.process.waitFor(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new KSEngineShutdownException("waiting for engine shutdown was interrupted");
            }
        }
        if (this.process.isAlive()) {
            throw new KSEngineShutdownException("failed to shutdown engine process");
        }
        this.process = null;
    }

    protected abstract ProcessBuilder getPlatformProcessBuilder(Path var1, int var2);

    private static void waitForStartup(Process process) {
        try {
            process.waitFor(1500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static interface EngineZipStreamProvider {
        public InputStream newEngineZipStream() throws KSEngineInstallationException;
    }
}

