/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.bridge.installer;

import com.altair.ks_engine.bridge.installer.InternalKSEngineInstaller;
import com.rapidminer.tools.LogService;
import java.nio.file.Path;
import java.util.Map;
import java.util.logging.Level;

public class LinuxKSEngineInstaller
extends InternalKSEngineInstaller {
    public LinuxKSEngineInstaller(InternalKSEngineInstaller.EngineZipStreamProvider streamProvider) {
        super(streamProvider);
    }

    LinuxKSEngineInstaller(InternalKSEngineInstaller.EngineZipStreamProvider streamProvider, Path targetFolder) {
        super(streamProvider, targetFolder);
    }

    @Override
    protected Map<String, String> getHashesToCheck() {
        return Map.of("lib/kslogin", "a077cccdecfb61b90640b42f572be4d632ba38f1bcaaf0f689d7e28e93c7a03b");
    }

    @Override
    protected ProcessBuilder getPlatformProcessBuilder(Path engineFolder, int port) {
        Path exePath = engineFolder.resolve("lib").resolve("kslogin");
        ProcessBuilder platformProcessBuilder = new ProcessBuilder(exePath.toString(), "--no-daemon", "ssl=false", "port=" + port);
        Map<String, String> environment = platformProcessBuilder.environment();
        Object newLibraryPath = engineFolder.resolve("lib").toString();
        String libPathName = this.getLibraryPathName();
        String libraryPath = environment.get(libPathName);
        if (libraryPath != null && !libraryPath.isBlank()) {
            newLibraryPath = (String)newLibraryPath + ":" + libraryPath;
        }
        environment.put(libPathName, (String)newLibraryPath);
        return platformProcessBuilder;
    }

    protected String getLibraryPathName() {
        return "LD_LIBRARY_PATH";
    }

    @Override
    protected void postInstall(Path targetFolder) {
        boolean executable = targetFolder.resolve("lib").resolve("kslogin").toFile().setExecutable(true);
        if (!executable) {
            LogService.getRoot().log(Level.WARNING, "Failed to make kslogin executable");
        }
    }
}

