/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.clients;

import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceInvalidNameException;
import com.altair.ks_engine.clients.KSEngineDataStatisticsClient;
import com.altair.ks_engine.clients.KSEngineDataStatisticsClientImpl;
import com.altair.ks_engine.clients.KSEngineModelClient;
import com.altair.ks_engine.clients.KSEngineModelClientImpl;
import com.altair.ks_engine.clients.KSEngineTreeModelClient;
import com.altair.ks_engine.clients.KSEngineTreeModelClientImpl;
import com.altair.ks_engine.clients.KSEngineWorkspaceDataClient;
import com.altair.ks_engine.clients.KSEngineWorkspaceDataClientImpl;
import com.altair.ks_engine.clients.KSEngineWorkspaceModelClient;
import com.altair.ks_engine.clients.KSEngineWorkspaceModelClientImpl;
import com.altair.ks_engine.clients.KSEngineWorkspacesClient;
import com.altair.ks_engine.clients.KSEngineWorkspacesClientImpl;
import com.altair.ks_engine.util.KSEngineTools;

public final class KSEngineClients {
    static final String WORKSPACE_DOES_NOT_EXIST = "Workspace does not exist";
    static final String DATA_DOES_NOT_EXIST = "Data does not exist";
    static final String MODEL_DOES_NOT_EXIST = "Model does not exist";

    private KSEngineClients() {
        throw new UnsupportedOperationException("Static factory class");
    }

    public static KSEngineWorkspacesClient newWorkspacesClient() {
        return new KSEngineWorkspacesClientImpl();
    }

    public static KSEngineWorkspaceDataClient newWorkspaceDataClient(String workspace) throws KSEngineWorkspaceInvalidNameException {
        return new KSEngineWorkspaceDataClientImpl(KSEngineTools.stripSquareBracketsAndValidateStorageName(workspace));
    }

    public static KSEngineWorkspaceModelClient newWorkspaceModelClient(String workspace) throws KSEngineWorkspaceInvalidNameException {
        return new KSEngineWorkspaceModelClientImpl(KSEngineTools.stripSquareBracketsAndValidateStorageName(workspace));
    }

    public static KSEngineDataStatisticsClient newDataStatisticsClient(String workspace) throws KSEngineWorkspaceInvalidNameException {
        return new KSEngineDataStatisticsClientImpl(KSEngineTools.stripSquareBracketsAndValidateStorageName(workspace));
    }

    public static KSEngineModelClient newModelClient(String workspace) throws KSEngineWorkspaceInvalidNameException {
        return new KSEngineModelClientImpl(KSEngineTools.stripSquareBracketsAndValidateStorageName(workspace));
    }

    public static KSEngineTreeModelClient newTreeModelClient(String workspace) throws KSEngineWorkspaceInvalidNameException {
        return new KSEngineTreeModelClientImpl(KSEngineTools.stripSquareBracketsAndValidateStorageName(workspace));
    }
}

