/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.clients;

import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceDataNotFoundException;
import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceException;
import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceInvalidNameException;
import com.altair.ks_engine.clients.KSEngineClients;
import com.altair.ks_engine.clients.KSEngineDataStatisticsClient;
import com.altair.ks_engine.clients.KSEngineWorkspaceDataClient;
import com.altair.ks_engine.clients.KSWorkspaceQuery;
import com.altair.ks_engine.clients.WorkspaceTools;
import com.altair.ks_engine.dto.ColumnCardinality;
import com.altair.ks_engine.models.KSCasesQuerySectionBuilder;
import com.altair.ks_engine.models.KSTreeModelToWhereQuerySectionBuilder;
import com.altair.ks_engine.query.KSQueryParameter;
import com.altair.ks_engine.util.KSEngineTools;
import com.rapidminer.belt.table.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

final class KSEngineDataStatisticsClientImpl
implements KSEngineDataStatisticsClient {
    private final String workspace;
    private final KSEngineWorkspaceDataClient dataClient;
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String COLUMN_CARDINALITY = "COLUMN_CARDINALITY";
    private static final String COLUMN_TYPE = "DATA_TYPE";
    private static final String QUERY_GET_COLUMN_CARDINALITY = "SELECT COLUMN_NAME, COLUMN_CARDINALITY, DATA_TYPE from OPENSCHEMA('columns', '%s', missing, '%s')";
    private static final String QUERY_GET_COLUMN_NAMES = "SELECT COLUMN_NAME from OPENSCHEMA('columns', '%s', missing, '%s')";
    private static final String COLUMN_NAME_COUNT = "Count";
    private static final String QUERY_RANGE_COUNTS = "SELECT CASE %s END AS [Index], cast(sum(1) as double) AS [Count] from TABLE [%s].[%s] GROUP BY [Index] WHERE %s";
    private static final String QUERY_RANGE_COUNTS_ROOT = "SELECT CASE %s END AS [Index], cast(sum(1) as double) AS [Count] from TABLE [%s].[%s] GROUP BY [Index]";

    KSEngineDataStatisticsClientImpl(String workspace) throws KSEngineWorkspaceInvalidNameException {
        this.workspace = workspace;
        this.dataClient = KSEngineClients.newWorkspaceDataClient(workspace);
    }

    @Override
    public List<String> getColumnNames(String data) throws KSEngineWorkspaceException {
        this.ensureDataExists(data);
        Table table = WorkspaceTools.getTable(new KSWorkspaceQuery(QUERY_GET_COLUMN_NAMES, this.workspace, data));
        return WorkspaceTools.getCategoricalColumnAsList(table, COLUMN_NAME);
    }

    @Override
    public List<Integer> getCounts(String data, KSCasesQuerySectionBuilder casesBuilder, KSTreeModelToWhereQuerySectionBuilder whereBuilder) throws KSEngineWorkspaceException {
        this.ensureDataExists(data);
        ArrayList<KSQueryParameter> paramsToValidate = new ArrayList<KSQueryParameter>();
        ArrayList<KSQueryParameter> uncheckedParams = new ArrayList<KSQueryParameter>();
        uncheckedParams.add(new KSQueryParameter(0, casesBuilder.build().getQueryRepresentation()));
        paramsToValidate.add(new KSQueryParameter(1, this.workspace));
        paramsToValidate.add(new KSQueryParameter(2, data));
        String where = whereBuilder.build().getQueryRepresentation();
        if (!where.isEmpty()) {
            uncheckedParams.add(new KSQueryParameter(3, where));
        }
        Table table = WorkspaceTools.getTable(new KSWorkspaceQuery(where.isEmpty() ? QUERY_RANGE_COUNTS_ROOT : QUERY_RANGE_COUNTS, paramsToValidate, uncheckedParams, KSWorkspaceQuery.ValidationType.STORAGE_NAME));
        return WorkspaceTools.getNumericColumnAsList(table, COLUMN_NAME_COUNT).stream().map(Double::intValue).collect(Collectors.toList());
    }

    @Override
    public List<ColumnCardinality> getCardinalityForColumns(String data) throws KSEngineWorkspaceException {
        this.ensureDataExists(data);
        Table table = WorkspaceTools.getTable(new KSWorkspaceQuery(QUERY_GET_COLUMN_CARDINALITY, this.workspace, data));
        List<String> nameList = WorkspaceTools.getCategoricalColumnAsList(table, COLUMN_NAME);
        List<Double> cardinalityList = WorkspaceTools.getNumericColumnAsList(table, COLUMN_CARDINALITY);
        int[] typeArray = WorkspaceTools.getNumericColumnAsList(table, COLUMN_TYPE).stream().mapToInt(Double::intValue).toArray();
        try {
            ArrayList<ColumnCardinality> resultList = new ArrayList<ColumnCardinality>();
            for (int i = 0; i < nameList.size(); ++i) {
                resultList.add(new ColumnCardinality(nameList.get(i), cardinalityList.get(i).intValue(), KSEngineTools.getTypeIdForKSDBDataType(typeArray[i])));
            }
            return resultList;
        }
        catch (IllegalArgumentException e) {
            throw new KSEngineWorkspaceException(e.getMessage());
        }
    }

    private void ensureDataExists(String data) throws KSEngineWorkspaceException {
        if (!this.dataClient.doesDataExist(data)) {
            throw new KSEngineWorkspaceDataNotFoundException("Data does not exist", this.workspace, data);
        }
    }
}

