/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.clients;

import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceDataNotFoundException;
import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceException;
import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceInvalidNameException;
import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceModelNotFoundException;
import com.altair.ks_engine.clients.KSEngineClients;
import com.altair.ks_engine.clients.KSEngineModelClient;
import com.altair.ks_engine.clients.KSEngineWorkspaceDataClient;
import com.altair.ks_engine.clients.KSEngineWorkspaceModelClient;
import com.altair.ks_engine.clients.KSWorkspaceQuery;
import com.altair.ks_engine.clients.WorkspaceTools;
import com.altair.ks_engine.models.KSModel;
import com.altair.ks_engine.query.KSQueryParameter;
import com.rapidminer.belt.table.Table;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.IntStream;

final class KSEngineModelClientImpl
implements KSEngineModelClient {
    private static final String PARAMETER_NAME = "PARAMETER_NAME";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String INSERT_ACTIVE = "INSERT_ACTIVE";
    private static final String PARAMETER_VALUE = "PARAMETER_VALUE";
    private static final String QUERY_BEGIN_TRANSACTION = "BEGIN TRANSACTION ON MODEL [%s].[%s]";
    private static final String QUERY_BEGIN_TRANSACTION_WINDOW_4 = "BEGIN TRANSACTION ON MODEL [%s].[%s] WINDOW 4";
    private static final String QUERY_COMMIT_TRANSACTION = "COMMIT TRANSACTION ON MODEL [%s].[%s]";
    private static final String QUERY_ROLLBACK_TRANSACTION = "ROLLBACK TRANSACTION ON MODEL [%s].[%s]";
    private static final String QUERY_CREATE_MODEL = "CREATE MINING MODEL [%s].[%s] (%s) Using [%s] (%s,DataSource='[%s].[%s]') FROM [%s].[%s]";
    private static final String QUERY_ALTER_MODEL = "ALTER MODEL [%s].[%s] %s";
    private static final String QUERY_TRAIN_MODEL = "INSERT INTO [%s].[%s] FROM (SELECT %s FROM TABLE [%s].[%s])";
    private static final String QUERY_RENDER_SCHEMA = "SELECT SCHEMARENDER('[%s].[%s]')";
    private static final String QUERY_MODEL_SETTINGS = "SELECT PARAMETER_NAME, PARAMETER_VALUE FROM OPENSCHEMA('model_parameters','[%s]',missing,'%s')";
    private static final String QUERY_MODEL_COLUMNS_ALL = "SELECT * FROM OPENSCHEMA('variables','[%s]',missing,'%s')";
    private static final String QUERY_MODEL_COLUMNS_ACTIVE = "SELECT COLUMN_NAME, INSERT_ACTIVE FROM OPENSCHEMA('variables','[%s]',missing,'%s')";
    private final String workspace;
    private final KSEngineWorkspaceDataClient dataClient;
    private final KSEngineWorkspaceModelClient modelClient;

    KSEngineModelClientImpl(String workspace) throws KSEngineWorkspaceInvalidNameException {
        this.workspace = workspace;
        this.dataClient = KSEngineClients.newWorkspaceDataClient(workspace);
        this.modelClient = KSEngineClients.newWorkspaceModelClient(workspace);
    }

    @Override
    public void beginTransaction(String model) throws KSEngineWorkspaceException {
        WorkspaceTools.awaitResult(new KSWorkspaceQuery(QUERY_BEGIN_TRANSACTION, this.workspace, model));
    }

    @Override
    public void beginWindowTransaction(String model) throws KSEngineWorkspaceException {
        WorkspaceTools.awaitResult(new KSWorkspaceQuery(QUERY_BEGIN_TRANSACTION_WINDOW_4, this.workspace, model));
    }

    @Override
    public void commitTransaction(String model) throws KSEngineWorkspaceException {
        WorkspaceTools.awaitResult(new KSWorkspaceQuery(QUERY_COMMIT_TRANSACTION, this.workspace, model));
    }

    @Override
    public void rollbackTransaction(String model) throws KSEngineWorkspaceException {
        WorkspaceTools.awaitResult(new KSWorkspaceQuery(QUERY_ROLLBACK_TRANSACTION, this.workspace, model));
    }

    @Override
    public void createModelFromData(String model, String data, KSModel modelType) throws KSEngineWorkspaceException {
        ValidationUtilV2.requireNonNull((Object)modelType, (String)"modelType");
        this.ensureDataExists(data);
        ArrayList<KSQueryParameter> paramsToValidate = new ArrayList<KSQueryParameter>();
        ArrayList<KSQueryParameter> uncheckedParams = new ArrayList<KSQueryParameter>();
        paramsToValidate.add(new KSQueryParameter(0, this.workspace));
        paramsToValidate.add(new KSQueryParameter(1, model));
        uncheckedParams.add(new KSQueryParameter(2, modelType.getColumnSectionBuilder().build().getQueryRepresentation()));
        uncheckedParams.add(new KSQueryParameter(3, modelType.getModel()));
        uncheckedParams.add(new KSQueryParameter(4, modelType.getSettingsSectionBuilder().build().getQueryRepresentation()));
        paramsToValidate.add(new KSQueryParameter(5, this.workspace));
        paramsToValidate.add(new KSQueryParameter(6, data));
        paramsToValidate.add(new KSQueryParameter(7, this.workspace));
        paramsToValidate.add(new KSQueryParameter(8, data));
        WorkspaceTools.awaitResult(new KSWorkspaceQuery(QUERY_CREATE_MODEL, paramsToValidate, uncheckedParams, KSWorkspaceQuery.ValidationType.STORAGE_NAME));
    }

    @Override
    public void alterModelSettings(String model, KSModel modelType) throws KSEngineWorkspaceException {
        ValidationUtilV2.requireNonNull((Object)modelType, (String)"modelType");
        this.ensureModelExists(model);
        ArrayList<KSQueryParameter> paramsToValidate = new ArrayList<KSQueryParameter>();
        ArrayList<KSQueryParameter> uncheckedParams = new ArrayList<KSQueryParameter>();
        paramsToValidate.add(new KSQueryParameter(0, this.workspace));
        paramsToValidate.add(new KSQueryParameter(1, model));
        uncheckedParams.add(new KSQueryParameter(2, modelType.getSettingsSectionBuilder().build().getQueryRepresentation()));
        WorkspaceTools.awaitResult(new KSWorkspaceQuery(QUERY_ALTER_MODEL, paramsToValidate, uncheckedParams, KSWorkspaceQuery.ValidationType.STORAGE_NAME));
    }

    @Override
    public void trainModelOnData(String model, String data) throws KSEngineWorkspaceException {
        this.ensureDataExists(data);
        this.ensureModelExists(model);
        StringJoiner joiner = new StringJoiner("], [", "[", "]");
        this.getActiveModelColumns(model).forEach(joiner::add);
        ArrayList<KSQueryParameter> paramsToValidate = new ArrayList<KSQueryParameter>();
        ArrayList<KSQueryParameter> uncheckedParams = new ArrayList<KSQueryParameter>();
        paramsToValidate.add(new KSQueryParameter(0, this.workspace));
        paramsToValidate.add(new KSQueryParameter(1, model));
        uncheckedParams.add(new KSQueryParameter(2, joiner.toString()));
        paramsToValidate.add(new KSQueryParameter(3, this.workspace));
        paramsToValidate.add(new KSQueryParameter(4, data));
        WorkspaceTools.awaitResult(new KSWorkspaceQuery(QUERY_TRAIN_MODEL, paramsToValidate, uncheckedParams, KSWorkspaceQuery.ValidationType.STORAGE_NAME));
    }

    @Override
    public String getRendererSchema(String model) throws KSEngineWorkspaceException {
        this.ensureModelExists(model);
        return Optional.ofNullable(WorkspaceTools.getOnlyCellStringValue(WorkspaceTools.getTable(new KSWorkspaceQuery(QUERY_RENDER_SCHEMA, this.workspace, model)))).orElse("");
    }

    @Override
    public Map<String, String> getModelSettings(String model) throws KSEngineWorkspaceException {
        this.ensureModelExists(model);
        Table table = WorkspaceTools.getTable(new KSWorkspaceQuery(QUERY_MODEL_SETTINGS, this.workspace, model));
        List<String> paramList = WorkspaceTools.getCategoricalColumnAsList(table, PARAMETER_NAME);
        List<String> valueList = WorkspaceTools.getCategoricalColumnAsList(table, PARAMETER_VALUE);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int i = 0; i < paramList.size(); ++i) {
            paramMap.put(paramList.get(i), valueList.get(i));
        }
        return paramMap;
    }

    @Override
    public Table getModelColumnInformation(String model) throws KSEngineWorkspaceException {
        this.ensureModelExists(model);
        return WorkspaceTools.getTable(new KSWorkspaceQuery(QUERY_MODEL_COLUMNS_ALL, this.workspace, model));
    }

    @Override
    public List<String> getActiveModelColumns(String model) throws KSEngineWorkspaceException {
        this.ensureModelExists(model);
        Table table = WorkspaceTools.getTable(new KSWorkspaceQuery(QUERY_MODEL_COLUMNS_ACTIVE, this.workspace, model));
        List<String> colNames = WorkspaceTools.getCategoricalColumnAsList(table, COLUMN_NAME);
        List<String> active = WorkspaceTools.getCategoricalColumnAsList(table, INSERT_ACTIVE);
        ArrayList<String> activeColumns = new ArrayList<String>();
        IntStream.range(0, colNames.size()).forEach(i -> {
            if (Boolean.parseBoolean((String)active.get(i))) {
                activeColumns.add((String)colNames.get(i));
            }
        });
        return activeColumns;
    }

    private void ensureModelExists(String model) throws KSEngineWorkspaceException {
        if (!this.modelClient.doesModelExist(model)) {
            throw new KSEngineWorkspaceModelNotFoundException("Model does not exist", this.workspace, model);
        }
    }

    private void ensureDataExists(String data) throws KSEngineWorkspaceException {
        if (!this.dataClient.doesDataExist(data)) {
            throw new KSEngineWorkspaceDataNotFoundException("Data does not exist", this.workspace, data);
        }
    }
}

