/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.clients;

import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceDataNotFoundException;
import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceException;
import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceInvalidNameException;
import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceModelNotFoundException;
import com.altair.ks_engine.clients.KSEngineClients;
import com.altair.ks_engine.clients.KSEngineModelClient;
import com.altair.ks_engine.clients.KSEngineTreeModelClient;
import com.altair.ks_engine.clients.KSEngineWorkspaceDataClient;
import com.altair.ks_engine.clients.KSEngineWorkspaceModelClient;
import com.altair.ks_engine.clients.KSWorkspaceQuery;
import com.altair.ks_engine.clients.WorkspaceTools;
import com.altair.ks_engine.models.KSSplitEditQuerySectionBuilder;
import com.altair.ks_engine.models.KSTreeNodeRenderQuerySectionBuilder;
import com.altair.ks_engine.query.KSQueryParameter;
import com.altair.ks_engine.util.KSEngineTools;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.ArrayList;
import java.util.Optional;
import java.util.StringJoiner;

final class KSEngineTreeModelClientImpl
implements KSEngineTreeModelClient {
    private static final String QUERY_RENDER_NODE = "SELECT NODERENDER('[%s].[%s]', '%s')";
    private static final String QUERY_TRAIN_PARTIAL_MODEL = "INSERT INTO MODEL [%s].[%s] WHERE node_unique_name='%s' SELECT %s FROM TABLE [%s].[%s]";
    private static final String QUERY_TRAIN_PARTIAL_MODEL_KEEP_SPLITS = "INSERT INTO MODEL [%s].[%s] WHERE (node_leaves = 1 and node_unique_name='%s.') SELECT %s FROM TABLE [%s].[%s]";
    private static final String QUERY_DELETE_CHILD_NODES = "DELETE * FROM MODEL [%s].[%s] WHERE parent_unique_name='%s'";
    private static final String QUERY_CHANGE_SPLIT = "UPDATE MODEL [%s].[%s] set NODE_ACTIVE = false where PARENT_UNIQUE_NAME = '%s';UPDATE MODEL [%s].[%s] set NODE_ACTIVE = true where NODE_UNIQUE_NAME = '%s.%s'";
    private static final String QUERY_EDIT_SPLIT = "INSERT INTO MODEL [%s].[%s] WHERE node_unique_name='%s' from xml '%s' SELECT %s FROM TABLE [%s].[%s]";
    private final String workspace;
    private final KSEngineWorkspaceDataClient dataClient;
    private final KSEngineWorkspaceModelClient modelWSClient;
    private final KSEngineModelClient modelClient;

    KSEngineTreeModelClientImpl(String workspace) throws KSEngineWorkspaceInvalidNameException {
        this.workspace = workspace;
        this.dataClient = KSEngineClients.newWorkspaceDataClient(workspace);
        this.modelWSClient = KSEngineClients.newWorkspaceModelClient(workspace);
        this.modelClient = KSEngineClients.newModelClient(workspace);
    }

    @Override
    public String getTreeRenderNodes(String model, KSTreeNodeRenderQuerySectionBuilder renderNodeBuilder) throws KSEngineWorkspaceException {
        ValidationUtilV2.requireNonNull((Object)renderNodeBuilder, (String)"renderNodeBuilder");
        this.ensureModelExists(model);
        ArrayList<KSQueryParameter> paramsToValidate = new ArrayList<KSQueryParameter>();
        ArrayList<KSQueryParameter> uncheckedParams = new ArrayList<KSQueryParameter>();
        paramsToValidate.add(new KSQueryParameter(0, this.workspace));
        paramsToValidate.add(new KSQueryParameter(1, model));
        uncheckedParams.add(new KSQueryParameter(2, renderNodeBuilder.build().getQueryRepresentation()));
        return Optional.ofNullable(WorkspaceTools.getOnlyCellStringValue(WorkspaceTools.getTable(new KSWorkspaceQuery(QUERY_RENDER_NODE, paramsToValidate, uncheckedParams, KSWorkspaceQuery.ValidationType.STORAGE_NAME)))).orElse("");
    }

    @Override
    public void trainPartialModelOnData(String model, String data, String nodeID, boolean keepExistingSplits) throws KSEngineWorkspaceException {
        KSEngineTools.checkNodeIDValidity(nodeID);
        this.ensureDataExists(data);
        this.ensureModelExists(model);
        StringJoiner joiner = new StringJoiner("], [", "[", "]");
        this.modelClient.getActiveModelColumns(model).forEach(joiner::add);
        ArrayList<KSQueryParameter> paramsToValidate = new ArrayList<KSQueryParameter>();
        ArrayList<KSQueryParameter> uncheckedParams = new ArrayList<KSQueryParameter>();
        paramsToValidate.add(new KSQueryParameter(0, this.workspace));
        paramsToValidate.add(new KSQueryParameter(1, model));
        uncheckedParams.add(new KSQueryParameter(2, nodeID));
        uncheckedParams.add(new KSQueryParameter(3, joiner.toString()));
        paramsToValidate.add(new KSQueryParameter(4, this.workspace));
        paramsToValidate.add(new KSQueryParameter(5, data));
        WorkspaceTools.awaitResult(new KSWorkspaceQuery(keepExistingSplits ? QUERY_TRAIN_PARTIAL_MODEL_KEEP_SPLITS : QUERY_TRAIN_PARTIAL_MODEL, paramsToValidate, uncheckedParams, KSWorkspaceQuery.ValidationType.STORAGE_NAME));
    }

    @Override
    public void removeChildNodes(String model, String nodeID) throws KSEngineWorkspaceException {
        KSEngineTools.checkNodeIDValidity(nodeID);
        this.ensureModelExists(model);
        ArrayList<KSQueryParameter> paramsToValidate = new ArrayList<KSQueryParameter>();
        ArrayList<KSQueryParameter> uncheckedParams = new ArrayList<KSQueryParameter>();
        paramsToValidate.add(new KSQueryParameter(0, this.workspace));
        paramsToValidate.add(new KSQueryParameter(1, model));
        uncheckedParams.add(new KSQueryParameter(2, nodeID));
        WorkspaceTools.awaitResult(new KSWorkspaceQuery(QUERY_DELETE_CHILD_NODES, paramsToValidate, uncheckedParams, KSWorkspaceQuery.ValidationType.STORAGE_NAME));
    }

    @Override
    public void setSplit(String model, String nodeID, String ivID) throws KSEngineWorkspaceException {
        KSEngineTools.checkNodeIDValidity(nodeID);
        ValidationUtilV2.requireNonEmptyString((String)ivID, (String)"ivID");
        this.ensureModelExists(model);
        ArrayList<KSQueryParameter> paramsToValidate = new ArrayList<KSQueryParameter>();
        ArrayList<KSQueryParameter> uncheckedParams = new ArrayList<KSQueryParameter>();
        paramsToValidate.add(new KSQueryParameter(0, this.workspace));
        paramsToValidate.add(new KSQueryParameter(1, model));
        uncheckedParams.add(new KSQueryParameter(2, nodeID));
        paramsToValidate.add(new KSQueryParameter(3, this.workspace));
        paramsToValidate.add(new KSQueryParameter(4, model));
        uncheckedParams.add(new KSQueryParameter(5, nodeID));
        paramsToValidate.add(new KSQueryParameter(6, ivID));
        WorkspaceTools.awaitResult(new KSWorkspaceQuery(QUERY_CHANGE_SPLIT, paramsToValidate, uncheckedParams, KSWorkspaceQuery.ValidationType.STORAGE_NAME));
    }

    @Override
    public void editSplit(String model, String data, String nodeID, KSSplitEditQuerySectionBuilder splitEditBuilder) throws KSEngineWorkspaceException {
        KSEngineTools.checkNodeIDValidity(nodeID);
        this.ensureDataExists(data);
        this.ensureModelExists(model);
        ValidationUtilV2.requireNonNull((Object)splitEditBuilder, (String)"splitEditBuilder");
        StringJoiner joiner = new StringJoiner("], [", "[", "]");
        this.modelClient.getActiveModelColumns(model).forEach(joiner::add);
        ArrayList<KSQueryParameter> paramsToValidate = new ArrayList<KSQueryParameter>();
        ArrayList<KSQueryParameter> uncheckedParams = new ArrayList<KSQueryParameter>();
        paramsToValidate.add(new KSQueryParameter(0, this.workspace));
        paramsToValidate.add(new KSQueryParameter(1, model));
        uncheckedParams.add(new KSQueryParameter(2, nodeID));
        uncheckedParams.add(new KSQueryParameter(3, splitEditBuilder.build().getQueryRepresentation()));
        uncheckedParams.add(new KSQueryParameter(4, joiner.toString()));
        paramsToValidate.add(new KSQueryParameter(5, this.workspace));
        paramsToValidate.add(new KSQueryParameter(6, data));
        WorkspaceTools.awaitResult(new KSWorkspaceQuery(QUERY_EDIT_SPLIT, paramsToValidate, uncheckedParams, KSWorkspaceQuery.ValidationType.STORAGE_NAME));
    }

    private void ensureModelExists(String model) throws KSEngineWorkspaceException {
        if (!this.modelWSClient.doesModelExist(model)) {
            throw new KSEngineWorkspaceModelNotFoundException("Model does not exist", this.workspace, model);
        }
    }

    private void ensureDataExists(String data) throws KSEngineWorkspaceException {
        if (!this.dataClient.doesDataExist(data)) {
            throw new KSEngineWorkspaceDataNotFoundException("Data does not exist", this.workspace, data);
        }
    }
}

