/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.clients;

import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceDataAlreadyExistsException;
import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceDataNotFoundException;
import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceException;
import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceNotFoundException;
import com.altair.ks_engine.clients.KSEngineClients;
import com.altair.ks_engine.clients.KSEngineWorkspaceDataClient;
import com.altair.ks_engine.clients.KSEngineWorkspacesClient;
import com.altair.ks_engine.clients.KSWorkspaceQuery;
import com.altair.ks_engine.clients.TableWriter;
import com.altair.ks_engine.clients.WorkspaceTools;
import com.altair.ks_engine.util.KSEngineTools;
import com.rapidminer.belt.table.Table;
import com.rapidminer.settings.Settings;
import com.rapidminer.tools.IOTools;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

final class KSEngineWorkspaceDataClientImpl
implements KSEngineWorkspaceDataClient {
    private static final String COLUMN_TABLES = "TABLE_NAME";
    private static final String QUERY_DELETE_DATA_QUIETLY = "DROP TABLE [%s].[%s] QUIETLY";
    private static final String QUERY_GET_TABLE = "SELECT [TABLE_NAME] FROM OPENSCHEMA('tables', '[%s]') WHERE TABLE_NAME = '%s'";
    private static final String QUERY_GET_DATA_IN_WORKSPACE = "SELECT * FROM [%s].[%s]";
    private static final String QUERY_GET_ALL_DATA_IN_WORKSPACE = "SELECT [TABLE_NAME] FROM OPENSCHEMA('tables', '[%s]')";
    private static final String QUERY_RENAME_DATA = "RENAME TABLE [%s].[%s] TO [%s].[%s]";
    private static final String RM_HDF5TABLE_SUFFIX = ".rmhdf5table";
    private final String workspace;
    private final KSEngineWorkspacesClient workspacesClient;

    KSEngineWorkspaceDataClientImpl(String workspace) {
        this.workspace = workspace;
        this.workspacesClient = KSEngineClients.newWorkspacesClient();
    }

    @Override
    public List<String> getDataListInWorkspace() throws KSEngineWorkspaceException {
        boolean exists = this.workspacesClient.doesWorkspaceExist(this.workspace);
        if (!exists) {
            throw new KSEngineWorkspaceNotFoundException("Workspace does not exist", this.workspace);
        }
        return WorkspaceTools.getCategoricalColumnAsList(WorkspaceTools.getTable(new KSWorkspaceQuery(QUERY_GET_ALL_DATA_IN_WORKSPACE, this.workspace)), COLUMN_TABLES);
    }

    @Override
    public boolean doesDataExist(String data) throws KSEngineWorkspaceException {
        if (!this.workspacesClient.doesWorkspaceExist(this.workspace)) {
            return false;
        }
        return !WorkspaceTools.getCategoricalColumnAsList(WorkspaceTools.getTable(new KSWorkspaceQuery(QUERY_GET_TABLE, this.workspace, data)), COLUMN_TABLES).isEmpty();
    }

    @Override
    public Table getDataAsTable(String data) throws KSEngineWorkspaceException {
        boolean exists = this.doesDataExist(data);
        if (!exists) {
            throw new KSEngineWorkspaceDataNotFoundException("Data does not exist", this.workspace, data);
        }
        return WorkspaceTools.getTable(new KSWorkspaceQuery(QUERY_GET_DATA_IN_WORKSPACE, this.workspace, data));
    }

    @Override
    public void addDataToWorkspace(String data, Path dataPath) throws KSEngineWorkspaceException {
        ValidationUtilV2.requireNonNull((Object)dataPath, (String)"dataPath");
        if (!dataPath.toString().endsWith(RM_HDF5TABLE_SUFFIX)) {
            throw new KSEngineWorkspaceException("The specified dataPath is not a Data Table");
        }
        try {
            this.writeDataToWorkspace(this.prepareTargetPathInWorkspace(data), Files.newInputStream(dataPath, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new KSEngineWorkspaceException("Failed to add data to workspace", e);
        }
    }

    @Override
    public void addDataToWorkspace(String data, Table dataTable, TableWriter writer) throws KSEngineWorkspaceException {
        ValidationUtilV2.requireNonNull((Object)dataTable, (String)"dataTable");
        ValidationUtilV2.requireNonNull((Object)writer, (String)"writer");
        try {
            writer.writeTable(dataTable, this.prepareTargetPathInWorkspace(data));
        }
        catch (IOException e) {
            throw new KSEngineWorkspaceException("Failed to add data to workspace", e);
        }
    }

    @Override
    public void renameData(String data, String newName) throws KSEngineWorkspaceException {
        boolean exists = this.doesDataExist(data);
        if (!exists) {
            throw new KSEngineWorkspaceDataNotFoundException("Data does not exist", this.workspace, data);
        }
        boolean existsNew = this.doesDataExist(newName);
        if (existsNew) {
            throw new KSEngineWorkspaceDataAlreadyExistsException("Model new name already exists", this.workspace, newName);
        }
        WorkspaceTools.awaitResult(new KSWorkspaceQuery(QUERY_RENAME_DATA, this.workspace, data, this.workspace, newName));
    }

    @Override
    public void deleteDataFromWorkspace(String data) throws KSEngineWorkspaceException {
        WorkspaceTools.awaitResult(new KSWorkspaceQuery(QUERY_DELETE_DATA_QUIETLY, this.workspace, data));
    }

    private Path prepareTargetPathInWorkspace(String data) throws IOException, KSEngineWorkspaceException {
        data = KSEngineTools.stripSquareBracketsAndValidateStorageName(data);
        boolean exists = this.workspacesClient.doesWorkspaceExist(this.workspace);
        if (!exists) {
            throw new KSEngineWorkspaceNotFoundException("Workspace does not exist", this.workspace);
        }
        this.deleteDataFromWorkspace(data);
        String workspaceRoot = Settings.getSetting((String)"altair-library", (String)"ks-engine-workspace-location");
        Path parentPath = Paths.get(workspaceRoot, this.workspace);
        Path targetPath = parentPath.resolve(data + RM_HDF5TABLE_SUFFIX);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        return targetPath;
    }

    private void writeDataToWorkspace(Path targetPath, InputStream dataStream) throws IOException {
        IOTools.copyStreamSynchronously((InputStream)dataStream, (OutputStream)Files.newOutputStream(targetPath, StandardOpenOption.CREATE), (boolean)true);
    }
}

