/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.clients;

import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceException;
import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceModelAlreadyExistsException;
import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceModelNotFoundException;
import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceNotFoundException;
import com.altair.ks_engine.clients.KSEngineClients;
import com.altair.ks_engine.clients.KSEngineWorkspaceModelClient;
import com.altair.ks_engine.clients.KSEngineWorkspacesClient;
import com.altair.ks_engine.clients.KSWorkspaceQuery;
import com.altair.ks_engine.clients.WorkspaceTools;
import com.altair.ks_engine.util.KSEngineTools;
import com.rapidminer.settings.Settings;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

final class KSEngineWorkspaceModelClientImpl
implements KSEngineWorkspaceModelClient {
    private static final String COLUMN_MODELS = "MODEL_NAME";
    private static final String QUERY_DELETE_MODEL_QUIETLY = "DROP MODEL [%s].[%s] QUIETLY";
    private static final String QUERY_GET_MODEL = "SELECT [MODEL_NAME] FROM OPENSCHEMA('models', '%s') WHERE MODEL_NAME = '%s'";
    private static final String QUERY_GET_ALL_MODELS_IN_WORKSPACE = "SELECT [MODEL_NAME] FROM OPENSCHEMA('models', '[%s]')";
    private static final String QUERY_RENAME_MODEL = "RENAME MODEL [%s].[%s] TO [%s].[%s]";
    private static final String KS_MODEL_SUFFIX = ".kdm";
    private final String workspace;
    private final KSEngineWorkspacesClient workspacesClient;

    KSEngineWorkspaceModelClientImpl(String workspace) {
        this.workspace = workspace;
        this.workspacesClient = KSEngineClients.newWorkspacesClient();
    }

    @Override
    public List<String> getModelListInWorkspace() throws KSEngineWorkspaceException {
        boolean exists = this.workspacesClient.doesWorkspaceExist(this.workspace);
        if (!exists) {
            throw new KSEngineWorkspaceNotFoundException("Workspace does not exist", this.workspace);
        }
        return WorkspaceTools.getCategoricalColumnAsList(WorkspaceTools.getTable(new KSWorkspaceQuery(QUERY_GET_ALL_MODELS_IN_WORKSPACE, this.workspace)), COLUMN_MODELS);
    }

    @Override
    public boolean doesModelExist(String model) throws KSEngineWorkspaceException {
        if (!this.workspacesClient.doesWorkspaceExist(this.workspace)) {
            return false;
        }
        return !WorkspaceTools.getCategoricalColumnAsList(WorkspaceTools.getTable(new KSWorkspaceQuery(QUERY_GET_MODEL, this.workspace, model)), COLUMN_MODELS).isEmpty();
    }

    @Override
    public void addModelToWorkspace(String model, String modelXML) throws KSEngineWorkspaceException {
        ValidationUtilV2.requireNonEmptyString((String)modelXML, (String)"modelXML");
        try {
            this.writeModelToWorkspace(model, modelXML);
        }
        catch (IOException e) {
            throw new KSEngineWorkspaceException("Failed to add model to workspace", e);
        }
    }

    @Override
    public void renameModel(String model, String newName) throws KSEngineWorkspaceException {
        boolean exists = this.doesModelExist(model);
        if (!exists) {
            throw new KSEngineWorkspaceModelNotFoundException("Model does not exist", this.workspace, model);
        }
        boolean existsNew = this.doesModelExist(newName);
        if (existsNew) {
            throw new KSEngineWorkspaceModelAlreadyExistsException("Model new name already exists", this.workspace, newName);
        }
        WorkspaceTools.awaitResult(new KSWorkspaceQuery(QUERY_RENAME_MODEL, this.workspace, model, this.workspace, newName));
    }

    @Override
    public void deleteModelFromWorkspace(String model) throws KSEngineWorkspaceException {
        WorkspaceTools.awaitResult(new KSWorkspaceQuery(QUERY_DELETE_MODEL_QUIETLY, this.workspace, model));
    }

    private void writeModelToWorkspace(String model, String modelXML) throws IOException, KSEngineWorkspaceException {
        model = KSEngineTools.stripSquareBracketsAndValidateStorageName(model);
        boolean exists = this.workspacesClient.doesWorkspaceExist(this.workspace);
        if (!exists) {
            throw new KSEngineWorkspaceNotFoundException("Workspace does not exist", this.workspace);
        }
        this.deleteModelFromWorkspace(model);
        String workspaceRoot = Settings.getSetting((String)"altair-library", (String)"ks-engine-workspace-location");
        Path parentPath = Paths.get(workspaceRoot, this.workspace);
        Path targetPath = parentPath.resolve(model + KS_MODEL_SUFFIX);
        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        Files.write(targetPath, modelXML.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
    }
}

