/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.clients;

import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceAlreadyExistsException;
import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceException;
import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceNotFoundException;
import com.altair.ks_engine.clients.KSEngineWorkspacesClient;
import com.altair.ks_engine.clients.KSWorkspaceQuery;
import com.altair.ks_engine.clients.WorkspaceTools;
import java.util.List;

final class KSEngineWorkspacesClientImpl
implements KSEngineWorkspacesClient {
    private static final String COLUMN_WORKSPACES = "CATALOG_NAME";
    private static final String QUERY_GET_ALL_WORKSPACES = "SELECT [CATALOG_NAME] FROM OPENSCHEMA('catalogs')";
    private static final String QUERY_GET_WORKSPACE = "SELECT [CATALOG_NAME] FROM OPENSCHEMA('catalogs') WHERE CATALOG_NAME = '[%s]'";
    private static final String QUERY_CREATE_WORKSPACE = "CREATE DATABASE [%s]";
    private static final String QUERY_RENAME_WORKSPACE = "RENAME DATABASE [%s] TO [%s]";
    private static final String QUERY_DELETE_WORKSPACE = "IF DATABASE EXISTS ('[%s]') DROP DATABASE [%s]";

    KSEngineWorkspacesClientImpl() {
    }

    @Override
    public List<String> getWorkspaces() throws KSEngineWorkspaceException {
        return WorkspaceTools.getCategoricalColumnAsList(WorkspaceTools.getTable(new KSWorkspaceQuery(QUERY_GET_ALL_WORKSPACES, new String[0])), COLUMN_WORKSPACES);
    }

    @Override
    public boolean doesWorkspaceExist(String workspace) throws KSEngineWorkspaceException {
        return !WorkspaceTools.getCategoricalColumnAsList(WorkspaceTools.getTable(new KSWorkspaceQuery(QUERY_GET_WORKSPACE, workspace)), COLUMN_WORKSPACES).isEmpty();
    }

    @Override
    public void createWorkspace(String workspace, boolean errorIfExists) throws KSEngineWorkspaceException {
        boolean exists = this.doesWorkspaceExist(workspace);
        if (exists) {
            if (errorIfExists) {
                throw new KSEngineWorkspaceAlreadyExistsException("Workspace already exists", workspace);
            }
            return;
        }
        WorkspaceTools.awaitResult(new KSWorkspaceQuery(QUERY_CREATE_WORKSPACE, workspace));
    }

    @Override
    public void renameWorkspace(String workspace, String newName) throws KSEngineWorkspaceException {
        boolean exists = this.doesWorkspaceExist(workspace);
        if (!exists) {
            throw new KSEngineWorkspaceNotFoundException("Workspace to rename does not exist", workspace);
        }
        boolean existsNew = this.doesWorkspaceExist(newName);
        if (existsNew) {
            throw new KSEngineWorkspaceAlreadyExistsException("Workspace new name already exists", newName);
        }
        WorkspaceTools.awaitResult(new KSWorkspaceQuery(QUERY_RENAME_WORKSPACE, workspace, newName));
    }

    @Override
    public void deleteWorkspace(String workspace) throws KSEngineWorkspaceException {
        WorkspaceTools.awaitResult(new KSWorkspaceQuery(QUERY_DELETE_WORKSPACE, workspace, workspace));
    }
}

