/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.clients;

import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceInvalidNameException;
import com.altair.ks_engine.query.KSQuery;
import com.altair.ks_engine.query.KSQueryParameter;
import com.altair.ks_engine.util.KSEngineTools;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

final class KSWorkspaceQuery
extends KSQuery {
    private final String processedQuery;

    KSWorkspaceQuery(String query, String ... names) throws KSEngineWorkspaceInvalidNameException {
        this(query, ValidationType.STORAGE_NAME, names);
    }

    KSWorkspaceQuery(String query, ValidationType validationType, String ... names) throws KSEngineWorkspaceInvalidNameException {
        this(query, IntStream.range(0, names.length).mapToObj(i -> new KSQueryParameter(i, names[i])).collect(Collectors.toList()), Collections.emptyList(), validationType);
    }

    KSWorkspaceQuery(String query, List<KSQueryParameter> parametersToValidate, List<KSQueryParameter> uncheckedParameters, ValidationType validationType) throws KSEngineWorkspaceInvalidNameException {
        super(query);
        boolean anyParameters;
        boolean bl = anyParameters = !parametersToValidate.isEmpty() || !uncheckedParameters.isEmpty();
        if (anyParameters) {
            Object[] newParams = new String[parametersToValidate.size() + uncheckedParameters.size()];
            for (KSQueryParameter toValidateParam : parametersToValidate) {
                if (validationType == ValidationType.STORAGE_NAME) {
                    newParams[toValidateParam.getIndex()] = KSEngineTools.stripSquareBracketsAndValidateStorageName(toValidateParam.getValue());
                    continue;
                }
                newParams[toValidateParam.getIndex()] = KSEngineTools.stripSquareBracketsAndValidateColumnName(toValidateParam.getValue());
            }
            for (KSQueryParameter uncheckedParam : uncheckedParameters) {
                newParams[uncheckedParam.getIndex()] = uncheckedParam.getValue();
            }
            this.processedQuery = String.format(query, newParams);
        } else {
            this.processedQuery = query;
        }
    }

    @Override
    public String getProcessedQuery() {
        return this.processedQuery;
    }

    static enum ValidationType {
        STORAGE_NAME,
        COLUMN_NAME;

    }
}

