/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.clients;

import com.altair.ks_engine.bridge.KSEngineBridge;
import com.altair.ks_engine.bridge.exception.KSEngineQueryProcessingException;
import com.altair.ks_engine.bridge.exception.KSEngineQueryResultException;
import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceException;
import com.altair.ks_engine.query.KSQuery;
import com.altair.ks_engine.query.KSResult;
import com.altair.ks_engine.util.KSEngineTools;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.column.Dictionary;
import com.rapidminer.belt.reader.CategoricalReader;
import com.rapidminer.belt.reader.NumericReader;
import com.rapidminer.belt.reader.ObjectReader;
import com.rapidminer.belt.reader.Readers;
import com.rapidminer.belt.table.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

final class WorkspaceTools
extends Enum<WorkspaceTools> {
    private static final String DEFAULT_COLUMN_NAME = "__1__";
    private static final /* synthetic */ WorkspaceTools[] $VALUES;

    public static WorkspaceTools[] values() {
        return (WorkspaceTools[])$VALUES.clone();
    }

    public static WorkspaceTools valueOf(String name) {
        return Enum.valueOf(WorkspaceTools.class, name);
    }

    static String getOnlyCellStringValue(Table table) throws KSEngineWorkspaceException {
        Column col = table.column(DEFAULT_COLUMN_NAME);
        if (col == null) {
            throw new KSEngineWorkspaceException(String.format("Column %s does not exist!", DEFAULT_COLUMN_NAME));
        }
        if (col.type().category() != Column.Category.CATEGORICAL) {
            throw new KSEngineWorkspaceException(String.format("Column %s is not categorical but %s!", DEFAULT_COLUMN_NAME, col.type().category()));
        }
        ObjectReader reader = Readers.objectReader((Column)col, String.class);
        if (!reader.hasRemaining()) {
            throw new KSEngineWorkspaceException("No rows returned, cannot extract cell!");
        }
        return (String)reader.read();
    }

    static List<String> getCategoricalColumnAsList(Table table, String colName) throws KSEngineWorkspaceException {
        ArrayList<String> resultList = new ArrayList<String>();
        Column col = table.column(colName);
        if (col == null) {
            throw new KSEngineWorkspaceException(String.format("Column %s does not exist!", DEFAULT_COLUMN_NAME));
        }
        if (col.type().category() != Column.Category.CATEGORICAL) {
            throw new KSEngineWorkspaceException(String.format("Column %s is not categorical but %s!", DEFAULT_COLUMN_NAME, col.type().category()));
        }
        Dictionary dictionary = col.getDictionary();
        CategoricalReader colReader = Readers.categoricalReader((Column)col);
        while (colReader.hasRemaining()) {
            String val = dictionary.get(colReader.read());
            resultList.add(KSEngineTools.stripSquareBrackets(val));
        }
        return resultList;
    }

    static List<Double> getNumericColumnAsList(Table table, String colName) throws KSEngineWorkspaceException {
        ArrayList<Double> resultList = new ArrayList<Double>();
        Column col = table.column(colName);
        if (col == null) {
            throw new KSEngineWorkspaceException(String.format("Column %s does not exist!", DEFAULT_COLUMN_NAME));
        }
        if (col.type().category() != Column.Category.NUMERIC) {
            throw new KSEngineWorkspaceException(String.format("Column %s is not numeric but %s!", DEFAULT_COLUMN_NAME, col.type().category()));
        }
        NumericReader colReader = Readers.numericReader((Column)col);
        while (colReader.hasRemaining()) {
            resultList.add(colReader.read());
        }
        return resultList;
    }

    static KSResult awaitResult(KSQuery query) throws KSEngineWorkspaceException {
        try {
            return KSEngineBridge.INSTANCE.submitQuery(query).get(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KSEngineWorkspaceException("Workspace query was interrupted", e);
        }
        catch (Exception e) {
            if (e.getCause() instanceof KSEngineQueryResultException) {
                KSEngineQueryResultException resultException = (KSEngineQueryResultException)e.getCause();
                throw new KSEngineWorkspaceException(resultException.getError().getErrorAsString());
            }
            if (e.getCause() instanceof KSEngineQueryProcessingException) {
                KSEngineQueryProcessingException processingException = (KSEngineQueryProcessingException)e.getCause();
                Throwable rootCause = processingException.getCause();
                throw new KSEngineWorkspaceException("Workspace query failed: " + rootCause.getMessage(), rootCause);
            }
            throw new KSEngineWorkspaceException("Workspace query failed: " + e.getMessage(), e);
        }
    }

    static Table getTable(KSQuery query) throws KSEngineWorkspaceException {
        Table tableResult = WorkspaceTools.awaitResult(query).getResultAsTable();
        if (tableResult == null) {
            throw new KSEngineWorkspaceException("No data table returned by KS engine for workspace query");
        }
        return tableResult;
    }

    private static /* synthetic */ WorkspaceTools[] $values() {
        return new WorkspaceTools[0];
    }

    static {
        $VALUES = WorkspaceTools.$values();
    }
}

